/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.download;

import com.ejie.r01f.servlet.download.DownloadContentReader;
import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01f.sql.DBManager;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DataBaseDownloadReader
implements DownloadContentReader {
    private static final String OID = "oid";
    private Properties _props = null;
    private Map _params = null;

    @Override
    public void setConfig(Properties props) {
        this._props = props;
    }

    @Override
    public InputStream getBinaryStream() throws IOException {
        if (this._props == null) {
            throw new IOException(this.getClass().getName() + ": Error de configuracion, no se ha definido la seccion uploadServlet/digesters/digester[@id='..']/config dentro del fichero properties de la aplicacion");
        }
        if (this._props.getProperty("appCode") == null) {
            throw new IOException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'appCode' que define la aplicacion");
        }
        if (this._props.getProperty("connection") == null) {
            throw new IOException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'connection' que define la conexion a base de datos a utilizar");
        }
        if (this._props.getProperty("table") == null) {
            throw new IOException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'table' que define la tabla en donde se guarda el contenido");
        }
        if (this._props.getProperty("oidColumn") == null) {
            throw new IOException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'oidColumn' que define la columna que guarda el oid del registro");
        }
        if (this._props.getProperty("blobColumn") == null) {
            throw new IOException(this.getClass().getName() + ": Error de configuracion, no se ha definido la propiedad 'blobColumn' que define la columna que guarda el blob con el contenido");
        }
        try {
            Properties conxProps = BDConnectionHelpper.obtainConnectionProperties(this._props.getProperty("appCode"), this._props.getProperty("connection"));
            DBManager dbMan = new DBManager(conxProps);
            HashMap<String, String> pk = new HashMap<String, String>();
            pk.put(this._props.getProperty("oidColumn"), this.getResourceName());
            return dbMan.getBLOBInputStream(this._props.getProperty("table"), this._props.getProperty("blobColumn"), pk);
        }
        catch (SQLException sqlEx) {
            throw new IOException("Error de base de datos al obtener un inputStream al BLOB:\n" + sqlEx.getMessage());
        }
    }

    @Override
    public void setRequestParams(Map params) {
        this._params = params;
    }

    @Override
    public String getResourceName() {
        return (String)this._params.get(OID);
    }
}

