/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet;

import com.ejie.r01f.servlet.ParameterNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletRequest;

public class RequestParamParser {
    private ServletRequest _req;
    private String _encoding;

    public RequestParamParser() {
    }

    public RequestParamParser(ServletRequest req) {
        this._req = req;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        new String("".getBytes("8859_1"), encoding);
        this._encoding = encoding;
    }

    public String getStringParameter(String name) throws ParameterNotFoundException {
        String[] values = this._req.getParameterValues(name);
        if (values == null) {
            throw new ParameterNotFoundException(name + " not found");
        }
        if (values[0].length() == 0) {
            throw new ParameterNotFoundException(name + " was empty");
        }
        if (this._encoding == null) {
            return values[0];
        }
        try {
            return new String(values[0].getBytes("8859_1"), this._encoding);
        }
        catch (UnsupportedEncodingException ueEx) {
            return values[0];
        }
    }

    public String getStringParameter(String name, String def) {
        try {
            return this.getStringParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public boolean getBooleanParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        String value = this.getStringParameter(name).toLowerCase();
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("si")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new NumberFormatException("El parametro " + name + " con valor =" + value + " NO es un boolean!!");
    }

    public boolean getBooleanParameter(String name, boolean def) throws NumberFormatException {
        try {
            return this.getBooleanParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public byte getByteParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Byte.parseByte(this.getStringParameter(name));
    }

    public byte getByteParameter(String name, byte def) throws NumberFormatException {
        try {
            return this.getByteParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public char getCharParameter(String name) throws ParameterNotFoundException {
        String param = this.getStringParameter(name);
        if (param.length() == 0) {
            throw new ParameterNotFoundException(name + " is empty string");
        }
        return param.charAt(0);
    }

    public char getCharParameter(String name, char def) {
        try {
            return this.getCharParameter(name);
        }
        catch (Exception e) {
            return def;
        }
    }

    public double getDoubleParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return new Double(this.getStringParameter(name));
    }

    public double getDoubleParameter(String name, double def) throws NumberFormatException {
        try {
            return this.getDoubleParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public float getFloatParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return new Float(this.getStringParameter(name)).floatValue();
    }

    public float getFloatParameter(String name, float def) throws NumberFormatException {
        try {
            return this.getFloatParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public int getIntParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringParameter(name));
    }

    public int getIntParameter(String name, int def) {
        try {
            return this.getIntParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public long getLongParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Long.parseLong(this.getStringParameter(name));
    }

    public long getLongParameter(String name, long def) throws NumberFormatException {
        try {
            return this.getLongParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public short getShortParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Short.parseShort(this.getStringParameter(name));
    }

    public short getShortParameter(String name, short def) throws NumberFormatException {
        try {
            return this.getShortParameter(name);
        }
        catch (ParameterNotFoundException pnfEx) {
            return def;
        }
    }

    public String[] getMissingParameters(String[] required) {
        Vector<String> missing = new Vector<String>();
        for (int i = 0; i < required.length; ++i) {
            String val = this.getStringParameter(required[i], null);
            if (val != null) continue;
            missing.addElement(required[i]);
        }
        if (missing.size() == 0) {
            return null;
        }
        Object[] ret = new String[missing.size()];
        missing.copyInto(ret);
        return ret;
    }

    public static Map parseParameters(String data, String encoding) throws UnsupportedEncodingException {
        if (data != null && data.length() > 0) {
            byte[] bytes = null;
            try {
                bytes = encoding == null ? data.getBytes() : data.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return RequestParamParser.parseParameters(bytes, encoding);
        }
        return null;
    }

    public static Map parseParameters(byte[] data, String encoding) throws UnsupportedEncodingException {
        if (data != null && data.length > 0) {
            HashMap outMap = new HashMap();
            boolean pos = false;
            int ix = 0;
            int ox = 0;
            String key = null;
            String value = null;
            block6: while (ix < data.length) {
                byte c = data[ix++];
                switch ((char)c) {
                    case '&': {
                        value = new String(data, 0, ox, encoding);
                        if (key != null) {
                            RequestParamParser._putMapEntry(outMap, key, value);
                            key = null;
                        }
                        ox = 0;
                        continue block6;
                    }
                    case '=': {
                        if (key == null) {
                            key = new String(data, 0, ox, encoding);
                            ox = 0;
                            continue block6;
                        }
                        data[ox++] = c;
                        continue block6;
                    }
                    case '+': {
                        data[ox++] = 32;
                        continue block6;
                    }
                    case '%': {
                        data[ox++] = (byte)((RequestParamParser._convertHexDigit(data[ix++]) << 4) + RequestParamParser._convertHexDigit(data[ix++]));
                        continue block6;
                    }
                }
                data[ox++] = c;
            }
            if (key != null) {
                value = new String(data, 0, ox, encoding);
                RequestParamParser._putMapEntry(outMap, key, value);
            }
            return outMap;
        }
        return null;
    }

    private static void _putMapEntry(Map map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = (String[])map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    private static byte _convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }
}

