/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet;

import com.ejie.r01f.log.R01FLog;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RequestDebugInfoFormatter {
    public static String composeDebugInfo(ServletRequest request) {
        StringBuffer debugInfo = new StringBuffer("");
        debugInfo.append("Character Encoding: " + request.getCharacterEncoding() + "\n");
        debugInfo.append("Content-Length: " + request.getContentLength() + "\n");
        debugInfo.append("Content-Type: " + request.getContentType() + "\n");
        debugInfo.append("Protocol/Scheme: " + request.getProtocol() + request.getScheme() + "\n");
        debugInfo.append("Remote Addr/Host/Server Name: " + request.getRemoteAddr() + " " + request.getRemoteHost() + " " + request.getServerName() + "\n");
        debugInfo.append("Server Port: " + request.getServerPort() + "\n");
        debugInfo.append("-----Request Attributes-----\n");
        String auxName = null;
        Enumeration en = request.getAttributeNames();
        while (en.hasMoreElements()) {
            auxName = (String)en.nextElement();
            debugInfo.append("    " + auxName + ": (" + request.getAttribute(auxName).getClass().getName() + ")" + request.getAttribute(auxName).toString() + "\n");
        }
        debugInfo.append("-----Request Parameters-----\n");
        Object currEntry = null;
        return debugInfo.toString();
    }

    public static String composeDebugInfo(HttpServletRequest req) {
        StringBuffer debugInfo = new StringBuffer(RequestDebugInfoFormatter.composeDebugInfo((ServletRequest)req));
        debugInfo.append("-----Headers-----\n");
        String currHeaderName = null;
        Enumeration en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            currHeaderName = (String)en.nextElement();
            debugInfo.append("    " + currHeaderName + " = " + req.getHeader(currHeaderName) + "\n");
        }
        debugInfo.append("-----Cookies-----\n");
        Cookie[] cookies = null;
        cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                debugInfo.append("    [" + cookies[i].getDomain() + "]:" + cookies[i].getName() + "= " + cookies[i].getValue() + "\n");
            }
        }
        debugInfo.append("-----Session-----\n");
        HttpSession ses = req.getSession();
        if (ses == null) {
            debugInfo.append("    No hay Session\n");
        } else {
            debugInfo.append("    Session id: " + ses.getId() + "\n");
            if (ses.getAttributeNames() != null) {
                String currAttrName = null;
                Object currAttrValue = null;
                Enumeration en2 = ses.getAttributeNames();
                while (en2.hasMoreElements()) {
                    currAttrName = (String)en2.nextElement();
                    currAttrValue = ses.getAttribute(currAttrName);
                    R01FLog.getLogger("r01f.servlet").info("    " + currAttrName + ": (" + currAttrValue.getClass().getName() + "): " + currAttrValue.toString() + "\n");
                }
            }
        }
        return debugInfo.toString();
    }
}

