/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet;

import com.ejie.r01f.file.DirectoryExtractor;
import com.ejie.r01f.log.R01FLog;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class JspRegisterGenerator {
    private static String _fileSeparator = System.getProperty("file.separator");

    public String generateJspRegisterTagsAsString(String jspDocRoot, String webAppRoot, String webAppRootRelativeJspDocRoot) {
        Map tagsMap = this._generateJspRegisterTags(jspDocRoot, webAppRoot, webAppRootRelativeJspDocRoot);
        StringBuffer sb = new StringBuffer("");
        if (tagsMap != null) {
            Iterator it;
            if (tagsMap.get("servletDefs") != null) {
                it = ((Map)tagsMap.get("servletDefs")).values().iterator();
                while (it.hasNext()) {
                    sb.append((String)it.next());
                }
            }
            if (tagsMap.get("servletMappings") != null) {
                it = ((Map)tagsMap.get("servletMappings")).values().iterator();
                while (it.hasNext()) {
                    sb.append((String)it.next());
                }
            }
            return sb.toString();
        }
        return "";
    }

    public Map generateJspRegisterTags(String jspDocRoot, String webAppRoot, String webAppRootRelativeJspDocRoot) {
        return this._generateJspRegisterTags(jspDocRoot, webAppRoot, webAppRootRelativeJspDocRoot);
    }

    private Map _generateJspRegisterTags(String jspDocRoot, String webAppRoot, String webAppRelativeJspDocRoot) {
        HashMap outMap = new HashMap();
        HashMap<String, String> servletDefs = new HashMap<String, String>();
        HashMap<String, String> servletMappings = new HashMap<String, String>();
        outMap.put("servletDefs", servletDefs);
        outMap.put("servletMappings", servletMappings);
        jspDocRoot = this._rTrimFinalFileSeparator(jspDocRoot);
        webAppRoot = this._rTrimFinalFileSeparator(webAppRoot);
        webAppRelativeJspDocRoot = this._trimFinalFileSeparator(webAppRelativeJspDocRoot);
        R01FLog.getLogger("r01f.util").info("Raiz de los documentos JSP: " + jspDocRoot);
        R01FLog.getLogger("r01f.util").info("Raiz del WEBAPP: " + webAppRoot);
        R01FLog.getLogger("r01f.util").info("Raiz relativa al WEBAPP de los JSP: " + webAppRelativeJspDocRoot);
        FileFilter jspFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".jsp");
            }
        };
        DirectoryExtractor dw = new DirectoryExtractor(jspDocRoot);
        Collection files = dw.getFilesAndDirectories(jspFilter);
        if (files != null && !files.isEmpty()) {
            for (File currJspFile : files) {
                String currJspFileName = currJspFile.getName().trim();
                String currJspServletName = this._getServletName(currJspFile, webAppRoot, webAppRelativeJspDocRoot);
                String currJspWebAppRelativePath = _fileSeparator + this._getRelativeJspPath(currJspFile, webAppRoot, webAppRelativeJspDocRoot, true);
                String currJspContextRelativePath = this._getRelativeJspPath(currJspFile, webAppRoot, webAppRelativeJspDocRoot, false);
                StringBuffer sbServletDef = new StringBuffer("");
                sbServletDef.append("<servlet>\r\n");
                sbServletDef.append("\t<servlet-name>" + currJspServletName + "</servlet-name>\r\n");
                sbServletDef.append("\t<jsp-file>" + currJspWebAppRelativePath + "</jsp-file>\r\n");
                sbServletDef.append("</servlet>\r\n");
                servletDefs.put(currJspContextRelativePath, sbServletDef.toString());
                StringBuffer sbServletMapping = new StringBuffer("");
                sbServletMapping.append("<servlet-mapping>\r\n");
                sbServletMapping.append("\t<servlet-name>" + currJspServletName + "</servlet-name>\r\n");
                sbServletMapping.append("\t<url-pattern>" + currJspContextRelativePath + "</url-pattern>\r\n");
                sbServletMapping.append("</servlet-mapping>\r\n");
                servletMappings.put(currJspContextRelativePath, sbServletMapping.toString());
            }
        }
        return outMap;
    }

    private String _getRelativeJspPath(File file, String webAppRoot, String webAppRelativeJspDocRoot, boolean webAppRelative) {
        String jspRelativePath = "";
        if (webAppRelative) {
            jspRelativePath = webAppRelativeJspDocRoot + _fileSeparator;
        }
        StringTokenizer st = new StringTokenizer(file.getAbsolutePath(), _fileSeparator);
        String currPath = "";
        while (st.hasMoreTokens() && !(currPath = currPath + st.nextToken() + _fileSeparator).equals(webAppRoot + _fileSeparator + webAppRelativeJspDocRoot + _fileSeparator)) {
        }
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken();
            if (currToken.endsWith(".jsp")) {
                jspRelativePath = jspRelativePath + currToken;
                continue;
            }
            jspRelativePath = jspRelativePath + currToken + _fileSeparator;
        }
        return jspRelativePath;
    }

    private String _getServletName(File file, String webAppRoot, String webAppRelativeJspDocRoot) {
        String servletName = "";
        StringTokenizer st = new StringTokenizer(file.getAbsolutePath(), _fileSeparator);
        String currPath = "";
        while (st.hasMoreTokens() && !(currPath = currPath + st.nextToken() + _fileSeparator).equals(webAppRoot + _fileSeparator + webAppRelativeJspDocRoot + _fileSeparator)) {
        }
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken();
            if (currToken.endsWith(".jsp")) {
                servletName = servletName + currToken.substring(0, currToken.length() - 4);
                continue;
            }
            servletName = servletName + currToken;
        }
        return servletName;
    }

    private String _trimFinalFileSeparator(String path) {
        String trimmedPath = path;
        trimmedPath = this._rTrimFinalFileSeparator(trimmedPath);
        return this._lTrimFinalFileSeparator(trimmedPath);
    }

    private String _rTrimFinalFileSeparator(String path) {
        String trimmedPath = path.trim();
        if (!trimmedPath.endsWith(_fileSeparator)) {
            return trimmedPath;
        }
        int pos = trimmedPath.lastIndexOf(_fileSeparator);
        return trimmedPath.substring(0, pos);
    }

    private String _lTrimFinalFileSeparator(String path) {
        String trimmedPath = path.trim();
        if (!trimmedPath.startsWith(_fileSeparator)) {
            return trimmedPath;
        }
        int pos = trimmedPath.indexOf(_fileSeparator);
        return trimmedPath.substring(pos + 1);
    }

    public static void main(String[] argv) {
        try {
            JspRegisterGenerator jspReg = new JspRegisterGenerator();
            R01FLog.to("r01f.test").info(jspReg.generateJspRegisterTagsAsString("d:\\ejie\\aplic\\p85\\html\\", "d:\\ejie\\aplic\\p85\\", "\\html\\"));
        }
        catch (Throwable t) {
            R01FLog.to("r01f.test").info(t.toString());
            t.printStackTrace(System.out);
        }
        System.exit(0);
    }
}

