/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher.search;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.rpcdispatcher.RPCContext;
import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.rpcdispatcher.RPCExec;
import com.ejie.r01f.rpcdispatcher.search.Search;
import com.ejie.r01f.rpcdispatcher.search.SearchException;
import com.ejie.r01f.rpcdispatcher.search.SearchParameters;

public abstract class SearchRPCExec
extends RPCExec {
    public SearchRPCExec() {
    }

    public SearchRPCExec(RPCContext otherContext) {
        super(otherContext);
    }

    public abstract Search getSearchObject(String var1) throws RPCException;

    public abstract String getSearchSessionVariableName(String var1) throws RPCException;

    public abstract String getSearchResultsPresentationPage(String var1) throws RPCException;

    public abstract SearchParameters getSearchParameters(String var1, String var2) throws RPCException;

    public void search(String searchID, String searchParamsStr) throws RPCException {
        Search buscador = this.getSearchObject(searchID);
        if (buscador == null) {
            throw new RPCException(this.rpcContext, "Error al inicializar la busqueda, el buscador devuelto es nulo");
        }
        try {
            R01FLog.to("r01f.rpcSearch").info("Inicializando busqueda '" + searchID + "' con los parametros: " + searchParamsStr);
            SearchParameters searchParams = this.getSearchParameters(searchID, searchParamsStr);
            buscador.initSearch(searchID, searchParams);
            buscador.doSearch(searchID);
        }
        catch (SearchException srchEx) {
            throw new RPCException(this.rpcContext, srchEx.toString());
        }
        this.rpcContext.getSession(true).setAttribute(this.getSearchSessionVariableName(searchID), (Object)buscador);
        this.rpcContext.targetPage = this.getSearchResultsPresentationPage(searchID);
    }

    public void buscadorNextPg(String searchID) throws RPCException {
        try {
            if (this.rpcContext.getSession(false) != null) {
                R01FLog.to("r01f.rpcSearch").info("Ir a la siguiente P\u00e1gina de la b\u00fasqueda '" + searchID + "'");
                Search buscador = (Search)this.rpcContext.getSession(false).getAttribute(this.getSearchSessionVariableName(searchID));
                if (buscador != null) {
                    buscador.paginas.goToNextPage();
                }
                buscador.doSearch(searchID);
            } else {
                R01FLog.to("r01f.rpcSearch").info("Se ha perdido la sesi\u00f3n, no se puede ir a la siguiente P\u00e1gina de la b\u00fasqueda '" + searchID + "'");
            }
        }
        catch (SearchException srchEx) {
            throw new RPCException(this.rpcContext, srchEx.toString());
        }
        this.rpcContext.targetPage = this.getSearchResultsPresentationPage(searchID);
    }

    public void buscadorPg(String searchID, int pageNumber) throws RPCException {
        try {
            if (this.rpcContext.getSession(false) != null) {
                R01FLog.to("r01f.rpcSearch").info("Ir a la p\u00e1gina '" + pageNumber + "' de la b\u00fasqueda '" + searchID + "'");
                Search buscador = (Search)this.rpcContext.getSession(false).getAttribute(this.getSearchSessionVariableName(searchID));
                if (buscador != null) {
                    buscador.paginas.goToPage(pageNumber);
                }
                buscador.doSearch(searchID);
            } else {
                R01FLog.to("r01f.rpcSearch").info("Se ha perdido la sesi\u00f3n, no se puede ir a la P\u00e1gina de la b\u00fasqueda '" + searchID + "'");
            }
        }
        catch (SearchException srchEx) {
            throw new RPCException(this.rpcContext, srchEx.toString());
        }
        this.rpcContext.targetPage = this.getSearchResultsPresentationPage(searchID);
    }

    public void buscadorPrevPg(String searchID) throws RPCException {
        try {
            if (this.rpcContext.getSession(false) != null) {
                R01FLog.to("r01f.rpcSearch").info("Ir a la anterior P\u00e1gina de la b\u00fasqueda '" + searchID + "'");
                Search buscador = (Search)this.rpcContext.getSession(false).getAttribute(this.getSearchSessionVariableName(searchID));
                if (buscador != null) {
                    buscador.paginas.goToPrevPage();
                }
                buscador.doSearch(searchID);
            } else {
                R01FLog.to("r01f.rpcSearch").info("Se ha perdido la sesi\u00f3n, no se puede ir a la P\u00e1gina anterior de la b\u00fasqueda '" + searchID + "'");
            }
        }
        catch (SearchException srchEx) {
            throw new RPCException(this.rpcContext, srchEx.toString());
        }
        this.rpcContext.targetPage = this.getSearchResultsPresentationPage(searchID);
    }
}

