/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SearchParameter {
    public static final int OPERATOR_EQ = 0;
    public static final int OPERATOR_NEQ = 1;
    public static final int OPERATOR_GT = 2;
    public static final int OPERATOR_GTE = 3;
    public static final int OPERATOR_LT = 4;
    public static final int OPERATOR_LTE = 5;
    public static final int OPERATOR_LIKE = 6;
    public static final int OPERATOR_BETWEEN = 7;
    public static final int OPERATOR_ANY = 8;
    public static final int OPERATOR_ALL = 9;
    private static final String[] _operatorDefs = new String[]{"=", "<>", ">", ">=", "<", "<=", "LIKE", "BETWEEN", "ANY", "ALL"};
    private String _name;
    private String _description;
    private int _operator = 0;
    private List _value;

    public SearchParameter() {
    }

    public SearchParameter(String newParameterName, String newParameterDescription) {
        this();
        if (newParameterName != null && newParameterName.length() > 0) {
            this._name = newParameterName;
            this._description = newParameterDescription;
            if (this._description == null) {
                this._description = newParameterName;
            }
        } else {
            throw new IllegalArgumentException("Error en el constructor del objeto SearchParameter: Uno de los parametros de entrada no es valido");
        }
    }

    public SearchParameter(String newParameterName, String newParameterDescription, int newOperator) {
        this(newParameterName, newParameterDescription);
        this._operator = newOperator;
    }

    public SearchParameter(String newParameterName, String newParameterDescription, int newOperator, String newValue) {
        this(newParameterName, newParameterDescription, newOperator);
        if (newValue == null) {
            return;
        }
        if (this._value == null) {
            this._value = new ArrayList();
        }
        this._value.add(new SearchParameterValue(newValue));
    }

    public SearchParameter(String newParameterName, String newParameterDescription, int newOperator, String newValue, String newValueDescription) {
        this(newParameterName, newParameterDescription, newOperator);
        if (newValue == null) {
            return;
        }
        if (this._value == null) {
            this._value = new ArrayList();
        }
        this._value.add(new SearchParameterValue(newValue, newValueDescription));
    }

    public SearchParameter(String newParameterName, String newParameterDescription, int newOperator, String[] newValues) {
        this(newParameterName, newParameterDescription, newOperator);
        if (newValues == null || newValues.length == 0) {
            return;
        }
        if (this._value == null) {
            this._value = new ArrayList();
        }
        for (int i = 0; i < newValues.length; ++i) {
            this._value.add(new SearchParameterValue(newValues[i]));
        }
    }

    public SearchParameter(String newParameterName, String newParameterDescription, int newOperator, String[] newValues, String[] newValuesDescriptions) {
        this(newParameterName, newParameterDescription, newOperator);
        if (newValues == null || newValues.length == 0) {
            return;
        }
        if (newValuesDescriptions != null && newValues.length == newValuesDescriptions.length) {
            if (this._value == null) {
                this._value = new ArrayList();
            }
            for (int i = 0; i < newValues.length; ++i) {
                this._value.add(new SearchParameterValue(newValues[i], newValuesDescriptions[i]));
            }
        } else {
            throw new IllegalArgumentException("Error al establecer el parametro de busqueda: Se intenta crear un parametro de busqueda multiple complejo (valor:descripcion) pero la lista de valoresv no tiene el mismo tama\u00f1o que la lista de descripciones del valor");
        }
    }

    public String getValue() {
        StringBuffer sb = new StringBuffer("");
        if (this._description != null) {
            sb.append(this._description);
        }
        sb.append(" " + _operatorDefs[this._operator] + " ");
        if (this._value != null) {
            SearchParameterValue currValue = null;
            Iterator it = this._value.iterator();
            while (it.hasNext()) {
                currValue = (SearchParameterValue)it.next();
                sb.append("'" + currValue.getValue() + "'");
                if (!it.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public String getDescription() {
        return this._composeDescription(false);
    }

    public String toString() {
        return this._composeDescription(true);
    }

    private String _composeDescription(boolean showParamDescription) {
        StringBuffer sb = new StringBuffer("");
        if (this._name != null) {
            sb.append(this._name);
        }
        if (showParamDescription && this._description != null) {
            sb.append(" [" + this._description + "]");
        }
        sb.append(" " + _operatorDefs[this._operator] + " ");
        if (this._value != null) {
            SearchParameterValue currValue = null;
            Iterator it = this._value.iterator();
            while (it.hasNext()) {
                currValue = (SearchParameterValue)it.next();
                if (showParamDescription) {
                    sb.append(currValue.toString());
                } else {
                    sb.append(currValue.getDescription());
                }
                if (!it.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    private class SearchParameterValue {
        private String _code;
        private String _value;

        public SearchParameterValue() {
        }

        public SearchParameterValue(String newValue) {
            this();
            this._value = newValue;
        }

        public SearchParameterValue(String newCod, String newValue) {
            this();
            this._code = newCod;
            this._value = newValue;
        }

        public String getValue() {
            if (this._code != null && this._code.length() > 0) {
                return this._code;
            }
            if (this._value != null && this._value.length() > 0) {
                return this._value;
            }
            return null;
        }

        public String getDescription() {
            if (this._value != null) {
                return this._value;
            }
            if (this._code != null) {
                return this._code;
            }
            return "";
        }

        public String toString() {
            return (this._code == null ? "" : this._code) + ":" + (this._value == null ? "" : this._value);
        }
    }
}

