/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher.search;

import com.ejie.r01f.rpcdispatcher.search.AbstractSearchPersist;
import com.ejie.r01f.rpcdispatcher.search.SearchException;
import com.ejie.r01f.rpcdispatcher.search.SearchParameters;
import com.ejie.r01f.util.Pager;
import java.util.List;
import java.util.Map;

public class Search {
    private AbstractSearchPersist busquedaPersist = null;
    public Map paramsBusqueda = null;
    public Pager paginas;
    public List resultados;
    private int pageSize = 10;

    public Search(int inPageSize, AbstractSearchPersist inBuscadorPersist) {
        if (inPageSize <= 0) {
            throw new IllegalArgumentException("Tama\u00f1o de pagina no permitido");
        }
        this.pageSize = inPageSize;
        this.busquedaPersist = inBuscadorPersist;
    }

    public void setParams(SearchParameters inParamsBusqueda) {
        this.paramsBusqueda = inParamsBusqueda;
    }

    public void initSearch(String inSearchID) throws SearchException {
        if (this.paramsBusqueda == null) {
            throw new SearchException("No se han establecido los parametros de busqueda");
        }
        if (this.busquedaPersist == null) {
            throw new SearchException("No se ha inicializado la capa de persistencia de la b\u00fasqueda!!");
        }
        this.resultados = null;
        long totalElements = this.busquedaPersist.getTotalResultElementsCount(inSearchID, this.paramsBusqueda, this.pageSize);
        this.paginas = new Pager(this.pageSize);
        for (long i = 0L; i <= totalElements; ++i) {
            this.paginas.addPageElement(Long.toString(i));
        }
    }

    public void initSearch(String inSearchID, SearchParameters inParams) throws SearchException {
        this.setParams(inParams);
        this.initSearch(inSearchID);
    }

    public List doSearch(String inSearchID) throws SearchException {
        if (this.busquedaPersist == null) {
            throw new SearchException("No se ha inicializado la capa de persistencia de la b\u00fasqueda, aunque ya se ha llamado a initSearch() y no ha fallado... en algun momento se hace null la capa de b\u00fasqueda!!!");
        }
        if (this.paginas == null) {
            return null;
        }
        this.resultados = this.busquedaPersist.getSearchResults(inSearchID, this.paramsBusqueda, (String)this.paginas.getCurrentPageFirstElement(), (String)this.paginas.getNextPageFirstElement());
        return this.resultados;
    }
}

