/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.rpcdispatcher.RPCConstants;
import com.ejie.r01f.rpcdispatcher.RPCContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RPCTokenManager {
    public static String generateToken(HttpServletRequest request) {
        String newToken = RPCTokenManager._composeToken();
        if (newToken == null) {
            return null;
        }
        HttpSession session = request.getSession(true);
        if (session != null) {
            session.setAttribute("com.ejie.r01f.rpcdispatcher.TOKEN", (Object)newToken);
        }
        return newToken;
    }

    public static String getToken(HttpServletRequest request) {
        RPCContext context = (RPCContext)request.getAttribute("com.ejie.r01f.rpcdispatcher.CONTEXT");
        if (context == null) {
            return RPCTokenManager.generateToken(request);
        }
        if (context.token == null) {
            return RPCTokenManager.generateToken(request);
        }
        return context.token;
    }

    public static boolean isTokenValid(HttpServletRequest request) {
        String savedToken = null;
        String receivedToken = null;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        savedToken = (String)session.getAttribute("com.ejie.r01f.rpcdispatcher.TOKEN");
        receivedToken = request.getParameter("RPCToken");
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("\r\nToken almacenado en la sesion: " + savedToken);
        }
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("Token recibido del cliente:     " + receivedToken + "\r\n");
        }
        if (savedToken == null || receivedToken == null) {
            return false;
        }
        return savedToken.equals(receivedToken);
    }

    private static String _composeToken() {
        return "token" + Double.toString(Math.random());
    }
}

