/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlbuilder.XMLNode;
import java.util.Date;

public class RPCParameter {
    private String name = null;
    private String dataType = null;
    private int dataTypeCode = -1;
    private Object value = null;

    public RPCParameter() {
    }

    public RPCParameter(String newName, String newDataType) {
        this.name = newName;
        this.dataType = newDataType;
        this.value = null;
    }

    public RPCParameter(String newName, String newDataType, String newValue) throws RPCException {
        this.name = newName;
        this.setDataType(newDataType);
        this.setValue(newValue);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setDataType(String newDataType) {
        this.dataType = newDataType;
        if (newDataType.equals("String")) {
            this.dataTypeCode = 3;
        } else if (newDataType.equals("Double")) {
            this.dataTypeCode = 8;
        } else if (newDataType.equals("double")) {
            this.dataTypeCode = 9;
        } else if (newDataType.equals("Integer")) {
            this.dataTypeCode = 4;
        } else if (newDataType.equals("int")) {
            this.dataTypeCode = 5;
        } else if (newDataType.equals("Float")) {
            this.dataTypeCode = 10;
        } else if (newDataType.equals("float")) {
            this.dataTypeCode = 11;
        } else if (newDataType.equals("Long")) {
            this.dataTypeCode = 6;
        } else if (newDataType.equals("long")) {
            this.dataTypeCode = 7;
        } else if (newDataType.equals("Boolean")) {
            this.dataTypeCode = 12;
        } else if (newDataType.equals("boolean")) {
            this.dataTypeCode = 13;
        } else if (newDataType.equals("Date")) {
            this.dataTypeCode = 14;
        } else if (newDataType.equals("XML")) {
            this.dataTypeCode = 15;
        }
    }

    public String getDataType() {
        return this.dataType == null ? "" : this.dataType;
    }

    public int getDataTypeCode() {
        return this.dataTypeCode;
    }

    public void setValue(String newValue) throws RPCException {
        try {
            if (this.dataTypeCode == 3) {
                this.value = newValue.equals("null") ? null : newValue;
            } else if (this.dataTypeCode == 8) {
                this.value = newValue.equals("null") ? null : new Double(newValue);
            } else if (this.dataTypeCode == 9) {
                this.value = newValue.equals("null") ? new Double(0.0) : new Double(newValue);
            } else if (this.dataTypeCode == 4) {
                this.value = newValue.equals("null") ? null : new Integer(newValue);
            } else if (this.dataTypeCode == 5) {
                this.value = newValue.equals("null") ? new Integer(0) : new Integer(newValue);
            } else if (this.dataTypeCode == 10) {
                this.value = newValue.equals("null") ? null : new Float(newValue);
            } else if (this.dataTypeCode == 11) {
                this.value = newValue.equals("null") ? new Float(0.0f) : new Float(newValue);
            } else if (this.dataTypeCode == 6) {
                this.value = newValue.equals("null") ? null : new Long(newValue);
            } else if (this.dataTypeCode == 7) {
                this.value = newValue.equals("null") ? new Long(0L) : new Long(newValue);
            } else if (this.dataTypeCode == 12 || this.dataTypeCode == 13) {
                this.value = newValue.equals("true") ? new Boolean(true) : new Boolean(false);
            } else if (this.dataTypeCode == 14) {
                this.value = newValue.equals("null") ? new Date() : DateUtils.getDateFromFormatedString(newValue, "dd/MM/yyyy-hh:mm:ss:SSS");
            } else if (this.dataTypeCode == 15) {
                this.value = newValue.equals("null") ? null : newValue;
            }
        }
        catch (NumberFormatException nfEx) {
            throw new RPCException("La cadena suministrada como valor del parametro (" + newValue + ") no puede convertirse al tipo de datos del parametro (" + this.dataType + "): " + nfEx.toString());
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getJavaScript() {
        StringBuffer sb = new StringBuffer();
        sb.append("var p");
        sb.append(StringUtils.capitalizeFirstLetter(this.name));
        sb.append(" = new Parameter('");
        sb.append(this.name);
        sb.append("','");
        sb.append(this.dataType);
        sb.append("','");
        sb.append(this.value.toString());
        sb.append("');\r\n");
        return sb.toString();
    }

    XMLNode getXMLNode() {
        XMLNode paramNode = new XMLNode("param");
        paramNode.addAttribute("name", this.name);
        paramNode.addAttribute("type", this.dataType);
        String paramValue = null;
        paramValue = this.value == null ? "null" : (this.dataTypeCode == 14 ? DateUtils.getDateFormated((Date)this.value, "dd/MM/yyyy-hh:mm:ss:SSS") : this.value.toString());
        paramNode.setNodeValue(paramValue);
        return paramNode;
    }

    public String toXML() {
        return this.getXMLNode().toString();
    }

    public String toString() {
        StringBuffer strOut = new StringBuffer();
        if (this.dataType != null) {
            strOut.append(" ");
            strOut.append(this.dataType);
        }
        if (this.name != null) {
            strOut.append(" ");
            strOut.append(this.name);
        }
        strOut.append('=');
        if (this.value != null) {
            strOut.append(this.value);
        } else {
            strOut.append("null");
        }
        return strOut.toString();
    }
}

