/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.util.FifoMap;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlbuilder.XMLNode;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class RPCFunction {
    private String name = null;
    private Map params = null;

    public RPCFunction() {
    }

    public RPCFunction(String newName) {
        this.name = newName;
    }

    public RPCFunction(String newName, Map newParams) {
        this.name = newName;
        this.params = newParams;
    }

    public RPCParameter putParameter(RPCParameter theParam) {
        if (this.params == null) {
            this.params = new FifoMap();
        }
        return this.params.put(theParam.getName(), theParam);
    }

    public RPCParameter getParameter(String theParamName) {
        if (this.params == null) {
            return null;
        }
        return (RPCParameter)this.params.get(theParamName);
    }

    public Object getParameterValue(String theParamName) {
        if (this.params == null) {
            return null;
        }
        RPCParameter param = (RPCParameter)this.params.get(theParamName);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public Map getParameters() {
        if (this.params == null) {
            return null;
        }
        return this.params;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public Class[] getParameterTypesArray() {
        if (this.params != null) {
            Class[] arrParams = new Class[this.params.size()];
            int i = 0;
            for (RPCParameter currParam : this.params.values()) {
                if (currParam.getDataTypeCode() == 3) {
                    arrParams[i] = String.class;
                } else if (currParam.getDataTypeCode() == 4) {
                    arrParams[i] = Integer.class;
                } else if (currParam.getDataTypeCode() == 5) {
                    arrParams[i] = Integer.TYPE;
                } else if (currParam.getDataTypeCode() == 8) {
                    arrParams[i] = Double.class;
                } else if (currParam.getDataTypeCode() == 9) {
                    arrParams[i] = Double.TYPE;
                } else if (currParam.getDataTypeCode() == 6) {
                    arrParams[i] = Long.class;
                } else if (currParam.getDataTypeCode() == 7) {
                    arrParams[i] = Long.TYPE;
                } else if (currParam.getDataTypeCode() == 10) {
                    arrParams[i] = Float.class;
                } else if (currParam.getDataTypeCode() == 11) {
                    arrParams[i] = Float.TYPE;
                } else if (currParam.getDataTypeCode() == 12) {
                    arrParams[i] = Boolean.TYPE;
                } else if (currParam.getDataTypeCode() == 13) {
                    arrParams[i] = Boolean.TYPE;
                } else if (currParam.getDataTypeCode() == 14) {
                    arrParams[i] = Date.class;
                } else if (currParam.getDataTypeCode() == 15) {
                    arrParams[i] = String.class;
                } else if (currParam.getDataTypeCode() == -1) {
                    arrParams[i] = Object.class;
                }
                ++i;
            }
            return arrParams;
        }
        return null;
    }

    public Object[] getParameterValuesArray() {
        if (this.params != null) {
            Object[] paramValuesArr = new Object[this.params.size()];
            int i = 0;
            for (RPCParameter currParam : this.params.values()) {
                paramValuesArr[i] = currParam.getValue();
                ++i;
            }
            return paramValuesArr;
        }
        return null;
    }

    public String getJavaScript() {
        StringBuffer sb = new StringBuffer();
        String funcVar = "f" + StringUtils.capitalizeFirstLetter(this.name);
        sb.append("var " + funcVar + " = new FunctionElement('" + this.name + "');\r\n");
        if (this.params != null) {
            for (RPCParameter currParam : this.params.values()) {
                sb.append(currParam.getJavaScript());
            }
            Iterator<Object> it = this.params.keySet().iterator();
            while (it.hasNext()) {
                String paramVar = "p" + StringUtils.capitalizeFirstLetter((String)it.next());
                sb.append(funcVar + ".addParam(" + paramVar + ");\r\n;");
            }
        }
        return sb.toString();
    }

    XMLNode getXMLNode() {
        XMLNode functionNode = new XMLNode("function");
        functionNode.addAttribute("name", this.name);
        if (this.params != null) {
            Iterator it = this.params.values().iterator();
            while (it.hasNext()) {
                functionNode.addSubNode(((RPCParameter)it.next()).getXMLNode());
            }
        }
        return functionNode;
    }

    public String toXML() {
        return this.getXMLNode().toString();
    }

    public String getSignature() {
        String strOut = "";
        if (this.name != null) {
            strOut = strOut + this.name + "( ";
        }
        if (this.params != null) {
            RPCParameter currParam2 = null;
            int i = 0;
            for (RPCParameter currParam2 : this.params.values()) {
                if (i++ != 0) {
                    strOut = strOut + ",";
                }
                if (currParam2.getDataTypeCode() == 15) {
                    strOut = strOut + "String-XML " + currParam2.getName();
                    continue;
                }
                strOut = strOut + currParam2.getDataType() + " " + currParam2.getName();
            }
        }
        strOut = strOut + " )";
        return strOut;
    }

    public String toString() {
        String strOut = "";
        if (this.name != null) {
            strOut = strOut + this.name + "( ";
        }
        if (this.params != null) {
            RPCParameter currParam2 = null;
            int i = 0;
            for (RPCParameter currParam2 : this.params.values()) {
                if (i++ != 0) {
                    strOut = strOut + ",";
                }
                strOut = strOut + currParam2.toString();
            }
        }
        strOut = strOut + " )";
        return strOut;
    }
}

