/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.rpcdispatcher.RPCCall;
import com.ejie.r01f.rpcdispatcher.RPCCallResultNull;
import com.ejie.r01f.rpcdispatcher.RPCConstants;
import com.ejie.r01f.rpcdispatcher.RPCContext;
import com.ejie.r01f.rpcdispatcher.RPCDispatcherConfig;
import com.ejie.r01f.rpcdispatcher.RPCDispatcherConfigLoader;
import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.rpcdispatcher.RPCExec;
import com.ejie.r01f.rpcdispatcher.RPCFunction;
import com.ejie.r01f.rpcdispatcher.RPCModule;
import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.rpcdispatcher.RPCTokenManager;
import com.ejie.r01f.servlet.RequestParamParser;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.XMap;
import com.ejie.r01f.util.XSSSCanner;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xml.utils.XMLSerializerHelper;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RPCDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = -285638033625834553L;
    RPCDispatcherConfig rpcDispatcherConfig = null;
    XSSSCanner _xssScanner = new XSSSCanner();

    public void init(ServletConfig config) throws ServletException {
        block23: {
            super.init(config);
            try {
                Node rpcConfigNode;
                String regFilePath = config.getInitParameter("configFilePath");
                String appCode = config.getInitParameter("appCode");
                if (regFilePath == null && appCode == null) {
                    throw new ServletException("En el fichero web.xml AL MENOS hay que definir uno de los dos siguientes parametros de inicio: 'appCode' que indica el codigo de aplicaci\u00f3n o 'configFilePath'. Estos parametros sirven para obtener la configuraci\u00f3n del servlet rpc");
                }
                if (regFilePath != null && appCode != null && RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").warning("En el fichero web.xml se han definido los dos parametros 'appCode' y 'configFilePath' que sirven para localizar la configuracion del rpcServlet. Se utiliza el parametro 'configFilePath' ya que tiene prioridad!!!");
                }
                if (regFilePath == null && appCode != null) {
                    regFilePath = XMLProperties.getProperty(appCode, "rpcDispatcherConfig/configFilePath");
                }
                RPCDispatcherConfigLoader loader = new RPCDispatcherConfigLoader();
                if (regFilePath != null) {
                    try {
                        this.rpcDispatcherConfig = loader.load(new FileInputStream(regFilePath));
                        break block23;
                    }
                    catch (FileNotFoundException fnfe) {
                        try {
                            this.rpcDispatcherConfig = loader.load(((Object)((Object)this)).getClass().getResourceAsStream(regFilePath));
                            break block23;
                        }
                        catch (Exception e) {
                            throw fnfe;
                        }
                    }
                }
                if (appCode != null && (rpcConfigNode = XMLProperties.getPropertyNode(appCode, "rpcDispatcherConfig")) != null) {
                    String rpcConfig = XMLSerializerHelper.getOuterXML(rpcConfigNode, null);
                    this.rpcDispatcherConfig = loader.load(new ByteArrayInputStream(rpcConfig.getBytes()));
                }
            }
            catch (IOException ioEx) {
                throw new ServletException("No se encuentra el fichero de propiedades o el fichero de configuracion de modulos:\r\n" + ioEx.toString(), (Throwable)ioEx);
            }
            catch (SAXException saxEx) {
                throw new ServletException("Error al parsear el fichero de configuraci\u00f3n de modulos:\r\n" + saxEx.toString(), (Throwable)saxEx);
            }
            catch (TransformerException trEx) {
                throw new ServletException("Error al parsear la configuracion desde el fichero de propiedades:\r\n" + trEx.toString(), (Throwable)trEx);
            }
        }
        try {
            ClassLoader cl;
            Class<?> defaultExecutor;
            RPCExec init;
            RPCContext context = new RPCContext();
            context.rpcCall = null;
            context.application = config.getServletContext();
            context.request = null;
            context.response = null;
            String defaultExecutorClassName = this.rpcDispatcherConfig.getDefaultExecutorClassName();
            if (defaultExecutorClassName != null && (init = (RPCExec)(defaultExecutor = (cl = Thread.currentThread().getContextClassLoader()).loadClass(defaultExecutorClassName)).newInstance()) != null) {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("Inicializando rpc globalmente " + defaultExecutorClassName);
                }
                init.setRPCContext(context);
                init.initialize(context);
            }
            RPCExec exec = null;
            for (RPCModule mod : this.rpcDispatcherConfig.modules.values()) {
                ClassLoader cl2;
                Class<?> executorClass;
                String executorClassName;
                if (mod.name.equalsIgnoreCase(this.rpcDispatcherConfig.getDefaultExecutorModuleName()) || (executorClassName = this.rpcDispatcherConfig.getModuleExecutor(mod.name)) == null || (exec = (RPCExec)(executorClass = (cl2 = Thread.currentThread().getContextClassLoader()).loadClass(executorClassName)).newInstance()) == null) continue;
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("Inicializando modulo " + mod.name);
                }
                exec.setRPCContext(context);
                exec.initialize(context);
            }
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServletException("No se encuentra la clase:\r\n " + cnfEx.getMessage(), (Throwable)cnfEx);
        }
        catch (InstantiationException insEx) {
            throw new ServletException("No se ha podido instanciar la clase:\r\n" + insEx.getMessage(), (Throwable)insEx);
        }
        catch (RPCException xmlRPCEx) {
            R01FLog.to("r01f.rpcDispatcher").severe(xmlRPCEx.getDetailedMessage());
            throw new ServletException("Error RPC:\r\n" + xmlRPCEx.getMessage(), (Throwable)xmlRPCEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new ServletException("Acceso ilegal al metodo initialize:\r\n" + illAccEx.getMessage(), (Throwable)illAccEx);
        }
        catch (Exception ex) {
            throw new ServletException("Error desconocido en la inicializacion:\r\n" + ex.getMessage(), (Throwable)ex);
        }
        this.getServletContext().setAttribute("RPCDispatcherInitialized", (Object)"true");
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("\r\n\r\n\r\n\r\n\r\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("> LLAMADA RPC (GET) DESDE: " + request.getRemoteHost() + "(" + request.getRemoteAddr() + ")");
        }
        try {
            this._xssScanner.scanRequest(request, response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.processRequest(request, response);
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("< FIN LLAMADA RPC (GET)");
        }
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\r\n\r\n\r\n\r\n\r\n");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            this._xssScanner.scanRequest(request, response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("\r\n\r\n\r\n\r\n\r\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("> LLAMADA RPC (POST) DESDE: " + request.getRemoteHost() + "(" + request.getRemoteAddr() + ")");
        }
        this.processRequest(request, response);
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("< FIN LLAMADA RPC (POST)");
        }
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\r\n\r\n\r\n\r\n\r\n");
        }
    }

    public String getServletInfo() {
        return "(c) EJIE 2002 - Servlet RPCDispatcher by Alex Lara";
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Object lastCallResult;
        String reload = request.getParameter("reload");
        if (reload != null && reload.equalsIgnoreCase("true")) {
            String password = request.getParameter("password");
            if (password == null) {
                throw new ServletException("No se puede recargar el servlet RPC sin pasar el parametro password!!!");
            }
            if (this.rpcDispatcherConfig.reloadPassword == null) {
                throw new ServletException("No se ha especificado el parametro 'reloadPassword' en la configuracion del rpcServlet. No se realiza la recarga!!!");
            }
            if (!password.equals(this.rpcDispatcherConfig.reloadPassword)) {
                throw new ServletException("La password suministrada para realizar la recarga del servlet RPC NO es correcta!!!");
            }
            try {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("\r\n\r\n\r\n>>>>>>>>>>> Forzando inicializacion!!!!\r\n\r\n\r\n");
                }
                this.init(this.getServletConfig());
                response.setLocale(new Locale("ISO-8859-1"));
                response.setContentType("text/html;ISO-8859-1");
                response.setCharacterEncoding("ISO-8859-1");
                ServletOutputStream out = response.getOutputStream();
                out.println("<html><body><h1 style='text-align:center'>Servlet RPC Recargado</h1></body></html>");
                out.flush();
                out.close();
                return;
            }
            catch (ServletException servEx) {
                throw new ServletException("Error al forzar la inicializaci\u00f3n del RPCDispatcher:\r\n" + servEx.getMessage());
            }
            catch (IOException ioEx) {
                throw new ServletException("Error al escribir la salida del RPCDispatcher:\r\n" + ioEx.toString());
            }
        }
        if (this.rpcDispatcherConfig.checkSession && request.getSession(false) == null) {
            try {
                RPCContext outContext = new RPCContext();
                outContext.targetPage = this.rpcDispatcherConfig.noSessionPage;
                if (outContext.targetPage == null) {
                    if (RPCConstants.DEBUG) {
                        R01FLog.to("r01f.rpcDispatcher").info("\r\n\r\nLa session de usuario ha caducado. No se ha especificado p\u00e1gina de redireccion cuando caduca la session en el parametro noSessionPage de la configuracion del RPCServlet\r\n\r\n");
                    }
                    ServletOutputStream out = response.getOutputStream();
                    out.print("<html><body><h1 style='text-align:center'>Su sesi\u00f3n de usuario ha caducado...</h1></body></html>");
                } else {
                    if (RPCConstants.DEBUG) {
                        R01FLog.to("r01f.rpcDispatcher").info("\r\n\r\nLa session de usuario ha caducado. Redirigiendo a la p\u00e1gina '" + outContext.targetPage + "'\r\n\r\n");
                    }
                    this._redirectToPage(request, response, outContext);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        boolean tokenValid = true;
        if (this.rpcDispatcherConfig.usesToken) {
            tokenValid = RPCTokenManager.isTokenValid(request);
        }
        if (tokenValid) {
            if (RPCConstants.DEBUG) {
                R01FLog.to("r01f.rpcDispatcher").info("El token de la llamada RPC es valido.");
            }
        } else if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("El token de la llamada RPC NO es valido!!!\r\nSe ha intentado ejecutar de nuevo la llamada sin que se haya terminado de ejecutar la anterior (resubmit del formulario)");
        }
        if (!tokenValid) {
            return;
        }
        RPCContext context = new RPCContext();
        context.application = this.getServletContext();
        context.request = request;
        context.requestParamParser = new RequestParamParser((ServletRequest)request);
        context.response = response;
        context.threadName = request.getParameter("thread");
        try {
            RPCCallWrapper rpcWrap = this._extractRPCCall(request);
            if (rpcWrap == null || rpcWrap.rpcCall.getModule() == null) {
                throw new RPCException("La llamada RPC NO es valida o no se ha definido el modulo!!");
            }
            context.rpcCall = rpcWrap.rpcCall;
            context.protocolData = this._getProtocolData(request, rpcWrap.rpcCallMethod);
            if (context.protocolData == null) {
                context.protocolData = new XMap();
            }
            if (RPCConstants.DEBUG) {
                R01FLog.to("r01f.rpcDispatcher").info(context.printDebugInfo());
            }
            this._execRPCCall(context);
            if (this.rpcDispatcherConfig.usesToken) {
                context.token = RPCTokenManager.generateToken(request);
            }
        }
        catch (RPCException rpcEx) {
            context.previousCallsResults.push(rpcEx);
        }
        if (!context.previousCallsResults.isEmpty() && ((lastCallResult = context.previousCallsResults.peek()) instanceof Throwable || lastCallResult instanceof Exception) && context.rpcCall != null && context.rpcCall.getModule() != null && this.rpcDispatcherConfig.modules.get(context.rpcCall.getModule()) != null) {
            RPCModule module = (RPCModule)this.rpcDispatcherConfig.modules.get(context.rpcCall.getModule());
            if (module.errorPage != null) {
                request.setAttribute("com.ejie.r01f.rpcdispatcher.EXCEPTION", lastCallResult);
                context.targetPage = module.errorPage + "?" + request.getQueryString();
            } else if (RPCConstants.DEBUG) {
                R01FLog.to("r01f.rpcDispatcher").info("Ha ocurrido un error al invocar al RPCDispacherServlet:" + lastCallResult);
            }
        }
        if (context.targetPage != null) {
            request.setAttribute("com.ejie.r01f.rpcdispatcher.CONTEXT", (Object)context);
            this._redirectToPage(request, response, context);
        } else {
            this._returnCallResult(response, context);
        }
    }

    private void _execRPCCall(RPCContext context) throws RPCException {
        RPCExec exec = null;
        String executorClassName = this.rpcDispatcherConfig.getModuleExecutor(context.rpcCall.getModule());
        if (executorClassName != null) {
            try {
                exec = (RPCExec)ReflectionUtils.getObjectInstance(executorClassName);
                if (exec == null) {
                    throw new RPCException("No se ha podido instanciar el ejecutor '" + executorClassName + "' del modulo '" + context.rpcCall.getModule() + "'");
                }
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info(ReflectionUtils.composeClassMethodsSignatures(exec.getClass()));
                }
                exec.setRPCContext(context);
            }
            catch (ReflectionException refEx) {
                RPCException ex = new RPCException("Error al procesar la llamada RPC: Error al instanciar la clase ejecutora del modulo '" + context.rpcCall.getModule() + "': " + refEx.getMessage(), (Exception)refEx);
                context.previousCallsResults.push(ex);
                return;
            }
        } else {
            RPCException ex = new RPCException("El modulo '" + context.rpcCall.getModule() + "' no esta bien definido, falta la clase ejecutora. Revisa el fichero XML de configuracion");
            context.previousCallsResults.push(ex);
            return;
        }
        String currFunctionSignature = null;
        try {
            Collection functionsToCall = context.rpcCall.getFunctions();
            if (functionsToCall != null) {
                for (RPCFunction function : functionsToCall) {
                    Object result;
                    if (function.getName() == null) {
                        throw new RPCException("El nombre del metodo a invocar en el modulo " + context.rpcCall.getModule() + " es nulo");
                    }
                    currFunctionSignature = ReflectionUtils.composeMethodSignature(exec.getClass().getName(), function.getName(), function.getParameterTypesArray());
                    if (RPCConstants.DEBUG) {
                        R01FLog.to("r01f.rpcDispatcher").info("Ejecutando metodo: " + currFunctionSignature);
                    }
                    if ((result = ReflectionUtils.invokeMethod(exec, function.getName(), function.getParameterTypesArray(), function.getParameterValuesArray())) != null) {
                        context.previousCallsResults.push(result);
                        continue;
                    }
                    context.previousCallsResults.push(new RPCCallResultNull());
                }
            } else {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("Llamando a metodo service del modulo: " + context.rpcCall.getModule());
                }
                currFunctionSignature = "service()";
                String result = exec.service();
                context.previousCallsResults.push(result);
            }
        }
        catch (Throwable th) {
            context.previousCallsResults.push(th);
        }
    }

    private void _redirectToPage(HttpServletRequest request, HttpServletResponse response, RPCContext context) throws ServletException {
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("\r\n\r\nRedirecting... " + context.targetPage + "\r\n\r\n");
        }
        try {
            if (context.targetPage.startsWith("http://") || context.targetPage.startsWith("https://") || context.absoluteRedirect) {
                response.sendRedirect(context.targetPage);
            } else if (context.targetPage.startsWith("/") && context.targetPage.indexOf(47, 1) > 1) {
                String newContextName = context.targetPage.substring(1, context.targetPage.indexOf("/", 1));
                String newTargetPage = context.targetPage.substring(context.targetPage.indexOf("/", 1) + 1);
                ServletContext newContext = this.getServletContext().getContext(newContextName);
                RequestDispatcher rd = newContext.getRequestDispatcher(newTargetPage);
                if (rd == null) {
                    throw new ServletException("Error al obtener un request dispatcher al contexto " + newContextName);
                }
                rd.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                RequestDispatcher rd = request.getRequestDispatcher(context.targetPage);
                if (rd == null) {
                    throw new ServletException("Error al obtener un request dispatcher al contexto actual");
                }
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (IOException ioEx) {
            throw new ServletException("Error al redirigir a la pagina '" + context.targetPage + "'", (Throwable)ioEx);
        }
        catch (IllegalStateException illStEx) {
            throw new ServletException("Error al redirigir a la pagina '" + context.targetPage + "'", (Throwable)illStEx);
        }
        catch (ServletException servEx) {
            throw new ServletException("Error al redirigir a la pagina '" + context.targetPage + "'", (Throwable)servEx);
        }
        catch (Exception ex) {
            throw new ServletException("Error al redirigir a la pagina '" + context.targetPage + "'", (Throwable)ex);
        }
    }

    private void _returnCallResult(HttpServletResponse response, RPCContext context) throws ServletException {
        try {
            StringBuffer sb = new StringBuffer(512);
            if (!sb.toString().startsWith("<?xml")) {
                sb.append("<?xml version='1.0' encoding='ISO-8859-1'?>");
            }
            RPCCallResultNull lastCallResult = context.previousCallsResults.isEmpty() ? new RPCCallResultNull() : context.previousCallsResults.peek();
            int lastCallResultType = this._obtainMethodCallResultType(lastCallResult);
            String resultStr = this._composeMethodCallResultAsString(lastCallResult, lastCallResultType, context.resultObectsToXMLMapFile);
            if (context.includeRPCCallResultWrapperHeader) {
                sb.append("<rpcCallResult><dataType code='");
                sb.append(lastCallResultType);
                sb.append("'>");
                sb.append(lastCallResult == null ? "null" : lastCallResult.getClass().getName());
                sb.append("</dataType><returnValue>");
                sb.append(resultStr);
                sb.append("</returnValue></rpcCallResult>");
            } else {
                sb.append(resultStr);
            }
            if (RPCConstants.DEBUG) {
                R01FLog.to("r01f.rpcDispatcher").info("\r\n\r\n>>>Respuesta devuelta:\r\n\t" + sb.toString());
            }
            response.setContentType("text/xml;ISO-8859-1");
            response.setCharacterEncoding("ISO-8859-1");
            response.setLocale(new Locale("ISO-8859-1"));
            PrintWriter out = response.getWriter();
            out.println(sb.toString());
            out.flush();
            out.close();
        }
        catch (IOException ioEx) {
            throw new ServletException("Error al devolver el resultado de la llamada", (Throwable)ioEx);
        }
    }

    private String _composeMethodCallResultAsString(Object lastCallResult, int lastCallResultType, String resultObjectsToXMLMapFile) {
        if (lastCallResult == null) {
            return "";
        }
        StringBuffer sb = null;
        if (lastCallResultType == 14) {
            sb = new StringBuffer(32);
            sb.append(DateUtils.getDateFormated((Date)lastCallResult, "dd/MM/yyyy-hh:mm:ss:SSS"));
        } else if (lastCallResultType == 2) {
            if (resultObjectsToXMLMapFile != null) {
                try {
                    String resultXML = XOManager.getXML(resultObjectsToXMLMapFile, lastCallResult);
                    sb = new StringBuffer(resultXML);
                }
                catch (XOMarshallerException xoEx) {
                    xoEx.printStackTrace(System.out);
                }
            } else {
                R01FLog.to("r01f.rpcDispatcher").warning("La llamada a funcion ha devuelto un objeto complejo, pero este no se puede devolver como xml ya que en el contexto no se ha pasado el fichero de mapeo. Establecer la propiedad resultObectsToXMLMapFile en el contexto");
            }
        } else {
            sb = new StringBuffer(lastCallResult.toString());
        }
        return sb != null ? sb.toString() : "";
    }

    private int _obtainMethodCallResultType(Object lastCallResult) {
        int lastCallResultType = -1;
        if (lastCallResult != null) {
            lastCallResultType = lastCallResult instanceof Exception || lastCallResult instanceof Throwable ? 16 : (lastCallResult instanceof Void ? 0 : (lastCallResult instanceof String ? 3 : (lastCallResult instanceof Integer ? 4 : (lastCallResult instanceof Long ? 6 : (lastCallResult instanceof Double ? 8 : (lastCallResult instanceof Float ? 10 : (lastCallResult instanceof Date ? 14 : (lastCallResult instanceof RPCCallResultNull ? 1 : (lastCallResult instanceof Boolean ? 12 : 2)))))))));
        }
        return lastCallResultType;
    }

    private RPCCallWrapper _extractRPCCall(HttpServletRequest request) throws RPCException {
        int callMethod;
        RPCCall rpcCall = null;
        String xmlRPC = request.getParameter("xmlRPC");
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info(">>>>>>>>>>>>>>>>>>> LLAMADA RPC CALL RECIBIDA: " + xmlRPC + "\n\n");
        }
        if (xmlRPC != null) {
            try {
                rpcCall = new RPCCall();
                rpcCall.loadFromXML(new ByteArrayInputStream(xmlRPC.getBytes()));
                callMethod = 1;
            }
            catch (SAXException saxEx) {
                throw new RPCException("Error al parsear la llamada RPC XML:\r\n " + saxEx.toString());
            }
        } else {
            String modName = request.getParameter("module");
            String functName = request.getParameter("function");
            if (modName != null && functName != null) {
                String currParamName;
                rpcCall = new RPCCall();
                rpcCall.setModule(modName);
                RPCFunction function = new RPCFunction();
                function.setName(functName);
                HashMap<String, String> parameters = new HashMap<String, String>();
                Enumeration en = request.getParameterNames();
                while (en.hasMoreElements()) {
                    currParamName = (String)en.nextElement();
                    if (currParamName.equalsIgnoreCase("module") || currParamName.equalsIgnoreCase("function") || currParamName.equalsIgnoreCase("RPCToken") || currParamName.equals("thread") || !currParamName.startsWith("param")) continue;
                    parameters.put(currParamName, request.getParameter(currParamName));
                }
                if (parameters.size() > 0) {
                    for (int i = 1; i <= parameters.size(); ++i) {
                        currParamName = "param" + i;
                        if (!parameters.keySet().contains(currParamName)) continue;
                        function.putParameter(new RPCParameter(currParamName, RPCConstants.DATATYPES[3], (String)parameters.get(currParamName)));
                    }
                }
                rpcCall.addFunction(function);
                callMethod = 2;
            } else if (modName != null) {
                rpcCall = new RPCCall();
                rpcCall.setModule(modName);
                callMethod = 3;
            } else {
                rpcCall = new RPCCall();
                rpcCall.setModule(this.rpcDispatcherConfig.getDefaultExecutorModuleName());
                callMethod = 4;
            }
        }
        return new RPCCallWrapper(callMethod, rpcCall);
    }

    private Map _getProtocolData(HttpServletRequest request, int invokeMethod) {
        HashMap<String, String> outMap = new HashMap<String, String>();
        if (request.getParameterNames() != null) {
            String currParamName = null;
            switch (invokeMethod) {
                case 1: {
                    Enumeration en = request.getParameterNames();
                    while (en.hasMoreElements()) {
                        currParamName = (String)en.nextElement();
                        if (currParamName.equals("xmlRPCProtocolData")) {
                            XMap data;
                            String protocolData = request.getParameter(currParamName);
                            if (protocolData == null || protocolData.length() <= 0 || (data = new XMap(request.getParameter(currParamName))) == null) continue;
                            outMap.putAll(data);
                            continue;
                        }
                        if (currParamName.equals("RPCToken") || currParamName.equals("xmlRPC") || currParamName.equals("thread")) continue;
                        outMap.put(currParamName, request.getParameter(currParamName));
                    }
                    break;
                }
                case 2: {
                    Enumeration en = request.getParameterNames();
                    while (en.hasMoreElements()) {
                        currParamName = (String)en.nextElement();
                        if (currParamName.equals("RPCToken") || currParamName.equals("thread") || currParamName.equals("module") || currParamName.equals("function") || currParamName.startsWith("param")) continue;
                        outMap.put(currParamName, request.getParameter(currParamName));
                    }
                    break;
                }
                case 3: {
                    Enumeration en = request.getParameterNames();
                    while (en.hasMoreElements()) {
                        currParamName = (String)en.nextElement();
                        if (currParamName.equals("RPCToken") || currParamName.equals("thread") || currParamName.equals("module")) continue;
                        outMap.put(currParamName, request.getParameter(currParamName));
                    }
                    break;
                }
                case 4: {
                    Enumeration en = request.getParameterNames();
                    while (en.hasMoreElements()) {
                        currParamName = (String)en.nextElement();
                        if (currParamName.equals("RPCToken") || currParamName.equals("thread")) continue;
                        outMap.put(currParamName, request.getParameter(currParamName));
                    }
                    break;
                }
            }
        }
        if (outMap.size() == 0) {
            return null;
        }
        return outMap;
    }

    private void _printRPCDebugInfoAsHtml(HttpServletResponse response, RPCCall currRPC) throws IOException {
        PrintWriter out = response.getWriter();
        response.setContentType("text/xml;ISO-8859-1");
        response.setCharacterEncoding("ISO-8859-1");
        if (currRPC == null) {
            out.println("<table border='1'>\r\n");
            out.println("\t<tr>\r\n");
            out.println("\t\t<td>Documento XML Nulo</td>\r\n");
            out.println("\t</tr>\r\n");
            out.println("</table>\r\n");
        } else {
            out.println("<table border='1'>\r\n");
            out.println("<tr>\r\n");
            out.println("\t<td colspan='2'>Datos de la llamada RPC</td>\r\n");
            out.println("</tr>\r\n");
            out.println("<tr>\r\n");
            out.println("\t<td>Modulo:</td><td>" + currRPC.getModule() + "</td>\r\n");
            out.println("</tr>\r\n");
            out.println("<tr>\r\n");
            out.println("\t<td colspan='2'>Funciones</td>\r\n");
            out.println("</tr>\r\n");
            if (currRPC.getFunctions() != null) {
                Iterator it = currRPC.getFunctions().iterator();
                while (it.hasNext()) {
                    out.println("<tr>\r\n");
                    out.println("\t<td colspan='2'>" + it.next() + "</td>\r\n");
                    out.println("</tr>\r\n");
                }
            }
            out.println("</table>\r\n");
        }
        out.println("<table border='1'>\r\n");
        out.println("<tr><td>XML de la llamada</td></tr>\r\n");
        out.println("<tr><td></td></tr>\r\n");
        out.println("</table>\r\n");
        out.close();
    }

    private class RPCCallWrapper {
        int rpcCallMethod;
        RPCCall rpcCall;

        RPCCallWrapper(int newCallMethod, RPCCall newRpcCall) {
            this.rpcCall = newRpcCall;
            this.rpcCallMethod = newCallMethod;
        }
    }
}

