/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.rpcdispatcher.RPCDispatcherConfig;
import com.ejie.r01f.rpcdispatcher.RPCModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RPCDispatcherConfigLoader
extends DefaultHandler {
    RPCDispatcherConfig config;
    private Stack tagStack = new Stack();
    private Stack modulesStack = new Stack();

    public RPCDispatcherConfig load(InputStream is) throws SAXException {
        this._loadFromXML(is);
        return this.config;
    }

    public RPCDispatcherConfig load(String inXMLStr) throws SAXException {
        this._loadFromXML(new ByteArrayInputStream(inXMLStr.getBytes()));
        return this.config;
    }

    private void _loadFromXML(InputStream is) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException("RPCDispatcherConfig:loadFromXML(): Error en la configuraci\u00f3n del parser: " + pcEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new SAXException("RPCDispatcherConfig:loadFromXML(): Error de IO " + ioEx.getMessage());
        }
    }

    @Override
    public void startDocument() {
        this.config = new RPCDispatcherConfig();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
        String eName = lName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.tagStack.push(eName);
        if (eName.equalsIgnoreCase("modules")) {
            this.config.modules = new HashMap();
            if (attrs != null && attrs.getValue("default") != null) {
                this.config.defaultExecutor = attrs.getValue("default");
            }
        } else if (eName.equalsIgnoreCase("module")) {
            RPCModule mod = new RPCModule();
            this.modulesStack.push(mod);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        String currentTag = (String)this.tagStack.peek();
        if (currentTag.equalsIgnoreCase("name")) {
            RPCModule currentRPCModule = (RPCModule)this.modulesStack.peek();
            currentRPCModule.name = currentRPCModule.name == null ? s : currentRPCModule.name + s;
        } else if (currentTag.equalsIgnoreCase("executor")) {
            RPCModule currentRPCModule = (RPCModule)this.modulesStack.peek();
            currentRPCModule.executor = currentRPCModule.executor == null ? s : currentRPCModule.executor + s;
        } else if (currentTag.equalsIgnoreCase("errorPage")) {
            RPCModule currentRPCModule = (RPCModule)this.modulesStack.peek();
            currentRPCModule.errorPage = currentRPCModule.errorPage == null ? s : currentRPCModule.errorPage + s;
        } else if (currentTag.equalsIgnoreCase("url")) {
            this.config.url = this.config.url == null ? s : this.config.url + s;
        } else if (currentTag.equalsIgnoreCase("usesToken")) {
            this.config.usesToken = s.equalsIgnoreCase("true");
        } else if (currentTag.equalsIgnoreCase("checkSession")) {
            this.config.checkSession = s.equalsIgnoreCase("true");
        } else if (currentTag.equalsIgnoreCase("noSessionPage")) {
            this.config.noSessionPage = this.config.noSessionPage == null ? s : this.config.noSessionPage + s;
        } else if (currentTag.equalsIgnoreCase("reloadPassword")) {
            this.config.reloadPassword = this.config.reloadPassword == null ? s : this.config.reloadPassword + s;
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.tagStack.pop();
        if (eName.equalsIgnoreCase("module")) {
            RPCModule mod = (RPCModule)this.modulesStack.pop();
            this.config.modules.put(mod.name, mod);
        }
    }
}

