/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.rpcdispatcher.RPCModule;
import com.ejie.r01f.xmlbuilder.XMLNode;
import java.io.Serializable;
import java.util.Map;

public class RPCDispatcherConfig
implements Serializable {
    private static final long serialVersionUID = -1930963119077276404L;
    public String url = null;
    public String defaultExecutor = null;
    public Map modules = null;
    public boolean usesToken = false;
    public String reloadPassword = null;
    public boolean checkSession = false;
    public String noSessionPage = null;

    public String getModuleExecutor(String theModuleName) {
        RPCModule mod;
        if (this.modules == null) {
            throw new IllegalStateException("No se han cargado datos de modulos");
        }
        if (theModuleName != null && theModuleName.length() > 0 && (mod = (RPCModule)this.modules.get(theModuleName)) != null) {
            return mod.executor;
        }
        return null;
    }

    public String getDefaultExecutorModuleName() {
        return this.defaultExecutor;
    }

    public String getDefaultExecutorClassName() {
        return this.getModuleExecutor(this.defaultExecutor);
    }

    public String toXML() {
        XMLNode regNode = new XMLNode("rpcDispatcherConfig");
        if (this.modules != null) {
            XMLNode modulesNode = new XMLNode("modules");
            modulesNode.addAttribute("default", this.defaultExecutor);
            for (RPCModule mod : this.modules.values()) {
                XMLNode modNode = new XMLNode("module");
                modNode.addSubNode(new XMLNode("name", mod.name));
                modNode.addSubNode(new XMLNode("executor", mod.executor));
                modNode.addSubNode(new XMLNode("executor", mod.errorPage));
                modulesNode.addSubNode(modNode);
            }
            regNode.addSubNode(modulesNode);
        }
        return regNode.toString();
    }
}

