/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.BaseNetRequest;
import com.ejie.r01f.net.HttpRequest;
import com.ejie.r01f.net.HttpsRequest;
import com.ejie.r01f.rpcdispatcher.RPCCall;
import com.ejie.r01f.rpcdispatcher.RPCConstants;
import com.ejie.r01f.rpcdispatcher.RPCFunction;
import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.util.XMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Map;

public class RPCClient {
    private static final int NETPROTOCOL_HTTP = 0;
    private static final int NETPROTOCOL_HTTPS = 1;
    private static final long DEFAULT_HTTPCONNECTION_TIMEOUT = 10000L;
    private XMap _rpcProtocolData = null;
    private int _netProtocol = 0;
    private String _targetURL;
    private boolean _proxyKeepConectionAlive = false;
    private String _proxyHost = null;
    private String _proxyPort = null;
    private String _usrProxy = null;
    private String _pwdProxy = null;
    private long clientTimeout = -1L;
    private boolean _forceBCProviders = false;

    public RPCClient(String inTargetURL) {
        this._targetURL = inTargetURL.trim();
        if (!this._targetURL.startsWith("http://") && !this._targetURL.startsWith("https://")) {
            this._targetURL = "http://" + this._targetURL;
        }
        if (this._targetURL.startsWith("http://")) {
            this._netProtocol = 0;
        } else if (this._targetURL.startsWith("https://")) {
            this._netProtocol = 1;
        }
    }

    public RPCClient(String inTargetURL, String proxyHost, String proxyPort) {
        this._targetURL = inTargetURL.trim();
        if (!this._targetURL.startsWith("http://") && !this._targetURL.startsWith("https://")) {
            this._targetURL = "http://" + this._targetURL;
        }
        if (this._targetURL.startsWith("http://")) {
            this._netProtocol = 0;
        } else if (this._targetURL.startsWith("https://")) {
            this._netProtocol = 1;
        }
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
    }

    public RPCClient(String inNetProtocol, String inTargetURL) throws MalformedURLException {
        if (inNetProtocol.equalsIgnoreCase("http")) {
            this._netProtocol = 0;
        } else if (inNetProtocol.equalsIgnoreCase("https")) {
            this._netProtocol = 1;
        } else {
            throw new MalformedURLException("Solo se permiten los protocolos 'http' o 'https'");
        }
        this._targetURL = inTargetURL.trim();
        if (!this._targetURL.startsWith("http://") && !this._targetURL.startsWith("https://")) {
            if (this._netProtocol == 0) {
                this._targetURL = "http://" + this._targetURL;
            } else if (this._netProtocol == 1) {
                this._targetURL = "https://" + this._targetURL;
            }
        }
        if (this._targetURL.startsWith("http://") && this._netProtocol == 1 || this._targetURL.startsWith("https://") && this._netProtocol == 0) {
            throw new MalformedURLException("El protocolo indicado en la llamada al constructro no coincide con el indicado en la url '" + this._targetURL + "'");
        }
    }

    public void setProtocolData(XMap newProtocolData) {
        if (this._rpcProtocolData == null) {
            this._rpcProtocolData = newProtocolData;
        } else {
            this._rpcProtocolData.putAll((Map)newProtocolData);
        }
    }

    public void putProtocolData(String newProtocolParam, String newProtocolParamValue) {
        if (this._rpcProtocolData == null) {
            this._rpcProtocolData = new XMap();
        }
        this._rpcProtocolData.put(newProtocolParam, newProtocolParamValue);
    }

    public void setTimeOut(long timeOut) {
        this.clientTimeout = timeOut;
    }

    public InputStream sendRPCCall(RPCCall rpcCall) throws IOException {
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("Llamada RPC Http: " + rpcCall.toXML());
        }
        return this._doRPCCall(rpcCall, 0);
    }

    public InputStream sendGetRPCCall(RPCCall rpcCall) throws IOException {
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("Llamada RPC Http via GET: " + rpcCall.toXML());
        }
        return this._doRPCCall(rpcCall, 0);
    }

    public InputStream sendPostRPCCall(RPCCall rpcCall) throws IOException {
        if (RPCConstants.DEBUG) {
            R01FLog.to("r01f.rpcDispatcher").info("Llamada RPC Http via POST: " + rpcCall.toXML());
        }
        return this._doRPCCall(rpcCall, 0);
    }

    public void setProxyAuthorization(String user, String password) {
        this._usrProxy = user;
        this._pwdProxy = password;
    }

    private InputStream _doRPCCall(RPCCall rpcCall, int sendMode) throws IOException {
        BaseNetRequest netRequest = null;
        if (this._netProtocol == 0) {
            if (this._proxyHost != null && this._proxyPort != null) {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("RPCClient: LlamadaRPC VIA PROXY(" + this._proxyHost + ":" + this._proxyPort + "):\r\n" + rpcCall.toXML());
                }
                netRequest = new HttpRequest(this._targetURL, this._proxyHost, this._proxyPort);
                if (this._proxyKeepConectionAlive) {
                    netRequest.keepProxyConnectionAlive(this._proxyKeepConectionAlive);
                }
            } else {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("RPCClient: LlamadaRPC :\r\n" + rpcCall.toXML());
                }
                netRequest = new HttpRequest(this._targetURL);
            }
        } else if (this._netProtocol == 1) {
            if (this._proxyHost != null && this._proxyPort != null) {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("RPCClient: LlamadaRPC VIA PROXY(" + this._proxyHost + ":" + this._proxyPort + "):\r\n" + rpcCall.toXML());
                }
                netRequest = this._forceBCProviders ? new HttpsRequest(this._targetURL, this._proxyHost, this._proxyPort, this._forceBCProviders) : new HttpsRequest(this._targetURL, this._proxyHost, this._proxyPort);
                if (this._proxyKeepConectionAlive) {
                    netRequest.keepProxyConnectionAlive(this._proxyKeepConectionAlive);
                }
            } else {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("RPCClient: LlamadaRPC :\r\n" + rpcCall.toXML());
                }
                netRequest = this._forceBCProviders ? new HttpsRequest(this._targetURL, this._forceBCProviders) : new HttpsRequest(this._targetURL);
            }
        }
        if (sendMode == 1) {
            if (rpcCall.getModule() != null) {
                netRequest.putParameter("module", URLEncoder.encode(rpcCall.getModule(), "UTF-8"));
            }
            if (rpcCall.getFunctions() != null && rpcCall.getFunctions().size() >= 1) {
                RPCFunction function = rpcCall.getFunction(0);
                netRequest.putParameter("function", URLEncoder.encode(function.getName(), "UTF-8"));
                if (function.getParameters() != null) {
                    int i = 1;
                    for (RPCParameter param : function.getParameters().values()) {
                        String paramValue = (String)param.getValue();
                        if (paramValue == null) {
                            paramValue = "null";
                        }
                        netRequest.putParameter("param" + i, URLEncoder.encode(paramValue, "UTF-8"));
                    }
                }
            }
            if (this._rpcProtocolData != null) {
                for (Map.Entry me : this._rpcProtocolData.entrySet()) {
                    netRequest.putParameter((String)me.getKey(), (String)me.getValue());
                }
            }
            if (this.clientTimeout != -1L) {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("Time-out establecido a : " + this.clientTimeout);
                }
                netRequest.setTimeout(this.clientTimeout);
            } else {
                netRequest.setTimeout(10000L);
            }
            if (this._usrProxy != null && this._pwdProxy != null) {
                netRequest.setProxyAuthorization(this._usrProxy, this._pwdProxy);
            }
            return netRequest.sendUsingGet();
        }
        if (sendMode == 0) {
            netRequest.putParameter("xmlRPC", "<?xml version='1.0' encoding='ISO-8859-1'?>" + rpcCall.toXML());
            if (this._rpcProtocolData != null) {
                netRequest.putParameter("xmlRPCProtocolData", "<?xml version='1.0' encoding='ISO-8859-1'?>" + this._rpcProtocolData.toXML());
            }
            if (this._usrProxy != null && this._pwdProxy != null) {
                netRequest.setProxyAuthorization(this._usrProxy, this._pwdProxy);
            }
            if (this.clientTimeout != -1L) {
                if (RPCConstants.DEBUG) {
                    R01FLog.to("r01f.rpcDispatcher").info("Time-out establecido a : " + this.clientTimeout);
                }
                netRequest.setTimeout(this.clientTimeout);
            } else {
                netRequest.setTimeout(10000L);
            }
            return netRequest.sendUsingPost();
        }
        return null;
    }
}

