/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.rpcdispatcher.RPCCallResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class RPCCallResultParser
extends DefaultHandler
implements LexicalHandler {
    public int resultTypeCode = -1;
    public String resultType = null;
    public StringBuffer resultValue = null;
    private Stack tagStack = new Stack();
    private boolean loadingResult = false;

    public RPCCallResultParser(InputStream newIs) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this);
            saxParser.parse(newIs, (DefaultHandler)this);
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException("Error en la configuraci\u00f3n del parser: " + pcEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new SAXException("Error de IO " + ioEx.getMessage());
        }
    }

    public RPCCallResult getRPCCallResult() {
        RPCCallResult outResult = new RPCCallResult();
        outResult.setResutlType(this.resultTypeCode);
        outResult.setResult(this.resultValue.toString());
        return outResult;
    }

    public String composeDebugInfo() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<rpcCallResult>\r\n\t<dataType code='");
        sb.append(this.resultTypeCode);
        sb.append("'>");
        sb.append(this.resultType);
        sb.append("</dataType>\r\n\t<returnValue>");
        sb.append(this.resultValue);
        sb.append("\r\n\t</returnValue>\r\n</rpcCallResult>\r\n");
        return sb.toString();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
        String eName = lName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (this.loadingResult) {
            this.resultValue.append('<');
            this.resultValue.append(eName);
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.resultValue.append(" ");
                    this.resultValue.append(attrs.getQName(i));
                    this.resultValue.append("='");
                    this.resultValue.append(attrs.getValue(i));
                    this.resultValue.append("'");
                }
            }
            this.resultValue.append('>');
            return;
        }
        this.tagStack.push(eName);
        if (eName.equals("dataType") && attrs != null) {
            String resultTypeStr = attrs.getValue("code");
            this.resultTypeCode = Integer.parseInt(resultTypeStr);
        } else if (eName.equals("returnValue")) {
            this.loadingResult = true;
            this.resultValue = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        String currentTag = (String)this.tagStack.peek();
        if (currentTag.equals("dataType")) {
            this.resultType = this.resultType == null ? new String(s) : this.resultType + s;
        } else if (currentTag.equals("returnValue")) {
            this.resultValue.append(s);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("dataType")) {
            this.tagStack.pop();
        } else if (eName.equals("returnValue")) {
            this.loadingResult = false;
            this.tagStack.pop();
        } else if (this.loadingResult) {
            this.resultValue.append("</");
            this.resultValue.append(eName);
            this.resultValue.append('>');
        }
    }

    @Override
    public void startCDATA() {
        if (this.loadingResult) {
            this.resultValue.append("<![CDATA[");
        }
    }

    @Override
    public void endCDATA() {
        if (this.loadingResult) {
            this.resultValue.append("]]>");
        }
    }

    @Override
    public void comment(char[] values, int param, int param2) {
    }

    @Override
    public void startEntity(String str) {
    }

    @Override
    public void endEntity(String str) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startDTD(String str, String str1, String str2) {
    }
}

