/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.replacer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplacerTranslationTableLoader {
    public static Map loadTranslationTable(String mapFileName) throws Exception {
        if (mapFileName == null || StringUtils.isEmptyString(mapFileName)) {
            return null;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(mapFileName));
            HashMap outTranslationTable = new HashMap();
            String currLine = null;
            do {
                if ((currLine = br.readLine()) == null) continue;
                ReplacerTranslationTableLoader._parseMappingLine(outTranslationTable, currLine.trim());
            } while (currLine != null);
            if (outTranslationTable.size() > 0) {
                return outTranslationTable;
            }
        }
        catch (FileNotFoundException fnfEx) {
            throw new Exception("No se encuentra el fichero de mapeo de palabras en '" + mapFileName + "': " + fnfEx.toString());
        }
        return null;
    }

    private static void _parseMappingLine(Map outTranslationTable, String currLine) {
        Pattern p;
        Matcher m;
        String mapLinePattern = "^#([a-zA-z_0-9]+)#\\s+#([a-zA-z_0-9]+)#$";
        if (!StringUtils.isEmptyString(currLine) && (m = (p = Pattern.compile(mapLinePattern)).matcher(currLine)).matches()) {
            outTranslationTable.put(m.group(1), m.group(2));
        }
    }

    public static void main(String[] args) {
        try {
            Map table = ReplacerTranslationTableLoader.loadTranslationTable("d:/eAdmin/testStyleSheetAdaptor/translation.table");
            Map.Entry me2 = null;
            for (Map.Entry me2 : table.entrySet()) {
                R01FLog.to("r01f.test").info(me2.getKey() + " : " + me2.getValue());
            }
        }
        catch (Exception ex) {
            R01FLog.to("r01f.test").info("Exception!!!" + ex.toString());
            ex.printStackTrace(System.out);
        }
    }
}

