/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.replacer;

import com.ejie.r01f.replacer.CharSequenceReplacer;
import com.ejie.r01f.replacer.ReplaceEventListener;
import com.ejie.r01f.util.StringUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternMatchTableBasedCharReplacer
implements CharSequenceReplacer {
    private String _textFinderRegExp = null;
    private Map _translateTable = null;
    private ReplaceEventListener _eventListener = null;
    private Map _context = null;

    public PatternMatchTableBasedCharReplacer() {
    }

    public PatternMatchTableBasedCharReplacer(String textFinderRegExp, Map translateTable, ReplaceEventListener eventListener) {
        this._textFinderRegExp = textFinderRegExp;
        this._translateTable = translateTable;
        this._eventListener = eventListener;
    }

    @Override
    public CharSequence doReplace(Map context, CharSequence charSeq) {
        if (this._textFinderRegExp == null) {
            throw new IllegalStateException("La expresion regular para buscar el texto a sustituir es nula!!!");
        }
        if (this._translateTable == null) {
            throw new IllegalStateException("La tabla de mapeo de clases es nula!!!");
        }
        this._context = context;
        String outDirectiveText = new String((String)charSeq);
        String patternStr = this._textFinderRegExp;
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile(patternStr);
        m = p.matcher(outDirectiveText);
        if (m.matches()) {
            if (this._eventListener != null) {
                this._eventListener.beforeCharReplace(this._context, (String)charSeq);
            }
            if (m.groupCount() == 1 && this._translateTable.get(m.group(1)) != null) {
                outDirectiveText = StringUtils.replaceString(outDirectiveText, m.group(1), (String)this._translateTable.get(m.group(1)));
            }
            if (this._eventListener != null) {
                this._eventListener.charReplaced(this._context, (String)charSeq, outDirectiveText);
            }
        }
        return outDirectiveText;
    }
}

