/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.replacer;

import com.ejie.r01f.io.filters.DirectiveFilterReader;
import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.replacer.CharSequenceReplacer;
import com.ejie.r01f.replacer.FileReplacer;
import com.ejie.r01f.replacer.ReplaceEventListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;

public class FilteredFileReplacer
implements DirectiveListener,
FileReplacer {
    private String _directiveBeginningDelimiter = null;
    private String _directiveEndingDelimiter = null;
    private CharSequenceReplacer _charReplacer = null;
    private ReplaceEventListener _eventListener = null;
    private Map _context = null;

    public FilteredFileReplacer(String beginningDelimiter, String endingDelimiter) {
        this._directiveBeginningDelimiter = beginningDelimiter;
        this._directiveEndingDelimiter = endingDelimiter;
    }

    public FilteredFileReplacer(String beginningDelimiter, String endingDelimiter, ReplaceEventListener eventListener) {
        this(beginningDelimiter, endingDelimiter);
        this._eventListener = eventListener;
    }

    @Override
    public char[] processDirective(String directiveText, long index) throws IOException {
        if (this._charReplacer == null) {
            throw new IOException("La clase de remplazado de texto es nula!!!");
        }
        String outDirectiveText = (String)this._charReplacer.doReplace(this._context, directiveText);
        return outDirectiveText.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doReplace(Map context, String srcFile, String destFile, CharSequenceReplacer charReplacer) throws IOException {
        InputStreamReader reader = null;
        FilterReader fileFilterReader = null;
        OutputStream os = null;
        try {
            this._context = context;
            if (this._eventListener != null) {
                this._eventListener.beforeFileReplace(this._context, srcFile);
            }
            this._charReplacer = charReplacer;
            reader = new FileReader(srcFile);
            if (reader == null) {
                throw new IOException("No se ha podido abrir el fichero origen!!!\r\n");
            }
            fileFilterReader = new DirectiveFilterReader(reader);
            ((DirectiveFilterReader)fileFilterReader).addListener(this, this._directiveBeginningDelimiter, this._directiveEndingDelimiter);
            os = new FileOutputStream(new File(destFile));
            if (os == null) {
                throw new IOException("No se ha podido abrir el fichero destino!!!\r\n");
            }
            int c = 0;
            do {
                if ((c = ((DirectiveFilterReader)fileFilterReader).read()) <= 0) continue;
                os.write(c);
            } while (c > 0);
            if (this._eventListener != null) {
                this._eventListener.fileReplaced(this._context, srcFile);
            }
        }
        finally {
            if (fileFilterReader != null) {
                fileFilterReader.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }
}

