/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.reflection;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.StringConverter;

public class ReflectionUtils {
    private static final Set FINAL_IMMUTABLE_CLASSES = new HashSet(17);
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final Class[] EMPTY_CLASS_ARRAY;

    public static boolean isFinalInmutable(Class classDef) {
        return classDef.isPrimitive() || FINAL_IMMUTABLE_CLASSES.contains(classDef);
    }

    public static String getClassNameFromCompleteClassName(String className) {
        if (className == null || className.length() == 0) {
            return "";
        }
        if (className.indexOf(46) < 0) {
            return className;
        }
        Pattern p = Pattern.compile("^.*\\.([^.]+)$");
        Matcher m = p.matcher(className);
        if (!m.matches()) {
            return "";
        }
        return m.group(1);
    }

    public static String getPackageFromCompletClassName(String className) {
        if (className == null || className.length() == 0) {
            return "";
        }
        if (className.indexOf(46) < 0) {
            return "";
        }
        Pattern p = Pattern.compile("^(.*)\\.[^.]+$");
        Matcher m = p.matcher(className);
        if (!m.matches()) {
            return "";
        }
        return m.group(1);
    }

    public static Class getObjectClassDef(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("El nombre de la clase que se pasa es nulo!!!");
        }
        Class<?> objClassDef = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                objClassDef = cl.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (objClassDef == null) {
                objClassDef = Class.forName(className);
            }
        }
        if (objClassDef == null) {
            throw new ClassNotFoundException("No se ha podido obtener la definici\u00f3n de la clase");
        }
        return objClassDef;
    }

    public static Object getObjectInstance(String className, Class[] constructorArgsClassDefs, Object[] constructorArgs, boolean force) throws ReflectionException {
        try {
            Class objClassDef = ReflectionUtils.getObjectClassDef(className);
            return ReflectionUtils.getObjectInstance(objClassDef, constructorArgsClassDefs, constructorArgs, force);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ReflectionException("No se encuentra la clase '" + className + "': revisa el classPath", (Exception)cnfEx);
        }
        catch (Throwable th) {
            th.printStackTrace(System.out);
            return null;
        }
    }

    public static Object getObjectInstance(String className) throws ReflectionException {
        return ReflectionUtils.getObjectInstance(className, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY, true);
    }

    public static Object getObjectInstance(Class classDef, Class[] constructorArgsClassDefs, Object[] constructorArgs, boolean force) throws ReflectionException {
        if (classDef == null) {
            return null;
        }
        Object newObj = null;
        Constructor constructor = null;
        try {
            constructor = ConstructorUtils.getAccessibleConstructor((Class)classDef, (Class[])(constructorArgsClassDefs != null ? constructorArgsClassDefs : new Class[]{}));
            if (constructor == null && force) {
                constructor = classDef.getDeclaredConstructor(constructorArgsClassDefs != null ? constructorArgsClassDefs : new Class[]{});
                if (force && (1 & constructor.getModifiers()) == 0) {
                    constructor.setAccessible(true);
                }
            }
            newObj = constructor.newInstance(constructorArgs != null ? constructorArgs : new Object[]{});
        }
        catch (SecurityException secEx) {
            throw new ReflectionException("Error de seguridad: No se puede modificar la visibilidad del constructor vacio [" + constructor + "] de la clase [" + classDef.getPackage() + classDef.getName() + "]: para hacerlo accesible al clonado por reflection " + secEx.toString(), (Exception)secEx);
        }
        catch (InstantiationException insEx) {
            throw new ReflectionException("Error al instanciar la clase '" + classDef.getPackage() + classDef.getName() + "': no se ha podido instanciar", (Exception)insEx);
        }
        catch (IllegalAccessException ilAcEx) {
            throw new ReflectionException("Acceso ilegal a la clase '" + classDef.getPackage() + classDef.getName() + "'", (Exception)ilAcEx);
        }
        catch (InvocationTargetException invTgtEx) {
            throw new ReflectionException("Error al invocar al constructor de la clase " + classDef.getPackage() + classDef.getName(), (Exception)invTgtEx);
        }
        catch (Exception ex) {
            throw new ReflectionException("El constructor de la clase " + classDef.getPackage() + classDef.getName() + " ha lanzado una excepcion: " + ex.getMessage(), ex);
        }
        catch (Throwable th) {
            th.printStackTrace(System.out);
        }
        return newObj;
    }

    public static Object getObjectInstance(Class classDef) throws ReflectionException {
        return ReflectionUtils.getObjectInstance(classDef, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY, true);
    }

    public static boolean isArray(Class theClass) {
        return theClass.isArray();
    }

    public static boolean isMap(Class theClass) {
        if (theClass.isAssignableFrom(Map.class)) {
            return true;
        }
        Class<?>[] interfaces = theClass.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return ReflectionUtils.isMap(theClass.getSuperclass());
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].isAssignableFrom(Map.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isList(Class theClass) {
        if (theClass.isAssignableFrom(List.class)) {
            return true;
        }
        Class<?>[] interfaces = theClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].isAssignableFrom(List.class)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSubClassOf(Class theClass, Class theBaseClass) {
        Class currSuperClass = theClass;
        do {
            if (!theBaseClass.equals(currSuperClass)) continue;
            return true;
        } while ((currSuperClass = currSuperClass.getSuperclass()) != null);
        return false;
    }

    public static boolean isSubClassOf(Object theObj, Object theBaseObj) {
        if (theObj == null && theBaseObj != null) {
            return false;
        }
        if (theObj != null && theBaseObj == null) {
            return false;
        }
        return ReflectionUtils.isSubClassOf(theObj.getClass(), theBaseObj.getClass());
    }

    public static boolean isSameClassAs(Class theClass, Class theOtherClass) {
        return theClass.equals(theOtherClass);
    }

    public static boolean isSameClassAs(Object theObj, Object theOtherObj) {
        if (theObj == null && theOtherObj != null) {
            return false;
        }
        if (theObj != null && theOtherObj == null) {
            return false;
        }
        return ReflectionUtils.isSameClassAs(theObj.getClass(), theOtherObj.getClass());
    }

    public static Method[] getAllMethodsArray(Class objClassDef) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class c = objClassDef; c != Object.class; c = c.getSuperclass()) {
            Method[] declaredMethods = c.getDeclaredMethods();
            if (declaredMethods == null) continue;
            methods.addAll(Arrays.asList(declaredMethods));
        }
        Method[] outMethods = new Method[methods.size()];
        return methods.toArray(outMethods);
    }

    public static Method getMethod(Class objClassDef, String methodName, Class[] paramTypes) throws NoSuchMethodException {
        for (Class c = objClassDef; c != Object.class; c = c.getSuperclass()) {
            try {
                Method m = c.getDeclaredMethod(methodName, paramTypes != null ? paramTypes : new Class[]{});
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException nsmEx) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException("No se puede encontrar el metodo " + ReflectionUtils.composeMethodSignature(objClassDef.getName(), methodName, paramTypes));
    }

    public static Object invokeMethod(Object obj, Method methodDef, Object[] argValues) throws Throwable, ReflectionException {
        if (methodDef == null) {
            throw new ReflectionException("No se puede invocar al metodo NULL!!!");
        }
        if (obj == null) {
            throw new ReflectionException("No se puede invocar el metodo " + methodDef.getName() + " ya que el objeto es nulo!");
        }
        try {
            Class<?> objClassDef = obj.getClass();
            return methodDef.invoke(obj, argValues != null ? argValues : new Object[]{});
        }
        catch (IllegalAccessException illAccEx) {
            throw new ReflectionException("Acceso ilegal al llamar al metodo " + methodDef.toString() + " en el objeto " + obj.getClass().getName(), (Exception)illAccEx);
        }
        catch (InvocationTargetException invTgtEx) {
            invTgtEx.getTargetException().printStackTrace(System.out);
            throw invTgtEx.getTargetException();
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Class[] argsTypes, Object[] argsValues) throws Throwable, ReflectionException {
        if (methodName == null) {
            throw new ReflectionException("No se puede invocar al metodo NULL!!!");
        }
        if (obj == null) {
            throw new ReflectionException("No se puede invocar el metodo " + methodName + " ya que el objeto es nulo!");
        }
        Class<?> objClassDef = obj.getClass();
        try {
            return MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])argsValues, (Class[])argsTypes);
        }
        catch (NoSuchMethodException nsmEx) {
            throw new ReflectionException("No se encuentra el metodo " + ReflectionUtils.composeMethodSignature(obj.getClass().getName(), methodName, argsTypes) + " en el objeto " + objClassDef.getName(), (Exception)nsmEx);
        }
    }

    public static Object invokeStaticMethod(Class classDef, String methodName, Class[] argsTypes, Object[] argsValues) throws Throwable, ReflectionException {
        if (methodName == null) {
            throw new ReflectionException("No se puede invocar al metodo NULL!!!");
        }
        if (classDef == null) {
            throw new ReflectionException("No se puede invocar el metodo " + methodName + " ya que la definicion de la clase es nula!");
        }
        Method methodDef = null;
        try {
            methodDef = ReflectionUtils.getMethod(classDef, methodName, argsTypes);
            return methodDef.invoke(null, argsValues);
        }
        catch (NoSuchMethodException nsmEx) {
            throw new ReflectionException("No se encuentra el metodo " + ReflectionUtils.composeMethodSignature(classDef.getName(), methodName, argsTypes) + " en el objeto " + classDef.getName(), (Exception)nsmEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new ReflectionException("Acceso ilegal al llamar al metodo " + methodDef.toString() + " en el objeto " + classDef.getName(), (Exception)illAccEx);
        }
        catch (InvocationTargetException invTgtEx) {
            invTgtEx.getTargetException().printStackTrace(System.out);
            throw invTgtEx.getTargetException();
        }
    }

    public static String composeMethodSignature(String className, String methodName, Class[] paramTypes) {
        if (className != null && methodName != null) {
            String outSignature = className + "." + methodName + "(";
            if (paramTypes == null) {
                return outSignature + ")";
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                outSignature = outSignature + paramTypes[i].getName() + " param" + i;
                if (i >= paramTypes.length - 1) continue;
                outSignature = outSignature + ",";
            }
            return outSignature + ")";
        }
        return "No se puede obtener la signatura del metodo ya que la definicion de la clase o el nombre del metodo son nulos";
    }

    public static String composeMethodSignature(Method m) {
        if (m == null) {
            return "<metodo nulo>";
        }
        StringBuffer outSignature = new StringBuffer();
        outSignature.append(m.getReturnType().getName());
        outSignature.append(" ");
        outSignature.append(m.getName());
        outSignature.append('(');
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                outSignature.append(paramTypes[i].getName());
                outSignature.append(" param");
                outSignature.append(i);
                if (i >= paramTypes.length - 1) continue;
                outSignature.append(',');
            }
        }
        outSignature.append(')');
        Class<?>[] thrownTypes = m.getExceptionTypes();
        if (thrownTypes != null) {
            outSignature.append(" throws ");
            for (int i = 0; i < thrownTypes.length; ++i) {
                outSignature.append(thrownTypes[i].getName());
                if (i >= thrownTypes.length - 1) continue;
                outSignature.append(',');
            }
        }
        outSignature.append(';');
        return outSignature.toString();
    }

    public static String composeClassMethodsSignatures(Class classDef) {
        if (classDef == null) {
            return "<La definicion de la clase es nula>";
        }
        StringBuffer strDebug = new StringBuffer();
        Method[] methods = ReflectionUtils.getAllMethodsArray(classDef);
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                strDebug.append(methods[i].getDeclaringClass().getName());
                strDebug.append(" > ");
                strDebug.append(ReflectionUtils.composeMethodSignature(methods[i]));
            }
        } else {
            strDebug.append("<La clase ");
            strDebug.append(classDef);
            strDebug.append(" NO tiene m\u00e9todos definidos>");
        }
        return strDebug.toString();
    }

    public static Map getAllFieldsMap(Class objClassDef) throws ReflectionException {
        if (objClassDef == null) {
            throw new ReflectionException("La definicion de la clase es null: No se puede obtener la lista de miembros!!");
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class c = objClassDef; c != Object.class; c = c.getSuperclass()) {
            Field[] declaredFields = c.getDeclaredFields();
            if (declaredFields == null || declaredFields.length <= 0) continue;
            for (int i = 0; i < declaredFields.length; ++i) {
                fields.put(declaredFields[i].getName(), declaredFields[i]);
            }
        }
        return fields;
    }

    public static Field[] getAllFieldsArray(Class objClassDef) throws ReflectionException {
        Map fields = ReflectionUtils.getAllFieldsMap(objClassDef);
        if (fields.size() > 0) {
            Field[] outArray = new Field[fields.size()];
            return fields.values().toArray(outArray);
        }
        return new Field[0];
    }

    public static Field getField(Class objClassDef, String fieldName) throws NoSuchFieldException {
        for (Class c = objClassDef; c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(fieldName);
                if (f == null) continue;
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        throw new NoSuchFieldException("No se puede encontrar el miembro: " + fieldName + " en la clase " + objClassDef.getName());
    }

    public static String getFieldSetterName(Class objClassDef, String memberName, Class memberClassDef) {
        String setter = null;
        if (memberClassDef == Boolean.class || memberClassDef == Boolean.TYPE) {
            setter = "set" + (memberName.startsWith("is") ? StringUtils.capitalizeFirstLetter(memberName.substring(2)) : StringUtils.capitalizeFirstLetter(memberName));
            try {
                ReflectionUtils.getMethod(objClassDef, setter, new Class[0]);
            }
            catch (NoSuchMethodException nsmEx) {
                setter = "set" + StringUtils.capitalizeFirstLetter(memberName);
            }
        } else {
            setter = "set" + StringUtils.capitalizeFirstLetter(memberName);
        }
        return setter;
    }

    public static String getFieldGetterName(Class objClassDef, String memberName, Class memberClassDef) {
        String getter = null;
        if (memberClassDef == Boolean.class || memberClassDef == Boolean.TYPE) {
            getter = "is" + (memberName.startsWith("is") ? StringUtils.capitalizeFirstLetter(memberName.substring(2)) : StringUtils.capitalizeFirstLetter(memberName));
            try {
                ReflectionUtils.getMethod(objClassDef, getter, new Class[0]);
            }
            catch (NoSuchMethodException nsmEx) {
                getter = "get" + StringUtils.capitalizeFirstLetter(memberName);
            }
        } else {
            getter = "get" + StringUtils.capitalizeFirstLetter(memberName);
        }
        return getter;
    }

    public static void setMemberValue(Object obj, String memberName, Class memberClassDef, Object value, boolean useAccessor) throws ReflectionException {
        if (value == null) {
            return;
        }
        if (obj == null) {
            throw new ReflectionException("No se puede establecer la variable " + memberName + " ya que el objeto es nulo!!!");
        }
        String accessorToUse = null;
        if (useAccessor) {
            try {
                PropertyUtils.setSimpleProperty((Object)obj, (String)memberName, (Object)value);
            }
            catch (Exception ex) {
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n*****************************************\r\nNO existe el metodo set del miembro " + memberName + ". Se intenta una alternativa NO ortodoxa. Se recomienda revisar el c\u00f3digo....\r\n*****************************************\r\n\r\n\r\n");
                accessorToUse = ReflectionUtils.getFieldSetterName(obj.getClass(), memberName, memberClassDef);
                Class valueClass = null;
                valueClass = ReflectionUtils.isMap(value.getClass()) ? Map.class : (ReflectionUtils.isList(value.getClass()) ? List.class : memberClassDef);
                try {
                    Method accessorMethod = ReflectionUtils.getMethod(obj.getClass(), accessorToUse, new Class[]{valueClass});
                    accessorMethod.invoke(obj, value);
                }
                catch (IllegalAccessException nsfEx) {
                    throw new ReflectionException("Acceso ilegal a la variable miembro '" + memberName + "' de la clase " + obj.getClass().getName(), (Exception)nsfEx);
                }
                catch (IllegalArgumentException illArgEx) {
                    throw new ReflectionException("Error al establecer el valor de la variable miembro '" + memberName + "' de la clase '" + obj.getClass().getName() + "', el valor a establecer de clase " + value.getClass().getName() + " no es del tipo esperado", (Exception)illArgEx);
                }
                catch (NoSuchMethodException nsmEx) {
                    throw new ReflectionException("Error al invocar al metodo accessor " + accessorToUse + " para establecer la variable miembro " + memberName + " de la clase " + obj.getClass().getName() + ": El metodo no existe", (Exception)nsmEx);
                }
                catch (InvocationTargetException invTgtEx) {
                    throw new ReflectionException("Error al invocar al metodo accessor " + accessorToUse + " para establecer la variable miembro " + memberName + " de la clase " + obj.getClass().getName() + ": Se ha producido una excepcion ->" + invTgtEx.toString(), (Exception)invTgtEx);
                }
            }
        } else {
            ReflectionUtils.setMemberValue(obj, memberName, value, false);
        }
    }

    public static void setMemberValue(Object obj, String memberName, Object value, boolean useAccessor) throws ReflectionException {
        block12: {
            if (value == null) {
                return;
            }
            if (obj == null) {
                throw new ReflectionException("No se puede establecer la variable " + memberName + " ya que el objeto es nulo!!!");
            }
            String accessorToUse = null;
            try {
                if (useAccessor) {
                    PropertyUtils.setSimpleProperty((Object)obj, (String)memberName, (Object)value);
                    break block12;
                }
                Field memberField = ReflectionUtils.getField(obj.getClass(), memberName);
                int modifiers = memberField.getModifiers();
                if ((1 & modifiers) == 0) {
                    try {
                        memberField.setAccessible(true);
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException("Error de seguridad: No se puede hacer accesible el miembro [" + memberName + "] de la clase [" + obj.getClass().getName() + "]: " + e.toString());
                    }
                }
                memberField.set(obj, value);
            }
            catch (NoSuchFieldException nsfEx) {
                throw new ReflectionException("La variable miembro '" + memberName + "' de la clase '" + obj.getClass().getName() + "', no existe " + nsfEx.getMessage(), (Exception)nsfEx);
            }
            catch (IllegalAccessException nsfEx) {
                throw new ReflectionException("Acceso ilegal a la variable miembro '" + memberName + "' de la clase " + obj.getClass().getName(), (Exception)nsfEx);
            }
            catch (IllegalArgumentException illArgEx) {
                throw new ReflectionException("Error al establecer el valor de la variable miembro '" + memberName + "' de la clase '" + obj.getClass().getName() + "', el valor a establecer de clase " + value.getClass().getName() + " no es del tipo esperado", (Exception)illArgEx);
            }
            catch (NoSuchMethodException nsmEx) {
                throw new ReflectionException("Error al invocar al metodo accessor " + accessorToUse + " para establecer la variable miembro " + memberName + " de la clase " + obj.getClass().getName() + ": El metodo no existe", (Exception)nsmEx);
            }
            catch (InvocationTargetException invTgtEx) {
                throw new ReflectionException("Error al invocar al metodo accessor " + accessorToUse + " para establecer la variable miembro " + memberName + " de la clase " + obj.getClass().getName() + ": Se ha producido una excepcion ->" + invTgtEx.toString(), (Exception)invTgtEx);
            }
        }
    }

    public static void setMemberValueAsString(Object obj, String memberName, String value, boolean useAccessor) throws ReflectionException {
        ReflectionUtils.setMemberValue(obj, memberName, String.class, value, useAccessor);
    }

    public static void setMemberValueAsInteger(Object obj, String memberName, Integer value, boolean useAccessor) throws ReflectionException {
        ReflectionUtils.setMemberValue(obj, memberName, String.class, value, useAccessor);
    }

    public static void setMemberValueAsLong(Object obj, String memberName, Long value, boolean useAccessor) throws ReflectionException {
        ReflectionUtils.setMemberValue(obj, memberName, String.class, value, useAccessor);
    }

    public static void setMemberValueAsDouble(Object obj, String memberName, Double value, boolean useAccessor) throws ReflectionException {
        ReflectionUtils.setMemberValue(obj, memberName, String.class, value, useAccessor);
    }

    public static void setMemberValueAsShort(Object obj, String memberName, Short value, boolean useAccessor) throws ReflectionException {
        ReflectionUtils.setMemberValue(obj, memberName, String.class, value, useAccessor);
    }

    public static void setMemberValueAsFloat(Object obj, String memberName, Float value, boolean useAccessor) throws ReflectionException {
        ReflectionUtils.setMemberValue(obj, memberName, String.class, value, useAccessor);
    }

    public static Object getMemberValue(Object obj, String memberName, boolean useAccessor) throws ReflectionException {
        if (obj == null) {
            throw new ReflectionException("No se puede obtener el valor de la variable " + memberName + " ya que el objeto es nulo!!!");
        }
        String accessorToUse = null;
        try {
            if (useAccessor) {
                return PropertyUtils.getSimpleProperty((Object)obj, (String)memberName);
            }
            Field memberField = ReflectionUtils.getField(obj.getClass(), memberName);
            int modifiers = memberField.getModifiers();
            if ((1 & modifiers) == 0) {
                try {
                    memberField.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Error de seguridad: No se puede hacer accesible el miembro [" + memberName + "] de la clase [" + obj.getClass().getName() + "]: " + e.toString());
                }
            }
            return memberField.get(obj);
        }
        catch (NoSuchFieldException nsfEx) {
            throw new ReflectionException("La variable miembro '" + memberName + "' de la clase '" + obj.getClass().getName() + "', no existe " + nsfEx.getMessage(), (Exception)nsfEx);
        }
        catch (IllegalAccessException nsfEx) {
            throw new ReflectionException("Acceso ilegal a la variable miembro '" + memberName + "' de la clase " + obj.getClass().getName(), (Exception)nsfEx);
        }
        catch (NoSuchMethodException nsmEx) {
            throw new ReflectionException("Error al invocar al metodo accessor " + accessorToUse + " para obtener la variable miembro " + memberName + " de la clase " + obj.getClass().getName() + ": El metodo no existe", (Exception)nsmEx);
        }
        catch (InvocationTargetException invTgtEx) {
            throw new ReflectionException("Error al invocar al metodo accessor " + accessorToUse + " para obtener la variable miembro " + memberName + " de la clase " + obj.getClass().getName() + ": Se ha producido una excepcion ->" + invTgtEx.toString(), (Exception)invTgtEx);
        }
    }

    public static String getMemberValueAsString(Object obj, String memberName, boolean useAccessor) throws ReflectionException {
        Object objVal = ReflectionUtils.getMemberValue(obj, memberName, useAccessor);
        StringConverter sc = new StringConverter();
        return (String)sc.convert(String.class, obj);
    }

    public static Long getMemberValueAsLong(Object obj, String memberName, boolean useAccessor) throws ReflectionException {
        Object objVal = ReflectionUtils.getMemberValue(obj, memberName, useAccessor);
        LongConverter lc = new LongConverter();
        return (Long)lc.convert(Long.class, objVal);
    }

    public static Double getMemberValueAsDouble(Object obj, String memberName, boolean useAccessor) throws ReflectionException {
        Object objVal = ReflectionUtils.getMemberValue(obj, memberName, useAccessor);
        DoubleConverter dc = new DoubleConverter();
        return (Double)dc.convert(Double.class, objVal);
    }

    public static Short getMemberValueAsShort(Object obj, String memberName, boolean useAccessor) throws ReflectionException {
        Object objVal = ReflectionUtils.getMemberValue(obj, memberName, useAccessor);
        ShortConverter lc = new ShortConverter();
        return (Short)lc.convert(Short.class, objVal);
    }

    public static Float getMemberValueAsFloat(Object obj, String memberName, boolean useAccessor) throws ReflectionException {
        Object objVal = ReflectionUtils.getMemberValue(obj, memberName, useAccessor);
        FloatConverter fc = new FloatConverter();
        return (Float)fc.convert(Float.class, objVal);
    }

    public static void setMemberValueUsingPath(Object obj, String memberPath, Object memberValue, boolean useAccesors) throws ReflectionException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, NoSuchFieldException {
        if (obj == null || memberPath == null) {
            throw new IllegalArgumentException("El objeto o el path NO son v\u00e1lidos");
        }
        StringTokenizer st = new StringTokenizer(memberPath, ".");
        String currMemberName = null;
        Object currObj = obj;
        do {
            currMemberName = st.nextToken();
            if (st.hasMoreTokens()) {
                Object instance = ReflectionUtils.getMemberValue(currObj, currMemberName, useAccesors);
                if (instance == null) {
                    Class<?> currInstanceClass = null;
                    currInstanceClass = useAccesors ? PropertyUtils.getPropertyType((Object)currObj, (String)currMemberName) : ReflectionUtils.getField(currObj.getClass(), currMemberName).getType();
                    if (currInstanceClass.isArray() || ReflectionUtils.isList(currInstanceClass) || ReflectionUtils.isMap(currInstanceClass)) {
                        throw new ReflectionException("De momento el metodo setMemberValueUsingPath NO soporta elementos tipo array, lista o map en el path");
                    }
                    instance = ReflectionUtils.getObjectInstance(currInstanceClass);
                    ReflectionUtils.setMemberValue(currObj, currMemberName, instance.getClass(), instance, useAccesors);
                }
                currObj = instance;
                continue;
            }
            ReflectionUtils.setMemberValue(currObj, currMemberName, memberValue, useAccesors);
        } while (st.hasMoreTokens());
    }

    public static Object getMemberValueUsingPath(Object obj, String memberPath, boolean useAccesors) throws ReflectionException {
        if (obj == null || memberPath == null) {
            throw new IllegalArgumentException("El objeto o el path NO son v\u00e1lidos");
        }
        StringTokenizer st = new StringTokenizer(memberPath, ".");
        if (st.hasMoreTokens()) {
            try {
                Object currObj = obj;
                Class<?> currObjClass = currObj.getClass();
                Field currObjField = null;
                String[] currPathElem = null;
                do {
                    currPathElem = ReflectionUtils._parsePathElem(st.nextToken());
                    if (useAccesors) {
                        if ((currObj = ReflectionUtils.getMemberValue(currObj, currPathElem[0], useAccesors)) != null) {
                            currObjClass = currObj.getClass();
                        }
                    } else {
                        try {
                            currObjField = ReflectionUtils.getField(currObjClass, currPathElem[0]);
                            if (currObjField != null && (currObj = currObjField.get(currObj)) != null) {
                                currObjClass = currObj.getClass();
                            }
                        }
                        catch (NoSuchFieldException nsfEx) {
                            throw new ReflectionException("No se encuentra el miembro", (Exception)nsfEx);
                        }
                        catch (IllegalAccessException illAccEx) {
                            throw new ReflectionException("IllegalAccessException: Acceso ilegal al miembro '" + memberPath + "'", (Exception)illAccEx);
                        }
                    }
                    if (currPathElem[1] == null) continue;
                    boolean found = false;
                    if (currObjClass.isArray()) {
                        if ((currObj = Array.get(currObj, Integer.parseInt(currPathElem[1]))) != null) {
                            currObjClass = currObj.getClass();
                        }
                        found = true;
                    } else {
                        Class<?>[] currObjInterfaces = currObjClass.getInterfaces();
                        if (currObjInterfaces != null) {
                            for (int i = 0; i < currObjInterfaces.length; ++i) {
                                if (currObjInterfaces[i].equals(List.class)) {
                                    List list = (List)currObj;
                                    if ((currObj = list.get(Integer.parseInt(currPathElem[1]))) != null) {
                                        currObjClass = currObj.getClass();
                                    }
                                    found = true;
                                    break;
                                }
                                if (!currObjInterfaces[i].equals(Map.class)) continue;
                                Map map = (Map)currObj;
                                if ((currObj = map.get(currPathElem[1])) != null) {
                                    currObjClass = currObj.getClass();
                                }
                                found = true;
                                break;
                            }
                        }
                    }
                    if (found) continue;
                    throw new ReflectionException("Se ha especificado que el miembro del path es un array, mapa o lista, sin embargo, su tipo es '" + currObjClass.getName() + "'");
                } while (st.hasMoreTokens());
                return currObj;
            }
            catch (ArrayIndexOutOfBoundsException aiobEx) {
                throw new ReflectionException("ArrayIndexOutOfBounds: El elemento del array no existe (" + memberPath + ")", (Exception)aiobEx);
            }
        }
        return null;
    }

    private static String[] _parsePathElem(String pathElem) {
        String fieldName = pathElem;
        String ord = null;
        int p = -1;
        p = pathElem.indexOf("[");
        if (p > 0) {
            fieldName = pathElem.substring(0, p);
            ord = pathElem.substring(p + 1, pathElem.length() - 1);
        }
        String[] out = new String[]{fieldName, ord};
        return out;
    }

    public static void main(String[] args) {
        try {
            R01FLog.to("r01f.test").info(String.class.getName() + ":" + String.class.getPackage());
            R01FLog.to("r01f.test").info(">>Paquete de com.ejie.r01f.R01FClass: " + ReflectionUtils.getPackageFromCompletClassName("com.ejie.r01f.R01FClass"));
            R01FLog.to("r01f.test").info(">>Paquete de R01FClass: " + ReflectionUtils.getPackageFromCompletClassName("R01FClass"));
            R01FLog.to("r01f.test").info(">>Paquete de '': " + ReflectionUtils.getPackageFromCompletClassName(""));
            R01FLog.to("r01f.test").info("<<Clase de com.ejie.r01f.R01FClass: " + ReflectionUtils.getClassNameFromCompleteClassName("com.ejie.r01f.R01FClass"));
            R01FLog.to("r01f.test").info("<<Clase de R01FClass: " + ReflectionUtils.getClassNameFromCompleteClassName("R01FClass"));
            R01FLog.to("r01f.test").info("<<Clase de '': " + ReflectionUtils.getClassNameFromCompleteClassName(""));
            R01FLog.to("r01f.test").info("\r\n\r\n\r\n\r\n\r\n");
            R01FLog.to("r01f.test").info("Test 1>>>>>>>>");
            R01FLog.to("r01f.test").info(">>>>" + ReflectionUtils.isSubClassOf(MyClass.class, BaseClass.class));
            R01FLog.to("r01f.test").info("Test 2>>>>>>>>");
            ReflectionUtils test = new ReflectionUtils();
            Abuelo abuelo = test.new Abuelo();
            abuelo.nombre = "YOOOO";
            R01FLog.to("r01f.test").info(ReflectionUtils.getMemberValue(abuelo, "nombre", true).toString());
            ReflectionUtils.setMemberValue(abuelo, "nombre", String.class, "TUUUUU", true);
            R01FLog.to("r01f.test").info(ReflectionUtils.getMemberValue(abuelo, "nombre", true).toString());
            Object descendente = ReflectionUtils.getMemberValueUsingPath(abuelo, "padre.hijos[1]", false);
            R01FLog.to("r01f.test").info(abuelo.padre.simpleHijo.nombre);
            if (descendente == null) {
                R01FLog.to("r01f.test").info(" No se ha encontrado el descendente ");
            } else {
                R01FLog.to("r01f.test").info(descendente.toString());
            }
        }
        catch (Exception ex) {
            R01FLog.to("r01f.test").info("ERROR!!!!!" + ex.toString());
            ex.printStackTrace(System.out);
        }
    }

    static {
        FINAL_IMMUTABLE_CLASSES.add(String.class);
        FINAL_IMMUTABLE_CLASSES.add(Byte.class);
        FINAL_IMMUTABLE_CLASSES.add(Short.class);
        FINAL_IMMUTABLE_CLASSES.add(Integer.class);
        FINAL_IMMUTABLE_CLASSES.add(Long.class);
        FINAL_IMMUTABLE_CLASSES.add(Float.class);
        FINAL_IMMUTABLE_CLASSES.add(Double.class);
        FINAL_IMMUTABLE_CLASSES.add(Character.class);
        FINAL_IMMUTABLE_CLASSES.add(Boolean.class);
        FINAL_IMMUTABLE_CLASSES.add(java.util.Date.class);
        FINAL_IMMUTABLE_CLASSES.add(Date.class);
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
    }

    public class MyClass
    extends BaseClass {
    }

    public class BaseClass {
    }

    public class Abuelo {
        public String nombre = "soy el aitite";
        public Padre padre = new Padre();

        public String toString() {
            return "Abuelo = " + this.nombre;
        }

        public String getNombre() {
            return this.nombre;
        }

        public void setNombre(String theNombre) {
            this.nombre = theNombre;
        }
    }

    public class Padre {
        public String nombre = "soy el aita";
        public Hijo simpleHijo = null;
        public Hijo[] hijos = new Hijo[2];
        public List nietos = new ArrayList();
        public Map primos = new HashMap();

        public Padre() {
            this.hijos[0] = new Hijo("hijo1");
            this.hijos[1] = new Hijo("hijo2");
            this.nietos.add(new Hijo("nieto1"));
            this.nietos.add(new Hijo("nieto2"));
            this.primos.put("manolo", new Hijo("Manolo"));
            this.primos.put("alfredo", new Hijo("alfredo"));
        }

        public String toString() {
            return "Padre = " + this.nombre;
        }
    }

    public class Hijo {
        public String nombre = "soy el seme";

        public Hijo() {
        }

        public Hijo(String newName) {
            this.nombre = newName;
        }

        public String toString() {
            return "Hijo = " + this.nombre;
        }
    }
}

