/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.process;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.process.Job;
import com.ejie.r01f.process.JobManager;
import com.ejie.r01f.process.JobManagerFactory;
import com.ejie.r01f.process.TestCallBackCapable;
import com.ejie.r01f.process.TestJobPerformer;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class TestJobManager {
    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 10;
            for (int times = 0; times < testTimes; ++times) {
                JobManager.Stats stats = null;
                JobManager jobManager = JobManagerFactory.getInstance();
                TestCallBackCapable cb = new TestCallBackCapable();
                Method cbM = cb.getClass().getMethod("operationCompleted", String.class);
                Method jpm = TestJobPerformer.class.getMethod("diHola", new Class[0]);
                TestJobPerformer jp1 = new TestJobPerformer("Hola Caracola!");
                TestJobPerformer jp2 = new TestJobPerformer("Adios pirulo!");
                ArrayList<Job> jobList = new ArrayList<Job>();
                Job job1 = new Job(null, jp1, jpm, null, cb, cbM);
                Job job2 = new Job(null, jp2, jpm, null, null, null);
                for (int i = 0; i < 1; ++i) {
                    jobList.add(job1);
                    jobList.add(job2);
                }
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n\r\n\r\n---->Se comienza la ejecuci\u00f3n de los trabajos!!!");
                jobManager.waitForAll(jobList, 1000L);
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n\r\n\r\n---->Se han ejecutado todos los trabajos!!!");
                R01FLog.to("r01f.test").info(">>> Resultados de la ejecuci\u00f3n: ");
                for (Job currJob : jobList) {
                    try {
                        Object result = currJob.getResult();
                        R01FLog.to("r01f.test").info("Resultado>>>>> " + result);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                stats = jobManager.getStats();
                R01FLog.to("r01f.test").info(">>>>Estadisticas de la ejecuci\u00f3n de trabajos\r\n" + stats.composeDebugInfo() + "\r\n----------------------------------------------------->");
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n========= FIN PRIMER TEST =========\r\n\r\n\r\n");
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n\r\n\r\n---->Se comienza la ejecuci\u00f3n de los trabajos!!!");
                jobManager.startAll(jobList);
                R01FLog.to("r01f.test").info("\r\n\r\n\r\n\r\n\r\n---->NO se sabe si se han ejecutado todos los trabajos!!!");
                try {
                    do {
                        stats = jobManager.getStats();
                        R01FLog.to("r01f.test").info(">>>>Estadisticas de la ejecuci\u00f3n de trabajos\r\n" + stats.composeDebugInfo() + "\r\n----------------------------------------------------->");
                        if (stats.pendingJobs <= 0) continue;
                        Thread.sleep(500L);
                    } while (stats.jobsInProgress > 0);
                    R01FLog.to("r01f.test").info("---->Todos los trabajos han terminado!!!");
                    continue;
                }
                catch (InterruptedException intEx) {
                    intEx.printStackTrace(System.out);
                }
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

