/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.process;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.guids.GUIDDispenserManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.process.CallBackCapable;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import java.lang.reflect.Method;

public class Job {
    private String _jobId;
    private Object _jobPerformerObj;
    private Method _jobPerformerMethod = null;
    private Object[] _jobPerformerMethodArgsValues;
    private Object _callBackObj = null;
    private Method _callBackMethod = null;
    private long _jobEnqueuedTimeStamp;
    private long _jobStartedTimeStamp;
    private long _jobPerformedTimeStamp;
    private Object _result;
    private boolean _started = false;
    private boolean _ended = false;

    public Job() {
    }

    public Job(String newJobId, Object newJobPerformerObj, Method newJobPerformerMethod, Object[] newJobPerformerMethodArgsValues, Object newCallBackObj, Method newCallBackMethod) {
        this();
        this.setJobId(newJobId);
        this.setJobPerformerObject(newJobPerformerObj);
        this.setJobPerformerMethod(newJobPerformerMethod);
        this.setJobPerformerMethodArgsValues(newJobPerformerMethodArgsValues);
        this.setCallBackObject(newCallBackObj);
        this.setCallBackMethod(newCallBackMethod);
        this._jobEnqueuedTimeStamp = System.currentTimeMillis();
        this._jobStartedTimeStamp = Long.MIN_VALUE;
        this._jobPerformedTimeStamp = Long.MIN_VALUE;
    }

    public void perform() {
        try {
            Object retObj;
            this._started = true;
            this._jobStartedTimeStamp = System.currentTimeMillis();
            this._result = retObj = ReflectionUtils.invokeMethod(this._jobPerformerObj, this._jobPerformerMethod, this._jobPerformerMethodArgsValues);
            if (this._callBackObj != null && this._callBackMethod != null) {
                ReflectionUtils.invokeMethod(this._callBackObj, this._callBackMethod, new Object[]{retObj});
            } else if (this._callBackObj != null && this._callBackMethod == null && this._callBackObj.getClass().isAssignableFrom(CallBackCapable.class)) {
                ((CallBackCapable)this._callBackObj).receiveResponse(retObj);
            }
        }
        catch (ReflectionException refEx) {
        }
        catch (Throwable th) {
            this._result = th;
            if (this._callBackObj != null) {
                if (this._callBackObj.getClass().isAssignableFrom(CallBackCapable.class)) {
                    ((CallBackCapable)this._callBackObj).receiveException(th);
                } else {
                    th.printStackTrace(System.out);
                }
            }
            th.printStackTrace(System.out);
        }
        this._jobPerformedTimeStamp = System.currentTimeMillis();
        this._ended = true;
    }

    public Object getResult() throws Exception {
        if (this._result != null && ReflectionUtils.isSubClassOf(this._result.getClass(), Exception.class)) {
            throw (Exception)this._result;
        }
        return this._result;
    }

    public String getJobId() {
        return this._jobId;
    }

    public void setJobId(String newJobId) {
        if (newJobId == null) {
            try {
                R01FLog.to("r01f.process").warning("No se ha suministrado un id para el trabajo...se genera uno automaticamente!");
                this._jobId = GUIDDispenserManager.createDispenser("r01ft", "workerThreadPool").getGUID();
            }
            catch (GUIDDispenserException guidDispEx) {
                throw new IllegalStateException("No se ha podido generar automaticamente un id para el trabajo: " + guidDispEx.getMessage());
            }
        } else {
            this._jobId = newJobId;
        }
    }

    public Object getJobPerformerObject() {
        return this._jobPerformerObj;
    }

    public void setJobPerformerObject(Object jobPerformerObj) {
        this._jobPerformerObj = jobPerformerObj;
    }

    public Method getJobPerformerMethod() {
        return this._jobPerformerMethod;
    }

    public void setJobPerformerMethod(Method m) {
        this._jobPerformerMethod = m;
    }

    public Object[] getJobPerformerMethodArgsValues() {
        return this._jobPerformerMethodArgsValues;
    }

    public void setJobPerformerMethodArgsValues(Object[] argsValues) {
        this._jobPerformerMethodArgsValues = argsValues;
    }

    public Object getCallBackObject() {
        return this._callBackObj;
    }

    public void setCallBackObject(Object newObj) {
        this._callBackObj = newObj;
    }

    public Method getCallBackMethod() {
        return this._callBackMethod;
    }

    public void setCallBackMethod(Method newMethod) {
        this._callBackMethod = newMethod;
    }

    public boolean hasBeenStarted() {
        return this._started;
    }

    public boolean isEnded() {
        return this._ended;
    }

    public long getJobEnqueuedTimeStamp() {
        return this._jobEnqueuedTimeStamp;
    }

    public long getJobStartedTimeStamp() {
        return this._jobStartedTimeStamp;
    }

    public long getJobPerformedTimeStamp() {
        return this._jobPerformedTimeStamp;
    }
}

