/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.process;

import com.ejie.r01f.log.R01FLog;
import java.util.LinkedList;

public abstract class AbstractExecQueue {
    int _limiteSup = 30;
    int _limiteInf = 5;
    private ExecThread _execTh = new ExecThread();
    LinkedList _queue;

    public AbstractExecQueue() {
        this._execTh.start();
        this._queue = new LinkedList();
    }

    public AbstractExecQueue(int limInf, int limSup) {
        this();
        this.setLimits(limInf, limSup);
    }

    public void setLimits(int newLowerLimit, int newUpperLimit) {
        if (newLowerLimit < 0 || newUpperLimit <= 0 || newLowerLimit >= newUpperLimit) {
            throw new IllegalArgumentException("ExecQueue:setLimits(): Error al establecer los l\u00edmites de la cola");
        }
        this._limiteInf = newLowerLimit;
        this._limiteSup = newUpperLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object obj) {
        boolean haveToProcess = false;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.addLast(obj);
            if (this._queue.size() >= this._limiteSup) {
                R01FLog.getLogger("r01f.process").info("<<Cola>> - Ya se ha alcanzado el limite superior: " + this._limiteSup + "... comienza el curro");
                ExecThread execThread = this._execTh;
                synchronized (execThread) {
                    if (this._execTh.idle) {
                        this._execTh.notify();
                    }
                }
            } else {
                R01FLog.getLogger("r01f.process").info("<<Cola>> - Aun no se ha alcanzado el limite superior: " + this._limiteSup + ", la longitud acutal de la cola es " + this._queue.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pull() {
        Object pulledObj = null;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (this._queue.size() == 0) {
                return null;
            }
            pulledObj = this._queue.removeFirst();
        }
        return pulledObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size;
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            size = this._queue.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ExecThread execThread = this._execTh;
        synchronized (execThread) {
            int tmpLimiteInf = this._limiteInf;
            this._limiteInf = 0;
            if (this._execTh.idle) {
                this._execTh.notify();
            }
            this._limiteInf = tmpLimiteInf;
        }
    }

    public abstract void service(Object var1);

    private class ExecThread
    extends Thread {
        public boolean idle = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object objToService;
                if (AbstractExecQueue.this._queue != null && AbstractExecQueue.this._queue.size() != 0 && AbstractExecQueue.this._queue.size() > AbstractExecQueue.this._limiteInf) {
                    objToService = AbstractExecQueue.this.pull();
                    if (objToService != null) {
                        AbstractExecQueue.this.service(objToService);
                        continue;
                    }
                    R01FLog.getLogger("r01f.process").warning("<<Cola>> - No hay objeto que servir -");
                    continue;
                }
                R01FLog.getLogger("r01f.process").info("<<Cola>> - Se acabo el trabajo por ahora....");
                try {
                    R01FLog.getLogger("r01f.process").info("<<Cola>> - No hay trabajo: A dormir....");
                    objToService = this;
                    synchronized (objToService) {
                        this.idle = true;
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ExecThread execThread = this;
                synchronized (execThread) {
                    this.idle = false;
                }
            }
        }
    }
}

