/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.objects.tree;

import com.ejie.r01f.objects.tree.TreeNode;
import com.ejie.r01f.objects.tree.TreeNodeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TreeNodeImpl
implements TreeNode,
TreeNodeList,
Serializable {
    private static final long serialVersionUID = 4190914819403505885L;
    private List _childNodes;
    protected TreeNode _parentNode;
    private Object _data;
    protected int _level = 0;

    public TreeNodeImpl() {
    }

    public TreeNodeImpl(Object obj) {
        this._data = obj;
    }

    public TreeNodeImpl(Object obj, int nivelRaiz) {
        this._data = obj;
        this._level = nivelRaiz;
    }

    @Override
    public TreeNode appendChild(TreeNode node) {
        if (this._childNodes == null) {
            this._childNodes = new ArrayList();
        }
        TreeNode nodeToAdd = node;
        nodeToAdd.setParentNode(this);
        nodeToAdd.setNodeLevel(this._level + 1);
        this._childNodes.add(nodeToAdd);
        return node;
    }

    @Override
    public TreeNode appendChild(TreeNode node, int newLevel) {
        if (this._childNodes == null) {
            this._childNodes = new ArrayList();
        }
        TreeNode nodeToAdd = node;
        nodeToAdd.setParentNode(this);
        nodeToAdd.setNodeLevel(newLevel);
        this._childNodes.add(nodeToAdd);
        return node;
    }

    @Override
    public TreeNodeList getChildNodes() {
        return this._childNodes == null ? null : this;
    }

    @Override
    public void setChildNodes(List childNodes) {
        this._childNodes = childNodes;
    }

    @Override
    public TreeNode getFirstChild() {
        return this._childNodes == null ? null : (TreeNode)this._childNodes.get(0);
    }

    @Override
    public TreeNode getLastChild() {
        return this._childNodes == null ? null : (TreeNode)this._childNodes.get(this._childNodes.size() - 1);
    }

    @Override
    public Iterator getChildIterator() {
        return this._childNodes == null ? null : this._childNodes.iterator();
    }

    @Override
    public TreeNode getParentNode() {
        return this._parentNode == null ? null : this._parentNode;
    }

    @Override
    public void setParentNode(TreeNode parentNode) {
        this._parentNode = parentNode;
    }

    @Override
    public int getLength() {
        return this._childNodes == null ? 0 : this._childNodes.size();
    }

    @Override
    public int getNodeLevel() {
        return this._level;
    }

    @Override
    public void setNodeLevel(int level) {
        this._level = level;
    }

    @Override
    public Object getData() {
        return this._data;
    }

    @Override
    public void setData(Object data) {
        this._data = data;
    }

    @Override
    public boolean hasChildNodes() {
        return this._childNodes == null ? false : !this._childNodes.isEmpty();
    }

    @Override
    public TreeNode item(int nodeNum) {
        return this._childNodes == null ? null : (TreeNode)this._childNodes.get(nodeNum);
    }

    @Override
    public TreeNode removeChild(TreeNode node) {
        return this._childNodes == null ? null : (this._childNodes.remove(node) ? node : null);
    }

    @Override
    public String toString() {
        return this.getData().toString();
    }
}

