/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net.ssl;

import com.ejie.r01f.log.R01FLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.LinkedList;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsClient;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsCredentials;

public class TLSClientExtension
extends DefaultTlsClient {
    private java.security.cert.Certificate[] peertCerts;
    private String host;

    public TLSClientExtension(String host) {
        this.host = host;
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        return true;
    }

    public Hashtable<Integer, byte[]> getClientExtensions() throws IOException {
        Hashtable<Integer, byte[]> clientExtensions = super.getClientExtensions();
        if (clientExtensions == null) {
            clientExtensions = new Hashtable<Integer, byte[]>();
        }
        byte[] host_name = this.host.getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(host_name.length + 3);
        dos.writeByte(0);
        dos.writeShort(host_name.length);
        dos.write(host_name);
        dos.close();
        clientExtensions.put(0, baos.toByteArray());
        return clientExtensions;
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public void notifyServerCertificate(org.bouncycastle.crypto.tls.Certificate serverCertificate) throws IOException {
                try {
                    KeyStore ks = this._loadKeyStore();
                    R01FLog.to("r01f.util").info(">>>>>>>> KeyStore : " + ks.size());
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    LinkedList<java.security.cert.Certificate> certs = new LinkedList<java.security.cert.Certificate>();
                    boolean trustedCertificate = false;
                    for (Certificate c : serverCertificate.getCertificateList()) {
                        java.security.cert.Certificate cert = cf.generateCertificate(new ByteArrayInputStream(c.getEncoded()));
                        certs.add(cert);
                        String alias = ks.getCertificateAlias(cert);
                        if (alias != null) {
                            R01FLog.to("r01f.util").info(">>> Trusted cert\n" + c.getSubject().toString());
                            if (!(cert instanceof X509Certificate)) continue;
                            try {
                                ((X509Certificate)cert).checkValidity();
                                trustedCertificate = true;
                                R01FLog.to("r01f.util").info("Certificate is active for current date\n" + cert);
                            }
                            catch (CertificateExpiredException cee) {
                                R01FLog.to("r01f.util").info("Certificate is expired...");
                            }
                            continue;
                        }
                        R01FLog.to("r01f.util").info(">>> Unknown cert " + c.getSubject().toString());
                        R01FLog.to("r01f.util").fine("" + cert);
                    }
                    if (!trustedCertificate) {
                        throw new CertificateException("Unknown cert " + serverCertificate);
                    }
                    TLSClientExtension.access$002(TLSClientExtension.this, certs.toArray(new java.security.cert.Certificate[0]));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IOException(ex);
                }
            }

            public TlsCredentials getClientCredentials(CertificateRequest arg0) throws IOException {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private KeyStore _loadKeyStore() throws Exception {
                FileInputStream trustStoreFis = null;
                try {
                    String trustStoreProvider;
                    String sysTrustStore = null;
                    File trustStoreFile = null;
                    KeyStore localKeyStore = null;
                    sysTrustStore = System.getProperty("javax.net.ssl.trustStore");
                    if (!"NONE".equals(sysTrustStore)) {
                        if (sysTrustStore != null) {
                            trustStoreFile = new File(sysTrustStore);
                            trustStoreFis = this._getFileInputStream(trustStoreFile);
                        } else {
                            String javaHome = System.getProperty("java.home");
                            trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts");
                            trustStoreFis = this._getFileInputStream(trustStoreFile);
                            if (trustStoreFis == null) {
                                trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
                                trustStoreFis = this._getFileInputStream(trustStoreFile);
                            }
                        }
                        sysTrustStore = trustStoreFis != null ? trustStoreFile.getPath() : "No File Available, using empty keystore.";
                    }
                    String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType") != null ? System.getProperty("javax.net.ssl.trustStoreType") : KeyStore.getDefaultType();
                    String string = trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider") != null ? System.getProperty("javax.net.ssl.trustStoreProvider") : "";
                    if (trustStoreType.length() != 0) {
                        String str5;
                        localKeyStore = trustStoreProvider.length() == 0 ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
                        char[] keyStorePass = null;
                        String string2 = str5 = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword") : "";
                        if (str5.length() != 0) {
                            keyStorePass = str5.toCharArray();
                        }
                        localKeyStore.load(trustStoreFis, keyStorePass);
                        if (keyStorePass != null) {
                            for (int i = 0; i < keyStorePass.length; ++i) {
                                keyStorePass[i] = '\u0000';
                            }
                        }
                    }
                    KeyStore keyStore = localKeyStore;
                    return keyStore;
                }
                finally {
                    if (trustStoreFis != null) {
                        trustStoreFis.close();
                    }
                }
            }

            private FileInputStream _getFileInputStream(File paramFile) throws Exception {
                if (paramFile.exists()) {
                    return new FileInputStream(paramFile);
                }
                return null;
            }
        };
    }

    public java.security.cert.Certificate[] getPeertCerts() {
        return this.peertCerts;
    }

    static /* synthetic */ java.security.cert.Certificate[] access$002(TLSClientExtension x0, java.security.cert.Certificate[] x1) {
        x0.peertCerts = x1;
        return x1;
    }
}

