/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net.proxy;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.HttpRequest;
import com.ejie.r01f.net.HttpsRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class SimpleProxyServerv2 {
    public static void main(String[] argv) throws IOException {
        try {
            int localport = 115;
            R01FLog.to("r01f.test").info("Starting EJIE.PROXY.WEB_SERVER on port " + localport);
            SimpleProxyServerv2.runServer(localport);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runServer(int localport) throws IOException {
        ServerSocket ss = new ServerSocket(localport);
        byte[] request = new byte[1024];
        byte[] reply = new byte[4096];
        while (true) {
            Socket client = null;
            Socket server = null;
            try {
                client = ss.accept();
                InputStream streamFromClient = client.getInputStream();
                OutputStream streamToClient = client.getOutputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(streamFromClient));
                Object inputLine = null;
                R01FLog.to("r01f.test").info(in.readLine());
                R01FLog.to("r01f.test").info(in.readLine());
                R01FLog.to("r01f.test").info(in.readLine());
                String serverResponseString = "HTTP/1.1 200 Connection established\n\n";
                R01FLog.to("r01f.test").info("-----------------");
                ByteArrayInputStream serverResponse = new ByteArrayInputStream(serverResponseString.getBytes());
                int bytesRead = 0;
                try {
                    while ((bytesRead = serverResponse.read(reply)) != -1) {
                        streamToClient.write(reply, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                serverResponse.close();
                streamToClient.close();
                R01FLog.to("r01f.test").info("OK!");
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (server != null) {
                        server.close();
                    }
                    if (client == null) continue;
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    public static String _divide(String data, String token) {
        return data.substring(token.length(), data.length());
    }

    public static String getURI(String getData) {
        StringTokenizer st = new StringTokenizer(getData);
        String methodHeader = st.nextToken(" ");
        String uriHeader = st.nextToken(" ");
        String protocolHeader = st.nextToken(" ");
        return uriHeader;
    }

    public static String _getHTTP_ConProxy(String uri) throws IOException {
        HttpRequest req = new HttpRequest(uri, "intercon.ejgvdns", "8080");
        req.setProxyAuthorization("ie00191m", "iker1");
        req.setTimeout(200000L);
        InputStream is = req.sendUsingGet();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String inputLine = null;
        String serverResponse = null;
        while ((inputLine = in.readLine()) != null) {
            R01FLog.to("r01f.test").info(inputLine);
            serverResponse = serverResponse + inputLine;
        }
        in.close();
        return serverResponse;
    }

    public static void _probarHTTPS_ConProxy() throws IOException {
        System.setProperty("javax.net.debug", "all");
        HttpsRequest req = new HttpsRequest("https://www.testpago.euskadi.eus/p12jWar/p12jRPCDispatcherServlet/", "intercon.ejgvdns", "8080");
        req.setTimeout(20000L);
        InputStream is = req.sendUsingGet();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String inputLine = null;
        while ((inputLine = in.readLine()) != null) {
            R01FLog.to("r01f.test").info(inputLine);
        }
        in.close();
        R01FLog.to("r01f.test").info("Fin");
    }
}

