/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net.jsse.handler;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;
import sun.security.util.HostnameChecker;

final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static final int defaultPort = 443;
    private HostnameVerifier hostNameVerifier;
    private SSLSocketFactory sslSocketFactory;
    private String proxyHostUsed;
    private int proxyPortUsed;
    private SSLSession sslSession;

    static HttpClient getHTTPSClient(SSLSocketFactory sslSocketFactory, URL url, HostnameVerifier hostNameVerifier) throws IOException {
        return HttpsClient.getHTTPSClient(sslSocketFactory, url, hostNameVerifier, true);
    }

    static HttpClient getHTTPSClient(SSLSocketFactory sslSocketFactory, URL url, HostnameVerifier hostNameVerifier, boolean useCache) throws IOException {
        return HttpsClient.getHTTPSClient(sslSocketFactory, url, hostNameVerifier, null, -1, useCache);
    }

    static HttpClient getHTTPSClient(SSLSocketFactory sslSocketFactory, URL url, HostnameVerifier hostNameVerifier, String proxyHost, int proxyPort) throws IOException {
        return HttpsClient.getHTTPSClient(sslSocketFactory, url, hostNameVerifier, proxyHost, proxyPort, true);
    }

    static HttpClient getHTTPSClient(SSLSocketFactory sslSocketFactory, URL url, HostnameVerifier hostNameVerifier, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        HttpsClient httpsClient = null;
        if (useCache && (httpsClient = (HttpsClient)HttpClient.kac.get(url, sslSocketFactory)) != null) {
            httpsClient.cachedHttpClient = true;
        }
        if (httpsClient == null) {
            httpsClient = new HttpsClient(sslSocketFactory, url, proxyHost, proxyPort);
        } else {
            SecurityManager securitymanager = System.getSecurityManager();
            if (securitymanager != null) {
                securitymanager.checkConnect(url.getHost(), url.getPort());
            }
            httpsClient.url = url;
        }
        httpsClient.setHostNameVerifier(hostNameVerifier);
        return httpsClient;
    }

    private HttpsClient(SSLSocketFactory sslsocketfactory, URL url) throws IOException {
        this(sslsocketfactory, url, null, -1);
    }

    public HttpsClient(SSLSocketFactory sslsocketfactory, URL url, String proxyHost, int proxyPort) throws IOException {
        this.setSSLSocketFactory(sslsocketfactory);
        if (proxyHost != null) {
            this.setProxy(proxyHost, proxyPort);
        }
        this.proxyDisabled = true;
        try {
            InetAddress inetaddress = InetAddress.getByName(url.getHost());
            this.host = inetaddress.getHostAddress();
        }
        catch (UnknownHostException unknownhostexception) {
            this.host = url.getHost();
        }
        this.url = url;
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    static int getDefaultConnectTimeout() {
        return NetworkClient.defaultConnectTimeout;
    }

    @Override
    protected int getDefaultPort() {
        return 443;
    }

    @Override
    public int getProxyPortUsed() {
        return this.proxyPortUsed;
    }

    @Override
    public void afterConnect() throws IOException, UnknownHostException {
        if (!this.isCachedConnection()) {
            SSLSocket sslsocket = null;
            SSLSocketFactory sslsocketfactory = this.sslSocketFactory;
            try {
                sslsocket = !(this.serverSocket instanceof SSLSocket) ? (SSLSocket)sslsocketfactory.createSocket(this.serverSocket, this.host, this.port, true) : (SSLSocket)this.serverSocket;
            }
            catch (IOException ioexception) {
                try {
                    sslsocket = (SSLSocket)sslsocketfactory.createSocket(this.host, this.port);
                }
                catch (IOException ioexception1) {
                    throw ioexception;
                }
            }
            String[] protocols = this.getProtocols();
            String[] ciphers = this.getCipherSuites();
            if (protocols != null) {
                sslsocket.setEnabledProtocols(protocols);
            }
            if (ciphers != null) {
                sslsocket.setEnabledCipherSuites(ciphers);
            }
            sslsocket.addHandshakeCompletedListener(this);
            sslsocket.startHandshake();
            this.sslSession = sslsocket.getSession();
            this.serverSocket = sslsocket;
            try {
                this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, NetworkClient.encoding);
            }
            catch (UnsupportedEncodingException unsupportedencodingexception) {
                throw new InternalError(NetworkClient.encoding + " encoding not found");
            }
            this.checkURLSpoofing(this.hostNameVerifier);
        } else {
            this.sslSession = ((SSLSocket)this.serverSocket).getSession();
        }
    }

    @Override
    protected void putInKeepAliveCache() {
        HttpClient.kac.put(this.url, this.sslSocketFactory, this);
    }

    private boolean isNonProxyHost() {
        RegexpPool nonProxyHosts = this.getNonProxyHosts();
        if (nonProxyHosts.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress inetaddress = InetAddress.getByName(this.url.getHost());
            String s = inetaddress.getHostAddress();
            if (nonProxyHosts.match(s) != null) {
                return true;
            }
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean needsTunneling() {
        return this.proxyHostUsed != null && !this.isNonProxyHost();
    }

    String b() {
        return this.sslSession.getCipherSuite();
    }

    private String getProxyHost() {
        String proxyHost = AccessController.doPrivileged(new GetPropertyAction("https.proxyHost"));
        if (proxyHost != null && proxyHost.length() == 0) {
            proxyHost = null;
        }
        return proxyHost;
    }

    @Override
    public String getProxyHostUsed() {
        if (!this.needsTunneling()) {
            return null;
        }
        return this.proxyHostUsed;
    }

    private String getUserAgent() {
        String userAgent = AccessController.doPrivileged(new GetPropertyAction("https.agent"));
        if (userAgent == null || userAgent.length() == 0) {
            userAgent = "JSSE";
        }
        return userAgent;
    }

    private String[] getCipherSuites() {
        String[] ciphers;
        String cipherString = AccessController.doPrivileged(new GetPropertyAction("https.cipherSuites"));
        if (cipherString == null || "".equals(cipherString)) {
            ciphers = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringtokenizer = new StringTokenizer(cipherString, ",");
            while (stringtokenizer.hasMoreElements()) {
                vector.addElement(stringtokenizer.nextElement());
            }
            ciphers = new String[vector.size()];
            for (int i = 0; i < ciphers.length; ++i) {
                ciphers[i] = (String)vector.elementAt(i);
            }
        }
        return ciphers;
    }

    private String[] getProtocols() {
        String[] protocols;
        String protocolString = AccessController.doPrivileged(new GetPropertyAction("https.protocols"));
        if (protocolString == null || "".equals(protocolString)) {
            protocols = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringtokenizer = new StringTokenizer(protocolString, ",");
            while (stringtokenizer.hasMoreElements()) {
                vector.addElement(stringtokenizer.nextElement());
            }
            protocols = new String[vector.size()];
            for (int i = 0; i < protocols.length; ++i) {
                protocols[i] = (String)vector.elementAt(i);
            }
        }
        return protocols;
    }

    void setProxy(String proxyHost, int proxyPort) {
        this.proxyHostUsed = proxyHost;
        this.proxyPortUsed = proxyPort >= 0 ? proxyPort : this.getDefaultPort();
    }

    Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.sslSession.getPeerCertificates();
    }

    public Certificate[] getLocalCertificates() {
        return this.sslSession.getLocalCertificates();
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent handshakecompletedevent) {
        this.sslSession = handshakecompletedevent.getSession();
    }

    void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
    }

    private void checkURLSpoofing(HostnameVerifier hostnameVerifier) throws IOException {
        String host = this.url.getHost();
        if (host != null && host.startsWith("[") && host.endsWith("]")) {
            host = host.substring(1, host.length() - 1);
        }
        try {
            Certificate[] peerCerts = this.sslSession.getPeerCertificates();
            if (!(peerCerts[0] instanceof java.security.cert.X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            java.security.cert.X509Certificate peerCert = (java.security.cert.X509Certificate)peerCerts[0];
            HostnameChecker checker = HostnameChecker.getInstance((byte)1);
            checker.match(host, peerCert);
            return;
        }
        catch (SSLPeerUnverifiedException sslpeerunverifiedexception) {
        }
        catch (CertificateException certificateexception) {
            // empty catch block
        }
        String cipher = this.sslSession.getCipherSuite();
        if (cipher != null && cipher.indexOf("_anon_") != -1) {
            return;
        }
        if (hostnameVerifier != null && hostnameVerifier.verify(host, this.sslSession)) {
            return;
        }
        this.serverSocket.close();
        this.sslSession.invalidate();
        throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">");
    }

    SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return this.sslSession.getPeerCertificateChain();
    }

    private RegexpPool getNonProxyHosts() {
        RegexpPool regexppool = new RegexpPool();
        String nonProxyHosts = AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
        if (nonProxyHosts != null) {
            StringTokenizer stringtokenizer = new StringTokenizer(nonProxyHosts, "|", false);
            try {
                while (stringtokenizer.hasMoreTokens()) {
                    regexppool.add(stringtokenizer.nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return regexppool;
    }

    static int getProxyPortUsed(HttpsClient httpsclient) {
        return httpsclient.proxyPortUsed;
    }

    static String getProxyHostUsed(HttpsClient httpsclient) {
        return httpsclient.proxyHostUsed;
    }

    @Override
    protected Socket doConnect(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(host, port);
        return socket;
    }
}

