/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net.jsse.handler;

import com.ejie.r01f.net.jsse.handler.HttpsClient;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpURLConnection;

public abstract class AbstractDelegateHttpsURLConnection
extends HttpURLConnection {
    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.plainConnect();
        if (!this.http.isCachedConnection() && this.http.needsTunneling()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    @Override
    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = (HttpsClient)HttpsClient.getHTTPSClient(this.getSSLSocketFactory(), this.url, this.getHostnameVerifier());
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean flag) {
        this.connected = flag;
    }

    public String getCipherSuite() {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).b();
    }

    @Override
    public void setNewClient(URL url) throws IOException {
        this.setNewClient(url, false);
    }

    @Override
    public void setNewClient(URL url, boolean flag) throws IOException {
        this.http = HttpsClient.getHTTPSClient(this.getSSLSocketFactory(), url, this.getHostnameVerifier(), flag);
        ((HttpsClient)this.http).afterConnect();
    }

    public Certificate[] getLocalCertificates() {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getPeerCertificates();
    }

    public X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getPeerCertificateChain();
    }

    protected abstract HostnameVerifier getHostnameVerifier();

    protected abstract SSLSocketFactory getSSLSocketFactory();

    @Override
    public void setProxiedClient(URL url, String s, int i) throws IOException {
        this.setProxiedClient(url, s, i, false);
    }

    @Override
    protected void proxiedConnect(URL url, String s, int i, boolean flag) throws IOException {
        if (this.connected) {
            return;
        }
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            securitymanager.checkConnect(s, i);
        }
        this.http = HttpsClient.getHTTPSClient(this.getSSLSocketFactory(), url, this.getHostnameVerifier(), s, i, flag);
        this.connected = true;
    }

    @Override
    public void setProxiedClient(URL url, String s, int i, boolean flag) throws IOException {
        this.proxiedConnect(url, s, i, flag);
        if (!this.http.isCachedConnection()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    protected AbstractDelegateHttpsURLConnection(URL url, Handler handler) throws IOException {
        super(url, handler);
    }
}

