/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.BaseNetRequest;
import com.ejie.r01f.net.ssl.SSLTunnelSocketFactory;
import com.ejie.r01f.net.ssl.TLSSocketConnectionFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;

public class HttpsRequest
extends BaseNetRequest {
    static boolean _streamHandlerSet = false;
    static String _httpsDefaultClass = "javax.net.ssl.HttpsURLConnection";
    static String _httpsSunClass = "com.sun.net.ssl.HttpsURLConnection";
    static String _httpsIBMClass = "com.ibm.net.ssl.HttpsURLConnection";
    static String _httpsJdk15HiguerPatchClass = "com.ejie.r01f.net.jsse.handler.HttpsURLConnectionImpl";
    static String _sunURLHandler = "com.sun.net.ssl.internal.www.protocol.https.Handler";
    static String _ibmURLHandler = "com.ibm.net.ssl.internal.www.protocol.https.Handler";
    static String _jdk15HiguerPatchHandler = "com.ejie.r01f.net.jsse.handler.Handler";
    static String _jdk15HiguerIbmURLHandler = "com.ibm.net.ssl.www2.protocol.https.Handler";
    boolean _forceBCProviders = false;

    public HttpsRequest() {
    }

    public HttpsRequest(String inURLStr) throws MalformedURLException {
        super(inURLStr);
    }

    public HttpsRequest(String inURLStr, String proxyHost, String proxyPort) throws MalformedURLException {
        super(inURLStr, proxyHost, proxyPort);
    }

    public HttpsRequest(String inURLStr, boolean forceBCPproviders) throws MalformedURLException {
        super(inURLStr);
        this._forceBCProviders = forceBCPproviders;
    }

    public HttpsRequest(String inURLStr, String proxyHost, String proxyPort, boolean forceBCPproviders) throws MalformedURLException {
        super(inURLStr, proxyHost, proxyPort);
        this._forceBCProviders = forceBCPproviders;
    }

    @Override
    public void setURL(String inURLStr) throws MalformedURLException {
        URL urlWrapped;
        URLStreamHandler streamHandler;
        R01FLog.to("r01f.test").fine("Setting URL!");
        try {
            streamHandler = this.getURLStreamHandler();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MalformedURLException(e.getMessage());
        }
        this._targetURL = urlWrapped = new URL(null, inURLStr, streamHandler);
    }

    @Override
    public HttpURLConnection getConnection(URL url) throws IOException {
        URLConnection urlc = url.openConnection();
        R01FLog.to("r01f.test").info(":: HttpsRequest :: " + urlc.getClass().getName());
        if (this.proxyHost != null) {
            return this._obtainConnectionForSSLTunneling(urlc, url);
        }
        if (this._forceBCProviders) {
            R01FLog.to("r01f.test").warning("= Must enforce TLS V12 using BouncyCastle Providers");
            return this._obtainConnectionForTLS(urlc, url);
        }
        return (HttpURLConnection)urlc;
    }

    private boolean isHttpsDefaultClassInstance(Class<? extends URLConnection> classInstance) {
        try {
            Class<? extends URLConnection> httpsDefaultClass = Class.forName(_httpsDefaultClass);
            return httpsDefaultClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isSunClassInstance(Class<? extends URLConnection> classInstance) {
        try {
            Class<? extends URLConnection> httpsDefaultClass = Class.forName(_httpsSunClass);
            return httpsDefaultClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Method getSSLMethodByClassName(String className, Class[] argType) throws IOException {
        try {
            return Class.forName(className).getMethod("setSSLSocketFactory", argType);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new IOException("getSSLMethodByClassNameclassName:" + className + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new IOException("getSSLMethodByClassNameclassName:" + className + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IOException("getSSLMethodByClassNameclassName:" + className + e.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private Method getCustomSSLMethod(Class[] argType) throws IOException {
        String szVendor;
        block7: {
            szVendor = System.getProperty("java.vendor");
            if (this.proxyHost != null && this.jdkVersionHigher5) {
                return this.getSSLMethodByClassName(_httpsJdk15HiguerPatchClass, argType);
            }
            if (-1 < szVendor.indexOf("SUN")) {
                return this.getSSLMethodByClassName(_httpsSunClass, argType);
            }
            if (-1 >= szVendor.indexOf("IBM")) break block7;
            return this.getSSLMethodByClassName(_httpsIBMClass, argType);
            {
                catch (IOException e) {
                    throw e;
                }
            }
        }
        try {
            return this.getSSLMethodByClassName(_httpsSunClass, argType);
        }
        catch (IOException e) {
            e.printStackTrace();
            Properties prop = System.getProperties();
            prop.list(System.err);
            IOException ioex = new IOException("JAVA VENDOR UNKNOWN!! :" + szVendor);
            throw ioex;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URLStreamHandler getURLStreamHandler() throws IOException {
        String szVendor = System.getProperty("java.vendor");
        try {
            if (this.proxyHost != null && this.jdkVersionHigher5) {
                if (-1 < szVendor.indexOf("IBM")) {
                    return (URLStreamHandler)Class.forName(_jdk15HiguerIbmURLHandler).newInstance();
                }
                return (URLStreamHandler)Class.forName(_jdk15HiguerPatchHandler).newInstance();
            }
            if (-1 < szVendor.indexOf("Sun")) {
                return (URLStreamHandler)Class.forName(_sunURLHandler).newInstance();
            }
            if (-1 < szVendor.indexOf("IBM")) {
                if (this.jdkVersionHigher5) {
                    return (URLStreamHandler)Class.forName(_jdk15HiguerIbmURLHandler).newInstance();
                }
                return (URLStreamHandler)Class.forName(_ibmURLHandler).newInstance();
            }
            {
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage());
                }
                try {
                    return (URLStreamHandler)Class.forName(_sunURLHandler).newInstance();
                }
                catch (ClassNotFoundException e) {}
                {
                    e.printStackTrace();
                    Properties prop = System.getProperties();
                    prop.list(System.err);
                    IOException ioex = new IOException("JAVA VENDOR UNKNOWN!! :" + szVendor);
                    throw ioex;
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void forceBCProviders() {
        this._forceBCProviders = true;
    }

    private HttpURLConnection _obtainConnectionForSSLTunneling(URLConnection urlc, URL url) throws IOException {
        Class[] argType = new Class[]{SSLSocketFactory.class};
        SSLTunnelSocketFactory sslTunnelSocketFactory = this._forceBCProviders ? new SSLTunnelSocketFactory(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPW, new TLSSocketConnectionFactory()) : new SSLTunnelSocketFactory(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPW);
        if (this.proxyKeepConectionAlive) {
            sslTunnelSocketFactory.setProxyConnectionKeepAlive(this.proxyKeepConectionAlive);
        }
        Object[] argValue = new Object[]{sslTunnelSocketFactory};
        if (this.jdkVersionHigher5) {
            URLStreamHandler streamHandler = this.getURLStreamHandler();
            URL urlWrapped = new URL(url, url.toExternalForm(), streamHandler);
            URLConnection urlConnWrapped = urlWrapped.openConnection();
            Method setSSLMethod = this.getCustomSSLMethod(argType);
            try {
                setSSLMethod.invoke((Object)urlConnWrapped, argValue);
            }
            catch (Exception e) {
                System.getProperties().list(System.err);
                throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
            }
            R01FLog.to("r01f.test").info(":: HttpsRequest :: " + urlConnWrapped.getClass().getName());
            return (HttpURLConnection)urlConnWrapped;
        }
        if (this.isHttpsDefaultClassInstance(urlc.getClass())) {
            Method setSSLMethod = this.getSSLMethodByClassName(_httpsDefaultClass, argType);
            try {
                setSSLMethod.invoke((Object)urlc, argValue);
            }
            catch (Exception e) {
                throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
            }
            return (HttpURLConnection)urlc;
        }
        if (this.isSunClassInstance(urlc.getClass())) {
            Method setSSLMethod = this.getSSLMethodByClassName(_httpsSunClass, argType);
            try {
                setSSLMethod.invoke((Object)urlc, argValue);
            }
            catch (Exception e) {
                System.getProperties().list(System.err);
                throw new IOException("Error al establecer SSLTunnelSocketFactory : " + _httpsSunClass + " of " + urlc.getClass().getName() + e.getMessage());
            }
            return (HttpURLConnection)urlc;
        }
        URLStreamHandler streamHandler = this.getURLStreamHandler();
        URL urlWrapped = new URL(url, url.toExternalForm(), streamHandler);
        URLConnection urlConnWrapped = urlWrapped.openConnection();
        Method setSSLMethod = this.getCustomSSLMethod(argType);
        try {
            setSSLMethod.invoke((Object)urlConnWrapped, argValue);
        }
        catch (Exception e) {
            System.getProperties().list(System.err);
            throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
        }
        R01FLog.to("r01f.test").info(":: HttpsRequest :: " + urlConnWrapped.getClass().getName());
        return (HttpURLConnection)urlConnWrapped;
    }

    private HttpURLConnection _obtainConnectionForTLS(URLConnection urlc, URL url) throws IOException {
        if (this.jdkVersionHigher5) {
            URLStreamHandler streamHandler = this.getURLStreamHandler();
            URL urlWrapped = new URL(url, url.toExternalForm(), streamHandler);
            URLConnection urlConnWrapped = urlWrapped.openConnection();
            Class[] argType = new Class[]{SSLSocketFactory.class};
            Object[] argValue = new Object[]{new TLSSocketConnectionFactory()};
            Method setSSLMethod = this.getCustomSSLMethod(argType);
            try {
                setSSLMethod.invoke((Object)urlConnWrapped, argValue);
            }
            catch (Exception e) {
                System.getProperties().list(System.err);
                throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
            }
            R01FLog.to("r01f.test").info(":: HttpsRequest :: " + urlConnWrapped.getClass().getName());
            return (HttpURLConnection)urlConnWrapped;
        }
        if (this.isHttpsDefaultClassInstance(urlc.getClass())) {
            Class[] argType = new Class[]{SSLSocketFactory.class};
            Object[] argValue = new Object[]{new TLSSocketConnectionFactory()};
            Method setSSLMethod = this.getSSLMethodByClassName(_httpsDefaultClass, argType);
            try {
                setSSLMethod.invoke((Object)urlc, argValue);
            }
            catch (Exception e) {
                throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
            }
            return (HttpURLConnection)urlc;
        }
        if (this.isSunClassInstance(urlc.getClass())) {
            Class[] argType = new Class[]{SSLSocketFactory.class};
            Object[] argValue = new Object[]{new TLSSocketConnectionFactory()};
            Method setSSLMethod = this.getSSLMethodByClassName(_httpsSunClass, argType);
            try {
                setSSLMethod.invoke((Object)urlc, argValue);
            }
            catch (Exception e) {
                System.getProperties().list(System.err);
                throw new IOException("Error al establecer SSLTunnelSocketFactory : " + _httpsSunClass + " of " + urlc.getClass().getName() + e.getMessage());
            }
            return (HttpURLConnection)urlc;
        }
        URLStreamHandler streamHandler = this.getURLStreamHandler();
        URL urlWrapped = new URL(url, url.toExternalForm(), streamHandler);
        URLConnection urlConnWrapped = urlWrapped.openConnection();
        Class[] argType = new Class[]{SSLSocketFactory.class};
        Object[] argValue = new Object[]{new TLSSocketConnectionFactory()};
        Method setSSLMethod = this.getCustomSSLMethod(argType);
        try {
            setSSLMethod.invoke((Object)urlConnWrapped, argValue);
        }
        catch (Exception e) {
            System.getProperties().list(System.err);
            throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
        }
        R01FLog.to("r01f.test").info(":: HttpsRequest :: " + urlConnWrapped.getClass().getName());
        return (HttpURLConnection)urlConnWrapped;
    }
}

