/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net;

import com.ejie.r01f.net.BaseNetRequest;
import com.ejie.r01f.net.HttpRequest;
import com.ejie.r01f.net.HttpsRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;

public class HttpClient {
    private static final int NETPROTOCOL_HTTP = 0;
    private static final int NETPROTOCOL_HTTPS = 1;
    private int _netProtocol = 0;
    private String _targetURL;
    private Map _parameters;
    private long _timeout = -1L;
    private String _proxyHost = null;
    private String _proxyPort = null;
    private String _usrProxy = null;
    private String _pwdProxy = null;
    private String _contentType = null;
    private boolean _forceBCProviders = false;
    public static String MULTIPART_FORM_DATA_FILES_CONTENT_TYPE = "multipart/form-data;boundary=*****";

    public HttpClient(String inTargetURL) {
        this._targetURL = inTargetURL.trim();
        if (!this._targetURL.startsWith("http://") && !this._targetURL.startsWith("https://")) {
            this._targetURL = "http://" + this._targetURL;
        }
        if (this._targetURL.startsWith("http://")) {
            this._netProtocol = 0;
        } else if (this._targetURL.startsWith("https://")) {
            this._netProtocol = 1;
        }
    }

    public HttpClient(String inNetProtocol, String inTargetURL) throws MalformedURLException {
        if (inNetProtocol.equalsIgnoreCase("http")) {
            this._netProtocol = 0;
        } else if (inNetProtocol.equalsIgnoreCase("https")) {
            this._netProtocol = 1;
        } else {
            throw new MalformedURLException("Solo se permiten los protocolos 'http' o 'https'");
        }
        this._targetURL = inTargetURL.trim();
        if (!this._targetURL.startsWith("http://") && !this._targetURL.startsWith("https://")) {
            if (this._netProtocol == 0) {
                this._targetURL = "http://" + this._targetURL;
            } else if (this._netProtocol == 1) {
                this._targetURL = "https://" + this._targetURL;
            }
        }
        if (this._targetURL.startsWith("http://") && this._netProtocol == 1 || this._targetURL.startsWith("https://") && this._netProtocol == 0) {
            throw new MalformedURLException("El protocolo indicado en la llamada al constructro no coincide con el indicado en la url '" + this._targetURL + "'");
        }
    }

    public HttpClient(String inNetProtocol, String inTargetURL, Map inParameters) throws MalformedURLException {
        this(inNetProtocol, inTargetURL);
        this._parameters = inParameters;
    }

    public HttpClient(String inTargetURL, Map inParameters) {
        this(inTargetURL);
        this._parameters = inParameters;
    }

    public void setConnectionTimeout(long timeout) {
        this._timeout = timeout;
    }

    public long getConnectionTimeout() {
        return this._timeout;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public InputStream sendHttpCall() throws IOException {
        return this._doHttpCall(0);
    }

    public InputStream sendGetHttpCall() throws IOException {
        return this._doHttpCall(1);
    }

    public InputStream sendPostHttpCall() throws IOException {
        return this._doHttpCall(0);
    }

    public InputStream sendPutHttpCall() throws IOException {
        return this._doHttpCall(2);
    }

    public void setProxyHost(String proxy, String port) {
        this._proxyHost = proxy;
        this._proxyPort = port;
    }

    public void setProxyAuthorization(String user, String password) {
        this._usrProxy = user;
        this._pwdProxy = password;
    }

    public void forceBCProviders(boolean _forceBCProviders) {
        this._forceBCProviders = _forceBCProviders;
    }

    private InputStream _doHttpCall(int sendMode) throws IOException {
        BaseNetRequest netRequest = null;
        if (this._netProtocol == 0) {
            netRequest = this._proxyHost != null && this._proxyPort != null ? new HttpRequest(this._targetURL, this._proxyHost, this._proxyPort) : new HttpRequest(this._targetURL);
        } else if (this._netProtocol == 1) {
            netRequest = this._proxyHost != null && this._proxyPort != null ? (this._forceBCProviders ? new HttpsRequest(this._targetURL, this._proxyHost, this._proxyPort, this._forceBCProviders) : new HttpsRequest(this._targetURL, this._proxyHost, this._proxyPort)) : (this._forceBCProviders ? new HttpsRequest(this._targetURL, this._forceBCProviders) : new HttpsRequest(this._targetURL));
        }
        if (netRequest != null) {
            netRequest.setTimeout(this._timeout);
            if (this._contentType != null) {
                netRequest.setContenType(this._contentType);
            }
            if (this._parameters != null) {
                for (Map.Entry me : this._parameters.entrySet()) {
                    netRequest.putParameter((String)me.getKey(), me.getValue());
                }
            }
            if (this._usrProxy != null && this._pwdProxy != null) {
                netRequest.setProxyAuthorization(this._usrProxy, this._pwdProxy);
            }
            if (sendMode == 1) {
                return netRequest.sendUsingGet();
            }
            if (sendMode == 0) {
                return netRequest.sendUsingPost();
            }
            if (sendMode == 2) {
                return netRequest.sendUsingPut();
            }
        }
        return null;
    }
}

