/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.process.TimeoutController;
import com.ejie.r01f.util.URLEncoder;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.misc.BASE64Encoder;

public abstract class BaseNetRequest {
    protected URL _targetURL = null;
    private Map _headers = null;
    private Map _parameters = null;
    private int _sendMode = 0;
    private long _timeout = -1L;
    private String jdkVersion = null;
    protected boolean jdkVersionHigher5 = false;
    public static final int HTTPCALL_POST = 0;
    public static final int HTTPCALL_GET = 1;
    public static final int HTTPCALL_PUT = 2;
    public static final String PROTOCOL = "http";
    protected boolean proxyKeepConectionAlive = false;
    protected String proxyHost = null;
    protected String proxyPort = null;
    protected String proxyUser = null;
    protected String proxyPW = null;
    protected String _contentType = null;
    public static String MULTIPART_FORM_DATA_FILES_CONTENT_TYPE = "multipart/form-data;boundary=*****";
    private static String _REQUEST_METHOD_PUT = "PUT";

    protected BaseNetRequest() {
        this._obtainVersionInfo();
    }

    public BaseNetRequest(String inURLStr) throws MalformedURLException {
        this._obtainVersionInfo();
        this.setURL(inURLStr);
    }

    public BaseNetRequest(String inURLStr, String theProxyHost, String theProxyPort) throws MalformedURLException {
        this._obtainVersionInfo();
        this.proxyHost = theProxyHost;
        this.proxyPort = theProxyPort;
        this.setURL(inURLStr);
    }

    public BaseNetRequest(URL inTargetURL) {
        this._obtainVersionInfo();
        this._targetURL = inTargetURL;
    }

    public void setURL(String inURLStr) throws MalformedURLException {
        URL url;
        this._targetURL = url = new URL(inURLStr);
    }

    public int setSendMode(int modeType) {
        int retValue = this._sendMode;
        this._sendMode = modeType == 1 || modeType == 0 ? modeType : 0;
        return retValue;
    }

    public int getSendMode() {
        return this._sendMode;
    }

    public void setTimeout(long newTimeout) {
        this._timeout = newTimeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setContenType(String contentType) {
        this._contentType = contentType;
    }

    public InputStream send() throws IOException {
        return this._doRequest(this._sendMode);
    }

    public InputStream sendUsingGet() throws IOException {
        return this._doRequest(1);
    }

    public InputStream sendUsingPost() throws IOException {
        return this._doRequest(0);
    }

    public InputStream sendUsingPut() throws IOException {
        return this._doRequest(2);
    }

    public String putParameter(String name, Object value) {
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        return (String)this._parameters.put(name, value);
    }

    public void setCookie(String name, String value) {
        String existingCookies;
        if (this._headers == null) {
            this._headers = new HashMap();
        }
        if ((existingCookies = (String)this._headers.get("Cookie")) == null) {
            this.setHeader("Cookie", name + "=" + value);
        } else {
            this.setHeader("Cookie", existingCookies + "; " + name + "=" + value);
        }
    }

    public void setURIAuthorization(String name, String password) {
        BASE64Encoder encoder = new BASE64Encoder();
        String authString = name + ":" + password;
        String authStringEncoded = encoder.encode(authString.getBytes());
        this.setHeader("Authorization", "Basic " + authStringEncoded);
    }

    public void setProxyAuthorization(String name, String password) {
        if (name != null && password != null) {
            this.proxyUser = name;
            this.proxyPW = password;
            BASE64Encoder encoder = new BASE64Encoder();
            String authString = name + ":" + password;
            String authStringEncoded = encoder.encode(authString.getBytes());
            this.setHeader("Proxy-Authorization", "Basic " + authStringEncoded);
        }
    }

    public void keepProxyConnectionAlive(boolean keepProxyConnectionAlive) {
        this.proxyKeepConectionAlive = keepProxyConnectionAlive;
    }

    public abstract HttpURLConnection getConnection(URL var1) throws IOException;

    private InputStream _doRequest(int sendMode) throws IOException {
        if (sendMode == 1) {
            URL url = null;
            String completeURL = null;
            if (this._getParameterString() == null || this._getParameterString().equalsIgnoreCase("")) {
                completeURL = this._targetURL.toExternalForm();
            } else {
                completeURL = this._targetURL.toExternalForm();
                completeURL = completeURL.indexOf("?") < 0 ? completeURL + "?" : completeURL + "&";
                completeURL = completeURL + this._getParameterString();
                R01FLog.to("r01f.util").fine("completeURL: " + completeURL);
            }
            R01FLog.to("r01f.util").fine("Proxy Logic _doRequest");
            url = this.proxyHost == null ? this._targetURL : (completeURL.startsWith("https") ? this._targetURL : new URL(PROTOCOL, this.proxyHost, Integer.parseInt(this.proxyPort), completeURL));
            HttpURLConnection conx = this._getConnection(url);
            if (conx == null) {
                throw new IOException("No se ha podido obtener una conexi\u00f3n con '" + this._targetURL.toExternalForm() + "'");
            }
            conx.setDoInput(true);
            conx.setUseCaches(false);
            this._setHostHeader(this._targetURL.toExternalForm());
            this._sendHeaders(conx);
            return conx.getInputStream();
        }
        if (sendMode == 0 || sendMode == 2) {
            URL url = null;
            url = this.proxyHost == null ? new URL(this._targetURL.toExternalForm()) : (this._targetURL.toExternalForm().startsWith("https") ? new URL(this._targetURL.toExternalForm()) : new URL(PROTOCOL, this.proxyHost, Integer.parseInt(this.proxyPort), this._targetURL.toExternalForm()));
            HttpURLConnection conx = this._getConnection(url);
            if (conx == null) {
                throw new IOException("No se ha podido obtener una conexi\u00f3n con '" + this._targetURL.toExternalForm() + "'");
            }
            conx.setDoOutput(true);
            conx.setDoInput(true);
            conx.setUseCaches(true);
            if (this._contentType == null) {
                conx.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else {
                conx.setRequestProperty("Content-Type", this._contentType);
            }
            if (sendMode == 2) {
                conx.setRequestMethod(_REQUEST_METHOD_PUT);
            }
            this._setHostHeader(this._targetURL.toExternalForm());
            this._sendHeaders(conx);
            OutputStream oop = conx.getOutputStream();
            R01FLog.to("r01f.util").fine("OUPUT STREAM ");
            R01FLog.to("r01f.util").fine("== isNull? " + (oop == null));
            R01FLog.to("r01f.util").fine("==============");
            DataOutputStream out = new DataOutputStream(oop);
            if (this._contentType != null && this._contentType.equalsIgnoreCase(MULTIPART_FORM_DATA_FILES_CONTENT_TYPE)) {
                this.writeToDataOutputStream(out);
            } else {
                out.writeBytes(this._getParameterString());
            }
            out.flush();
            out.close();
            return conx.getInputStream();
        }
        return null;
    }

    private void _setHostHeader(String _targetURL) throws MalformedURLException {
        if (this.proxyHost != null && !_targetURL.startsWith("https")) {
            String destinationHost = new URL(_targetURL).getHost();
            this.setHeader("host", destinationHost);
            if (this.jdkVersionHigher5) {
                String restrictedHostsActivateProperty = System.getProperty("sun.net.http.allowRestrictedHeaders");
                boolean restrictedHostsActivate = false;
                if (restrictedHostsActivateProperty != null && restrictedHostsActivateProperty.equalsIgnoreCase("true")) {
                    restrictedHostsActivate = true;
                }
                if (!restrictedHostsActivate) {
                    String msgBug = "  Bug : El siguiente Bug 7022056 registrado para versiones de Java >= 1.6.0_24 [ No ocurre en la versi\u00f3n 1.6.0_13]";
                    msgBug = msgBug + "\n No permite introducir una cabecera HOST Header: hay que activa la propiedad -Dsun.net.http.allowRestrictedHeaders=true [A nivel de VM . No System.setProperty]";
                    msgBug = msgBug + "\nEl Host Header es necesario para aquellas Hosts Destino que son Host Virtuales. Su no inclusi\u00f3n puede originar un Error 404";
                    msgBug = msgBug + "\n Link del Bug: http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=7022056";
                    R01FLog.to("r01f.util").severe("[ Conexi\u00f3n HTTP v\u00eda Proxy ] Atenci\u00f3n BUG 7022056 ]\n" + msgBug);
                }
            }
        }
    }

    private HttpURLConnection _getConnection(final URL url) throws IOException {
        HttpURLConnection conx = null;
        if (this._timeout == -1L) {
            conx = this.getConnection(url);
        } else {
            try {
                ObtainConnectionTask task = new ObtainConnectionTask(){

                    @Override
                    public void doit() throws IOException {
                        this.conx = BaseNetRequest.this.getConnection(url);
                    }
                };
                TimeoutController.execute(task, this._timeout);
                conx = task.conx;
                if (task.ioException != null) {
                    throw task.ioException;
                }
            }
            catch (TimeoutController.TimeoutException timeOutEx) {
                throw new IOException("No se ha podido obtener la conexi\u00f3n con el host '" + url.toString() + "' en el tiempo especificado: " + this._timeout + " msg");
            }
        }
        return conx;
    }

    public void setHeader(String name, String value) {
        if (this._headers == null) {
            this._headers = new HashMap();
        }
        this._headers.put(name, value);
    }

    private void _sendHeaders(URLConnection conx) {
        if (this._headers != null) {
            for (Map.Entry me : this._headers.entrySet()) {
                conx.setRequestProperty((String)me.getKey(), (String)me.getValue());
            }
        }
    }

    private String _getParameterString() {
        try {
            if (this._parameters != null) {
                StringBuffer sb = new StringBuffer("");
                Iterator it = this._parameters.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    String paramName = (String)me.getKey();
                    Object paramValue = me.getValue();
                    if (paramValue == null || !(paramValue instanceof String)) continue;
                    sb.append(URLEncoder.encode(paramName, "ISO-8859-1"));
                    sb.append('=');
                    sb.append(URLEncoder.encode((String)paramValue, "ISO-8859-1"));
                    if (!it.hasNext()) continue;
                    sb.append('&');
                }
                return sb.toString();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "";
    }

    public void writeToDataOutputStream(DataOutputStream dos) {
        try {
            if (this._parameters != null) {
                for (Map.Entry me : this._parameters.entrySet()) {
                    String paramName = (String)me.getKey();
                    Object paramValue = me.getValue();
                    if (paramValue == null) continue;
                    if (paramValue instanceof InputStream) {
                        BaseNetRequest.writeFileToDataOutputStream(dos, paramName, (InputStream)paramValue);
                        continue;
                    }
                    BaseNetRequest.writeParamToDataOutputStream(dos, paramName, (String)paramValue);
                }
                dos.writeBytes("--*****--\r\n");
            }
        }
        catch (Exception ueEx) {
            ueEx.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeParamToDataOutputStream(DataOutputStream dos, String name, String value) {
        ByteArrayInputStream fileInputStream = null;
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        int maxBufferSize = 0x100000;
        try {
            fileInputStream = new ByteArrayInputStream(value.getBytes());
            dos.writeBytes(twoHyphens + boundary + lineEnd);
            dos.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"" + lineEnd);
            dos.writeBytes(lineEnd);
            int bytesAvailable = ((InputStream)fileInputStream).available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = ((InputStream)fileInputStream).read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                dos.write(buffer, 0, bufferSize);
                bytesAvailable = ((InputStream)fileInputStream).available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = ((InputStream)fileInputStream).read(buffer, 0, bufferSize);
            }
            dos.writeBytes(lineEnd);
        }
        catch (MalformedURLException ex) {
            R01FLog.to("r01f.util").warning("From ServletCom CLIENT REQUEST:" + ex);
        }
        catch (IOException ioe) {
            R01FLog.to("r01f.util").warning("From ServletCom CLIENT REQUEST:" + ioe);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileToDataOutputStream(DataOutputStream dos, String name, InputStream fileInputStream) {
        String exsistingFileName = name + ".xml";
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        int maxBufferSize = 0x100000;
        try {
            dos.writeBytes(twoHyphens + boundary + lineEnd);
            dos.writeBytes("Content-Disposition: form-data; name=\"" + name + "\";" + " filename=\"" + exsistingFileName + "\"" + lineEnd);
            dos.writeBytes(lineEnd);
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                dos.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            dos.writeBytes(lineEnd);
        }
        catch (MalformedURLException ex) {
            R01FLog.to("r01f.util").warning("From ServletCom CLIENT REQUEST:" + ex);
        }
        catch (IOException ioe) {
            R01FLog.to("r01f.util").warning("From ServletCom CLIENT REQUEST:" + ioe);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void _obtainVersionInfo() {
        try {
            this.jdkVersion = System.getProperty("java.version");
            String[] versionCod = this.jdkVersion.split("\\.");
            int versionNum = new Integer(versionCod[1]);
            if (versionNum >= 5) {
                this.jdkVersionHigher5 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract class ObtainConnectionTask
    implements Runnable {
        public HttpURLConnection conx;
        public IOException ioException;

        ObtainConnectionTask() {
        }

        public abstract void doit() throws IOException;

        @Override
        public void run() {
            try {
                this.doit();
            }
            catch (IOException ioEx) {
                this.ioException = ioEx;
            }
        }
    }
}

