/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.mail;

import com.ejie.r01f.net.HttpClient;
import com.ejie.r01f.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;

public class MailComposer {
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    private String _smtpHost = null;
    private int _timeout = -1;
    private String _debug = "false";
    private String _proxyHost = null;
    private String _proxyPort = null;
    private String _proxyUser = null;
    private String _proxyPass = null;

    public MailComposer() {
    }

    public MailComposer(String smtpHost, boolean debug) {
        this._smtpHost = smtpHost;
        this._debug = debug ? "true" : "false";
    }

    public MailComposer(String smtpHost, int timeout, boolean debug) {
        this._smtpHost = smtpHost;
        this._timeout = timeout;
        this._debug = debug ? "true" : "false";
    }

    public MailComposer(String smtpHost, String proxyHost, String proxyPort, String proxyUser, String proxyPass, boolean debug) {
        this._smtpHost = smtpHost;
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._proxyUser = proxyUser;
        this._proxyPass = proxyPass;
        this._debug = debug ? "true" : "false";
    }

    public void sendMessage(String from, String to, String subject, String messageContentType, String messageText, String[] attachListFileNames) throws AddressException, MessagingException {
        if (!(StringUtils.isEmptyString(this._proxyHost) || StringUtils.isEmptyString(this._proxyPort) || StringUtils.isEmptyString(this._proxyUser) || StringUtils.isEmptyString(this._proxyPass))) {
            this.sendMessageByProxy(from, to, null, null, subject, messageContentType, messageText, attachListFileNames);
        } else {
            this.sendMessage(from, to, null, null, subject, messageContentType, messageText, attachListFileNames);
        }
    }

    public void sendMessage(String from, String to, String toCC, String toCCO, String subject, String messageContentType, String messageText, String[] attachListFileNames) throws AddressException, MessagingException {
        InternetAddress addr;
        int i;
        if (StringUtils.isEmptyString(this._smtpHost)) {
            throw new MessagingException("NO se puede enviar el mensaje JavaMail: NO se ha especificado el servidor SMTP");
        }
        if (StringUtils.isEmptyString(to)) {
            throw new MessagingException("NO se puede enviar el mensaje JavaMail: NO se ha especificado destinatario!");
        }
        if (!(StringUtils.isEmptyString(this._proxyHost) || StringUtils.isEmptyString(this._proxyPort) || StringUtils.isEmptyString(this._proxyUser) || StringUtils.isEmptyString(this._proxyPass))) {
            this.sendMessageByProxy(from, to, toCC, toCCO, subject, messageContentType, messageText, attachListFileNames);
            return;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this._smtpHost);
        if (this._timeout > -1) {
            props.put("mail.smtp.connectiontimeout", "" + this._timeout);
        }
        props.put("mail.debug", this._debug);
        Session sesion = Session.getInstance((Properties)props, null);
        sesion.setDebug(false);
        MimeMessage message = new MimeMessage(sesion);
        InternetAddress from_addr = new InternetAddress(from);
        message.setFrom((Address)from_addr);
        String[] toValues = to.split(";");
        InternetAddress[] addrsTo = new InternetAddress[toValues.length];
        for (int i2 = 0; i2 < toValues.length; ++i2) {
            InternetAddress addr2;
            addrsTo[i2] = addr2 = new InternetAddress(toValues[i2]);
        }
        message.addRecipients(Message.RecipientType.TO, (Address[])addrsTo);
        if (!StringUtils.isEmptyString(toCC)) {
            String[] toCCValues = toCC.split(";");
            InternetAddress[] addrsToCC = new InternetAddress[toCCValues.length];
            for (i = 0; i < toCCValues.length; ++i) {
                addrsToCC[i] = addr = new InternetAddress(toCCValues[i]);
            }
            message.addRecipients(Message.RecipientType.CC, (Address[])addrsToCC);
        }
        if (!StringUtils.isEmptyString(toCCO)) {
            String[] toCCOValues = toCCO.split(";");
            InternetAddress[] addrsToCCO = new InternetAddress[toCCOValues.length];
            for (i = 0; i < toCCOValues.length; ++i) {
                addrsToCCO[i] = addr = new InternetAddress(toCCOValues[i]);
            }
            message.addRecipients(Message.RecipientType.BCC, (Address[])addrsToCCO);
        }
        message.setSubject(subject);
        MimeMultipart mp = new MimeMultipart("related");
        MimeBodyPart textMP = new MimeBodyPart();
        textMP.setDisposition("inline");
        textMP.setContent((Object)messageText, messageContentType);
        mp.addBodyPart((BodyPart)textMP);
        if (attachListFileNames != null) {
            for (i = 0; i < attachListFileNames.length; ++i) {
                MimeBodyPart file_part = new MimeBodyPart();
                File file = new File(attachListFileNames[i]);
                FileDataSource fds = new FileDataSource(file);
                DataHandler dh = new DataHandler((DataSource)fds);
                file_part.setFileName(file.getName());
                file_part.setDisposition("attachment");
                file_part.setDataHandler(dh);
                mp.addBodyPart((BodyPart)file_part);
            }
        }
        message.setContent((Multipart)mp);
        Transport.send((Message)message);
        if (attachListFileNames != null && attachListFileNames.length > 0) {
            this._deleteTempFiles(attachListFileNames);
        }
    }

    public String getSMTPHost() {
        return this._smtpHost;
    }

    public void setSMTPHost(String host) {
        this._smtpHost = host;
    }

    private void _deleteTempFiles(String[] attachList) {
        for (int i = 0; i < attachList.length; ++i) {
            File file = new File(attachList[i]);
            file.delete();
        }
    }

    private void sendMessageByProxy(String from, String to, String toCC, String toCCO, String subject, String messageContentType, String messageText, String[] attachListFileNames) {
        HashMap<String, Object> parametersToPost = new HashMap<String, Object>();
        parametersToPost.put("from", from);
        parametersToPost.put("subject", subject);
        parametersToPost.put("messageContentType", messageContentType);
        parametersToPost.put("messageText", messageText);
        parametersToPost.put("to", to);
        parametersToPost.put("toCC", toCC);
        parametersToPost.put("toCCO", toCCO);
        HttpClient httpClient = new HttpClient(this._smtpHost, parametersToPost);
        httpClient.setProxyHost(this._proxyHost, this._proxyPort);
        httpClient.setProxyAuthorization(this._proxyUser, this._proxyPass);
        if (attachListFileNames != null) {
            for (int i = 0; i < attachListFileNames.length; ++i) {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(attachListFileNames[i]);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                byte[] bytes = null;
                try {
                    bytes = IOUtils.toByteArray((InputStream)inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                parametersToPost.put("file" + i, bis);
                parametersToPost.put("numFiles", new Integer(i + 1).toString());
            }
            httpClient.setContentType(HttpClient.MULTIPART_FORM_DATA_FILES_CONTENT_TYPE);
        } else {
            parametersToPost.put("numFiles", "0");
            httpClient.setContentType("application/x-www-form-urlencoded; charset=iso-8859-1");
        }
        try {
            httpClient.sendPostHttpCall();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

