/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.log;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.log.SimpleLogger;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;

public class SimpleFileLogger
implements SimpleLogger {
    private String _logFileName = null;
    private PrintWriter _pw = null;
    private Date _startTime = null;
    private Date _stopTime = null;

    public SimpleFileLogger(String logFileName) {
        this._logFileName = logFileName;
    }

    @Override
    public void write(String s) {
        this._pw.print(s);
    }

    @Override
    public void writeln(String s) {
        this._pw.println(s);
        this._pw.flush();
    }

    @Override
    public void writeln() {
        this._pw.println();
        this._pw.flush();
    }

    @Override
    public void start() {
        this._startTime = Calendar.getInstance().getTime();
        try {
            this._pw = new PrintWriter(new FileWriter(this._logFileName));
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        this._pw.println("# --------------------------------------------");
        this._pw.println("# LOG FILE     : " + this._logFileName);
        this._pw.println("# START TIME   : " + this._startTime);
        this._pw.println("# --------------------------------------------");
        this._pw.println();
        this._pw.flush();
    }

    @Override
    public void stop() {
        this._stopTime = Calendar.getInstance().getTime();
        long diff = this._stopTime.getTime() - this._startTime.getTime();
        this._pw.println();
        this._pw.println("# --------------------------------------------");
        this._pw.println("#           << END OF LOGFILE >>              ");
        this._pw.println("# --------------------------------------------");
        this._pw.println("# STOP TIME    : " + this._stopTime);
        this._pw.println("# ELAPSED TIME : " + diff / 1000L + " seconds.");
        this._pw.println("# --------------------------------------------");
        this._pw.flush();
        this._pw.close();
    }

    public static void main(String[] args) {
        try {
            SimpleFileLogger logger = new SimpleFileLogger("d:/eAdmin/testStyleSheetAdaptor/test.log");
            logger.start();
            logger.writeln("Prueba 1");
            logger.write("ESSSSSS : ");
            logger.writeln("retorno de carro");
            logger.stop();
        }
        catch (Exception ex) {
            R01FLog.to("r01f.test").info("Exception!!!" + ex.toString());
            ex.printStackTrace(System.out);
        }
    }
}

