/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.log;

import com.ejie.r01f.util.DateUtils;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DateTimeLogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtils.getDateFormated(new Date(record.getMillis()), "dd/MM/yyyy [HH:mm:ss]"));
        sb.append(' ');
        if (record.getLevel().intValue() == Level.SEVERE.intValue()) {
            sb.append("\r\n\r\n\r\n[SEVERE]===================\r\n(");
            sb.append(record.getSourceClassName());
            sb.append('.');
            sb.append(record.getSourceMethodName());
            sb.append(")\r\n");
            sb.append(record.getMessage());
            sb.append("\r\n=========================\r\n\r\n\r\n");
        } else if (record.getLevel().intValue() == Level.WARNING.intValue()) {
            sb.append("\r\n\r\n\r\n[WARNING]===================\r\n(");
            sb.append(record.getSourceClassName());
            sb.append('.');
            sb.append(record.getSourceMethodName());
            sb.append(")\r\n");
            sb.append(record.getMessage());
            sb.append("\r\n============================\r\n\r\n\r\n");
        } else {
            sb.append(record.getMessage());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

