/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.jvt;

import com.ejie.r01f.jvt.JVTComparatorException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.CollectionConverterException;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.ClassMap;
import com.ejie.r01f.xml.marshalling.MemberMap;
import com.ejie.r01f.xml.marshalling.XOMap;
import java.lang.reflect.Field;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang.builder.EqualsBuilder;

public class JVTComparator {
    private static boolean DEBUG = R01FLog.getLogLevel("r01f.jvt").intValue() != Level.OFF.intValue();
    private XOMap _map = null;
    private LinkedList<PlanTableOperation> _theList = null;
    private int _theListIndex = 0;
    public static final String[] OPERATION_DESCS = new String[]{"update", "insertNew", "delete", "linkAggregation", "unlinkAggregation", "addComposition", "deleteComposition"};

    public JVTComparator() {
    }

    public JVTComparator(XOMap map, Object objS1, Object objS2) throws JVTComparatorException {
        this();
        this.doComparision(map, objS1, objS2);
    }

    public String composeDebugInfo() {
        StringBuffer sb = new StringBuffer("");
        try {
            PlanTableOperation operation = this.nextOperation();
            while (operation != null) {
                sb.append(operation.toString());
                if (operation.args != null) {
                    if (operation.args.length == 1) {
                        sb.append(" OIDs = " + (operation.args[0] != null ? this.getObjectOid(operation.args[0]) : "{obj null}"));
                    } else if (operation.args.length == 2) {
                        sb.append(" OIDs = " + (operation.args[0] != null ? this.getObjectOid(operation.args[0]) : "{obj null}") + "," + (operation.args[1] != null ? this.getObjectOid(operation.args[1]) : "{obj null}"));
                    }
                }
                sb.append("\r\n");
                operation = this.nextOperation();
            }
        }
        catch (JVTComparatorException jvtEx) {
            jvtEx.printStackTrace(System.out);
            sb.append(jvtEx.getMessage());
        }
        return sb.toString();
    }

    public static String composeDebugInfo(List<PlanTableOperation> planList) {
        if (planList == null) {
            return "No ops";
        }
        StringBuffer sb = new StringBuffer("Operations:\r\n");
        for (PlanTableOperation po : planList) {
            sb.append("\t");
            sb.append(po.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public void reset() {
        this._theList = null;
        this._theListIndex = 0;
    }

    public void doComparision(XOMap map, Object objS1, Object objS2) throws JVTComparatorException {
        this._map = map;
        if (this._map == null) {
            throw new JVTComparatorException("Error al iniciar la comparacion: El mapa de definicion de clases es nulo!!!");
        }
        if (objS1 == null && objS2 == null) {
            throw new JVTComparatorException("Los objetos a comparar no pueden ambos ser nulos");
        }
        if (DEBUG) {
            R01FLog.to("r01f.jvt").info("Iniciando la comparacion...");
        }
        if (objS2 == null) {
            this._theList = new LinkedList();
            this._theList.add(new PlanTableOperation(2, new Object[]{objS1}));
            return;
        }
        this._theList = this._processObjMembers(objS1, objS2);
        if (objS1 != null && objS2 != null) {
            Class<?> objClassDef = objS1.getClass();
            ClassMap classMap = this._map.getClassFromClassName(ReflectionUtils.getClassNameFromCompleteClassName(objClassDef.getName()));
            MemberMap difMember = this._areInSameState(objS1, objS2, classMap);
            if (difMember != null) {
                if (DEBUG) {
                    R01FLog.to("r01f.jvt").info("\t\t\t ooooooo actualizando el estado del objeto padre (difieren en el miembro " + difMember.name + ")");
                }
                this._theList.addFirst(new PlanTableOperation(0, new Object[]{null, objS2}));
            }
        } else if (objS1 == null) {
            this._theList.addFirst(new PlanTableOperation(1, new Object[]{objS2}));
            return;
        }
    }

    public PlanTableOperation nextOperation() {
        if (this._theList != null && this._theListIndex >= 0 && this._theListIndex < this._theList.size()) {
            return this._theList.get(this._theListIndex++);
        }
        return null;
    }

    public PlanTableOperation prevOperation() {
        if (this._theList != null && this._theListIndex > 0 && this._theListIndex <= this._theList.size()) {
            return this._theList.get(this._theListIndex--);
        }
        return null;
    }

    public Iterator<PlanTableOperation> getPlanTableIterator() {
        if (this._theList != null) {
            return this._theList.iterator();
        }
        return null;
    }

    public List<PlanTableOperation> getPlanTable() {
        return this._theList;
    }

    public Object getObjectOid(Object obj) throws JVTComparatorException {
        if (obj == null) {
            throw new JVTComparatorException("No se puede obtener el valor del miembro oid de un objeto null");
        }
        String className = ReflectionUtils.getClassNameFromCompleteClassName(obj.getClass().getName());
        ClassMap objClassMap = this._map.getClassFromClassName(className);
        if (objClassMap == null) {
            throw new JVTComparatorException("No se ha definido la clase " + obj.getClass().getName() + " en el documento de mapeo. Revisalo!");
        }
        MemberMap oidMember = objClassMap.getOIDMember();
        if (oidMember == null) {
            R01FLog.to("r01f.jvt").warning("No se ha definido ningun miembro OID para la clase " + obj.getClass().getName() + " en el documento de mapeo. Revisalo!");
            return null;
        }
        try {
            return ReflectionUtils.getMemberValue(obj, oidMember.name, false);
        }
        catch (ReflectionException refEx) {
            throw new JVTComparatorException("Error al acceder al miembro " + oidMember.name + " de la clase " + obj.getClass().getName() + " para obtener su valor.", (Exception)refEx);
        }
    }

    private LinkedList<PlanTableOperation> _processObjMembers(Object objS1, Object objS2) throws JVTComparatorException {
        if (objS1 == null && objS2 == null) {
            return null;
        }
        Class<?> objClassDef = objS1 != null ? objS1.getClass() : objS2.getClass();
        ClassMap classMap = this._map.getClassFromClassName(ReflectionUtils.getClassNameFromCompleteClassName(objClassDef.getName()));
        Field[] declaredFields = objClassDef.getDeclaredFields();
        Field currField2 = null;
        MemberMap currFieldMap = null;
        Object currFieldValue = null;
        Class<?> currFieldValueClassDef = null;
        try {
            if (DEBUG) {
                R01FLog.to("r01f.jvt").info("Procesando los miembros del objeto: " + classMap.name);
            }
            LinkedList<PlanTableOperation> outPlan = new LinkedList<PlanTableOperation>();
            StringBuffer traza = new StringBuffer(126);
            for (Field currField2 : declaredFields) {
                currFieldMap = classMap.getMember(currField2.getName());
                traza.append("\tmiembro '");
                traza.append(currField2);
                traza.append("': ");
                if ((0x10 & currField2.getModifiers()) != 0 && (8 & currField2.getModifiers()) != 0 || (0x80 & currField2.getModifiers()) != 0) {
                    traza.append("[static final] > NO se compara!");
                    if (!DEBUG) continue;
                    R01FLog.to("r01f.jvt").info(traza.toString());
                    continue;
                }
                if (currFieldMap == null) {
                    throw new JVTComparatorException("El miembro " + currField2.getName() + " NO se ha definido en la clase " + objClassDef.getName() + ". Revisa el documento de mapeo");
                }
                if ((8 & currField2.getModifiers()) != 0 || (0x80 & currField2.getModifiers()) != 0 || currFieldMap.isTransient) {
                    traza.append("[est\u00e1tico/transient] > NO se compara!");
                    if (!DEBUG) continue;
                    R01FLog.to("r01f.jvt").info(traza.toString());
                    continue;
                }
                currFieldValueClassDef = currField2.getType();
                if (!ReflectionUtils.isFinalInmutable(currFieldValueClassDef)) {
                    LinkedList<PlanTableOperation> tempPlan;
                    Object jvtS1 = objS1 != null ? ReflectionUtils.getMemberValue(objS1, currFieldMap.name, false) : null;
                    Object jvtS2 = objS2 != null ? ReflectionUtils.getMemberValue(objS2, currFieldMap.name, false) : null;
                    boolean isArray = ReflectionUtils.isArray(currFieldValueClassDef);
                    boolean isMap = ReflectionUtils.isMap(currFieldValueClassDef);
                    boolean isList = ReflectionUtils.isList(currFieldValueClassDef);
                    if (isArray || isMap || isList) {
                        traza.append("[tipo complejo: ]");
                        traza.append(isArray ? "Array" : "");
                        traza.append(isMap ? "Map" : "");
                        traza.append(isList ? "List" : "");
                        if (DEBUG) {
                            R01FLog.to("r01f.jvt").info(traza.toString());
                        }
                        if ((tempPlan = this._processSet(objS2, currField2, jvtS1, jvtS2)) == null) continue;
                        outPlan.addAll(tempPlan);
                        continue;
                    }
                    traza.append("[tipo complejo: ]");
                    traza.append(currFieldValueClassDef.getName());
                    if (DEBUG) {
                        R01FLog.to("r01f.jvt").info(traza.toString());
                    }
                    if ((tempPlan = this._processObject(objS2, currField2, jvtS1, jvtS2)) == null) continue;
                    outPlan.addAll(tempPlan);
                    continue;
                }
                traza.append("[tipo primitivo o inmutable] > NO hacer nada");
                if (!DEBUG) continue;
                R01FLog.to("r01f.jvt").info(traza.toString());
            }
            return outPlan;
        }
        catch (ReflectionException refEx) {
            refEx.printStackTrace(System.out);
            throw new JVTComparatorException("Error al obtener el valor del miembro " + currField2.getName() + " de la clase " + objClassDef.getName(), (Exception)refEx);
        }
    }

    private LinkedList<PlanTableOperation> _processSet(Object parentObj, Field parentField, Object objsInS1, Object objsInS2) throws JVTComparatorException {
        Collection[] changes;
        Class<?> parentObjClassDef = parentObj.getClass();
        ClassMap parentObjClassMap = this._map.getClassFromClassName(ReflectionUtils.getClassNameFromCompleteClassName(parentObjClassDef.getName()));
        if (parentObjClassMap == null) {
            throw new JVTComparatorException("La clase " + parentObjClassDef.getName() + " NO esta en el documento de mapeo. Revisalo!");
        }
        MemberMap parentMember = parentObjClassMap.members.get(parentField.getName());
        if (parentMember == null) {
            throw new JVTComparatorException("En la definici\u00f3n de la clase " + parentObjClassDef.getName() + " NO se encuentra un miembro " + parentField.getName() + ". Revisalo!");
        }
        if (parentMember.dataTypeName == null) {
            throw new JVTComparatorException("No se ha definido el tipo de datos contenido en la coleccion " + parentField.getName() + " del objeto " + parentObjClassDef.getName() + ". Revisa el documento de mapeo");
        }
        ClassMap childObjClassMap = this._map.getClassFromClassName(parentMember.dataTypeName);
        String oidMemberName = childObjClassMap.getOIDMember() != null ? childObjClassMap.getOIDMember().name : null;
        boolean useAccessors = childObjClassMap.useAccessors;
        Map objsMapInS1 = null;
        Map objsMapInS2 = null;
        try {
            if (parentMember.collection == 0) {
                if (DEBUG) {
                    R01FLog.to("r01f.jvt").info("\t\tarray de objetos... convertir a un mapa");
                }
                objsMapInS1 = CollectionUtils.convertArrayIntoMap(objsInS1, oidMemberName, useAccessors);
                objsMapInS2 = CollectionUtils.convertArrayIntoMap(objsInS2, oidMemberName, useAccessors);
            } else if (parentMember.collection == 8) {
                if (DEBUG) {
                    R01FLog.to("r01f.jvt").info("\t\tlista de objetos... convertir a un mapa");
                }
                objsMapInS1 = CollectionUtils.convertListIntoMap((List)objsInS1, oidMemberName, useAccessors);
                objsMapInS2 = CollectionUtils.convertListIntoMap((List)objsInS2, oidMemberName, useAccessors);
            } else if (parentMember.collection == 5) {
                if (DEBUG) {
                    R01FLog.to("r01f.jvt").info("\t\tmapa de objetos...");
                }
                objsMapInS1 = (Map)objsInS1;
                objsMapInS2 = (Map)objsInS2;
            }
        }
        catch (CollectionConverterException ccEx) {
            throw new JVTComparatorException("Error al pasar la coleccion a mapa: " + ccEx.getMessage(), (Exception)ccEx);
        }
        LinkedList<PlanTableOperation> outPlan = new LinkedList<PlanTableOperation>();
        if (DEBUG) {
            R01FLog.to("r01f.jvt").info("\t\tobtener los cambios en el mapa: objetos a\u00f1adidos, eliminados y existentes");
        }
        if ((changes = CollectionUtils.obtainChangesInMap(true, objsMapInS1, objsMapInS2)) != null) {
            LinkedList<PlanTableOperation> updateOps;
            LinkedList<PlanTableOperation> deleteOps;
            LinkedList<PlanTableOperation> insertOps;
            if (DEBUG) {
                R01FLog.to("r01f.jvt").info("\t\t\tprocesando objetos nuevos........" + (changes[0] == null ? 0 : changes[0].size()));
            }
            if ((insertOps = this._processSubSet(parentObj, parentField, changes[0], objsMapInS1, objsMapInS2)) != null) {
                outPlan.addAll(insertOps);
            }
            if (DEBUG) {
                R01FLog.to("r01f.jvt").info("\t\t\tprocesando objetos borrados......" + (changes[1] == null ? 0 : changes[1].size()));
            }
            if ((deleteOps = this._processSubSet(parentObj, parentField, changes[1], objsMapInS1, objsMapInS2)) != null) {
                outPlan.addAll(deleteOps);
            }
            if (DEBUG) {
                R01FLog.to("r01f.jvt").info("\t\t\tprocesando objetos existentes...." + (changes[2] == null ? 0 : changes[2].size()));
            }
            if ((updateOps = this._processSubSet(parentObj, parentField, changes[2], objsMapInS1, objsMapInS2)) != null) {
                outPlan.addAll(updateOps);
            }
        }
        return outPlan;
    }

    private LinkedList<PlanTableOperation> _processSubSet(Object parentObj, Field parentField, Collection keys, Map objsMapInS1, Map objsMapInS2) throws JVTComparatorException {
        if (keys == null || keys.size() == 0) {
            return null;
        }
        LinkedList<PlanTableOperation> outPlan = new LinkedList<PlanTableOperation>();
        Object key2 = null;
        Object objInS1 = null;
        Object objInS2 = null;
        LinkedList<PlanTableOperation> currObjOperations = null;
        for (Object key2 : keys) {
            if (objsMapInS1 != null) {
                objInS1 = objsMapInS1.get(key2);
            }
            if (objsMapInS2 != null) {
                objInS2 = objsMapInS2.get(key2);
            }
            if ((currObjOperations = this._processObject(parentObj, parentField, objInS1, objInS2)) == null) continue;
            outPlan.addAll(currObjOperations);
        }
        return outPlan;
    }

    private LinkedList<PlanTableOperation> _processObject(Object parentObj, Field parentField, Object objS1, Object objS2) throws JVTComparatorException {
        if (objS1 == null && objS2 == null) {
            return null;
        }
        if (objS1 != null && objS2 != null && !objS1.getClass().equals(objS2.getClass())) {
            throw new JVTComparatorException("Los objetos a comparar no son de la misma clase!!!: " + objS1.getClass().getName() + "-" + objS2.getClass().getName());
        }
        Class<?> objClassDef = objS1 != null ? objS1.getClass() : objS2.getClass();
        ClassMap classMap = this._map.getClassFromClassName(ReflectionUtils.getClassNameFromCompleteClassName(objClassDef.getName()));
        if (classMap == null) {
            throw new JVTComparatorException("La clase " + objClassDef.getName() + " NO esta en el documento de mapeo. Revisalo!");
        }
        int relationWithParent = -1;
        LinkedList<PlanTableOperation> outPlan = new LinkedList<PlanTableOperation>();
        StringBuffer traza = new StringBuffer();
        if (parentObj != null) {
            Class<?> parentObjClassDef = parentObj.getClass();
            ClassMap parentObjClassMap = this._map.getClassFromClassName(ReflectionUtils.getClassNameFromCompleteClassName(parentObjClassDef.getName()));
            if (parentObjClassMap == null) {
                throw new JVTComparatorException("La clase " + parentObjClassDef.getName() + " NO esta en el documento de mapeo. Revisalo!");
            }
            MemberMap parentMember = parentObjClassMap.members.get(parentField.getName());
            if (parentMember == null) {
                throw new JVTComparatorException("En la definici\u00f3n de la clase " + parentObjClassDef.getName() + " NO se encuentra un miembro " + parentField.getName() + ". Revisalo!");
            }
            relationWithParent = parentMember.relation;
            if (objS1 != null && objS2 != null) {
                String oidMemberName = classMap.getOIDMember() != null ? classMap.getOIDMember().name : null;
                String oidAccessorMethod = classMap.getOidAccessorMethodName();
                boolean useAccesorsLocal = classMap.useAccessors;
                if (oidMemberName != null || oidAccessorMethod != null) {
                    traza.append("\t\t\tObjeto modificado >> Ver si ha cambiado el oid '");
                    traza.append(oidMemberName);
                    traza.append("->>>");
                    Object oidS1 = null;
                    Object oidS2 = null;
                    try {
                        if (oidMemberName != null) {
                            oidS1 = ReflectionUtils.getMemberValue(objS1, oidMemberName, useAccesorsLocal);
                            oidS2 = ReflectionUtils.getMemberValue(objS2, oidMemberName, useAccesorsLocal);
                        } else if (oidAccessorMethod != null) {
                            oidS1 = ReflectionUtils.invokeMethod(objS1, oidAccessorMethod, null, null);
                            oidS2 = ReflectionUtils.invokeMethod(objS2, oidAccessorMethod, null, null);
                        }
                    }
                    catch (ReflectionException refEx) {
                        throw new JVTComparatorException("Error al obtener el oid del objeto dependiente " + objClassDef.getName() + ": " + refEx.getMessage(), (Exception)refEx);
                    }
                    catch (Throwable th) {
                        th.printStackTrace(System.out);
                        throw new JVTComparatorException("Error al obtener el oid del objeto dependiente " + objClassDef.getName() + ": " + th.getMessage());
                    }
                    if (oidS1 != null && oidS1.equals(oidS2)) {
                        traza.append("S1=");
                        traza.append(oidS1);
                        traza.append(" - S2=");
                        traza.append(oidS2);
                        traza.append(" >>> el oid NO ha cambiado... NO hay que cambiar relaciones");
                        if (DEBUG) {
                            R01FLog.to("r01f.jvt").info(traza.toString());
                        }
                    } else {
                        traza.append("S1=");
                        traza.append(oidS1);
                        traza.append(" - S2=");
                        traza.append(oidS2);
                        traza.append(" >>> el oid ha cambiado... la operacion depende del tipo de relacion");
                        if (relationWithParent == -1) {
                            traza.append("\t\t\t\tNo se define relacion padre-hijo: Borrar el objeto antiguo e insertar el nuevo");
                            outPlan.addLast(new PlanTableOperation(2, new Object[]{objS1}));
                            outPlan.addLast(new PlanTableOperation(1, new Object[]{objS2}));
                        } else if (relationWithParent == 1) {
                            traza.append("\t\t\t\trelacion AGGREGATION: Unlink del objeto antiguo y Link del objeto nuevo");
                            outPlan.addLast(new PlanTableOperation(4, new Object[]{parentObj, objS1}));
                            outPlan.addLast(new PlanTableOperation(3, new Object[]{parentObj, objS2}));
                        } else if (relationWithParent == 0) {
                            traza.append("\t\t\t\trelacion COMPOSITION: Borrar el objeto antiguo e insertar el nuevo");
                            outPlan.addLast(new PlanTableOperation(6, new Object[]{parentObj, objS1}));
                            outPlan.addLast(new PlanTableOperation(5, new Object[]{parentObj, objS2}));
                        }
                    }
                } else {
                    traza = new StringBuffer("\t\t\t          >> No se define un miembro OID... pasar...");
                }
            } else if (objS1 == null && objS2 != null) {
                traza = new StringBuffer("\t\t\tObjeto NUEVO >>");
                if (relationWithParent == -1) {
                    traza.append("No se define relacion padre-hijo: Insertar el nuevo");
                    outPlan.addLast(new PlanTableOperation(1, new Object[]{objS2}));
                } else if (relationWithParent == 1) {
                    traza.append("relacion AGGREGATION: Link del objeto nuevo");
                    outPlan.addLast(new PlanTableOperation(3, new Object[]{parentObj, objS2}));
                } else if (relationWithParent == 0) {
                    traza.append("relacion COMPOSITION: Insertar el nuevo objeto");
                    outPlan.addLast(new PlanTableOperation(5, new Object[]{parentObj, objS2}));
                }
            } else if (objS1 != null && objS2 == null) {
                traza = new StringBuffer("\t\t\tObjeto BORRADO >>");
                if (relationWithParent == -1) {
                    traza.append("No se define relacion padre-hijo: Borrar el objeto");
                    outPlan.addLast(new PlanTableOperation(2, new Object[]{objS1}));
                } else if (relationWithParent == 1) {
                    traza.append("relacion AGGREGATION: UnLink del objeto");
                    outPlan.addLast(new PlanTableOperation(4, new Object[]{parentObj, objS1}));
                } else if (relationWithParent == 0) {
                    traza.append("relacion COMPOSITION: Borrar el objeto");
                    outPlan.addLast(new PlanTableOperation(6, new Object[]{parentObj, objS1}));
                }
            }
        }
        if (DEBUG) {
            R01FLog.to("r01f.jvt").info(traza.toString());
        }
        if (objS1 != null && objS2 != null) {
            MemberMap difMember = this._areInSameState(objS1, objS2, classMap);
            if (difMember != null) {
                if (outPlan != null) {
                    if (!outPlan.isEmpty()) {
                        PlanTableOperation lastOp = outPlan.getLast();
                        if (lastOp.operation == 2 || lastOp.operation == 6 || lastOp.operation == 4) {
                            if (DEBUG) {
                                R01FLog.to("r01f.jvt").info("\t\t\t ...NO se actualiza ya que la ultima operaci\u00f3n lanza un borrado");
                            }
                        } else {
                            if (DEBUG) {
                                R01FLog.to("r01f.jvt").info("\t\t\t ooooooo actualizando el estado (difieren en el miembro " + difMember.name + ")");
                            }
                            outPlan.addLast(new PlanTableOperation(0, new Object[]{parentObj, objS2}));
                        }
                    } else {
                        if (DEBUG) {
                            R01FLog.to("r01f.jvt").info("\t\t\t ooooooo actualizando el estado (difieren en el miembro " + difMember.name + ")");
                        }
                        outPlan.addLast(new PlanTableOperation(0, new Object[]{parentObj, objS2}));
                    }
                } else if (DEBUG) {
                    R01FLog.to("r01f.jvt").info("\t\t\t ooooooo Ajjjjjjj!");
                }
            } else if (DEBUG) {
                R01FLog.to("r01f.jvt").info("\t\t\t ooooooo NO ha cambiado el estado del objeto, NO se actualiza!!");
            }
        }
        if (relationWithParent != 1 && objS2 != null) {
            LinkedList<PlanTableOperation> otherPlan;
            if (DEBUG) {
                R01FLog.to("r01f.jvt").info("\t\t\t ...procesando recursivamente el objeto " + objS2.getClass().getName());
            }
            if ((otherPlan = this._processObjMembers(objS1, objS2)) != null) {
                outPlan.addAll(otherPlan);
            }
        }
        return outPlan;
    }

    private MemberMap _areInSameState(Object objS1, Object objS2, ClassMap classMap) throws JVTComparatorException {
        if (objS1 == null || objS2 == null) {
            throw new JVTComparatorException("AAAAAAAAAAAAAAAAAAAAAAAAAA!!!!");
        }
        if (classMap != null && classMap.members != null) {
            Object currMemberObjS1Value = null;
            Object currMemberObjS2Value = null;
            for (MemberMap currMember : classMap.members.values()) {
                if (currMember.collection != -1 || currMember.dataType == 15 || currMember.dataType == 14 || currMember.isTransient) continue;
                boolean areEqual = true;
                try {
                    currMemberObjS1Value = ReflectionUtils.getMemberValue(objS1, currMember.name, true);
                    currMemberObjS2Value = ReflectionUtils.getMemberValue(objS2, currMember.name, true);
                    areEqual = this._areObjectsEqual(currMemberObjS1Value, currMemberObjS2Value);
                }
                catch (ReflectionException refEx) {
                    throw new JVTComparatorException("Error al comparar el estado de dos objetos (equals): NO se puede acceder al miembro " + currMember.name + ": " + refEx.getMessage(), (Exception)refEx);
                }
                if (areEqual) continue;
                if (DEBUG) {
                    R01FLog.to("r01f.jvt").info("\t\t\t\t ...los objetos NO estan en el mismo estado, difieren en el miembro: " + currMember.name + " --> '" + currMemberObjS1Value + "':'" + currMemberObjS2Value + "'");
                }
                R01FLog.to("r01f.test").info("...los valores de " + classMap.name + "." + currMember.name + " difieren --> '" + currMemberObjS1Value + "':'" + currMemberObjS2Value + "'");
                return currMember;
            }
        } else {
            throw new JVTComparatorException("NO se puede comparar el estado de dos objetos si no se pasa el classMap!!");
        }
        return null;
    }

    private boolean _areObjectsEqual(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 instanceof Date) {
            String date1 = DateUtils.getDateFormated((Date)obj1, "dd/MM/yyyy HH:mm:ss");
            String date2 = DateUtils.getDateFormated((Date)obj2, "dd/MM/yyyy HH:mm:ss");
            EqualsBuilder eqBuilder = new EqualsBuilder();
            eqBuilder.append((Object)date1, (Object)date2);
            return eqBuilder.isEquals();
        }
        if (obj1 instanceof java.util.Date) {
            String date1 = DateUtils.getDateFormated((java.util.Date)obj1, "dd/MM/yyyy HH:mm:ss");
            String date2 = DateUtils.getDateFormated((java.util.Date)obj2, "dd/MM/yyyy HH:mm:ss");
            EqualsBuilder eqBuilder = new EqualsBuilder();
            eqBuilder.append((Object)date1, (Object)date2);
            return eqBuilder.isEquals();
        }
        if (obj1 instanceof String && ((String)obj1).length() == 0 && obj2 == null) {
            String str1 = (String)obj1;
            String str2 = "";
            EqualsBuilder eqBuilder = new EqualsBuilder();
            eqBuilder.append((Object)str1, (Object)str2);
            return eqBuilder.isEquals();
        }
        if (obj2 instanceof String && ((String)obj2).length() == 0 && obj1 == null) {
            String str1 = "";
            String str2 = (String)obj2;
            EqualsBuilder eqBuilder = new EqualsBuilder();
            eqBuilder.append((Object)str1, (Object)str2);
            return eqBuilder.isEquals();
        }
        EqualsBuilder eqBuilder = new EqualsBuilder();
        eqBuilder.append(obj1, obj2);
        return eqBuilder.isEquals();
    }

    public class PlanTableOperation {
        public static final int PARENT_OBJECT = 0;
        public static final int CHILD_OBJECT = 1;
        public static final int OPERATION_UPDATE_STATE = 0;
        public static final int OPERATION_INSERT_NEW = 1;
        public static final int OPERATION_DELETE = 2;
        public static final int OPERATION_LINK_AGGREGATION = 3;
        public static final int OPERATION_UNLINK_AGGREGATION = 4;
        public static final int OPERATION_ADD_COMPOSITION = 5;
        public static final int OPERATION_DELETE_COMPOSITION = 6;
        public int operation;
        public Object[] args;

        public PlanTableOperation() {
        }

        public PlanTableOperation(int newOperation, Object[] newArgs) {
            this.operation = newOperation;
            this.args = newArgs;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(StringUtils.lPadWithChar(OPERATION_DESCS[this.operation] + ">>", ' ', 20));
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    sb.append("[");
                    sb.append(this.args[i] != null ? this.args[i].getClass().getName() : "null");
                    sb.append("]");
                }
            }
            return sb.toString();
        }
    }
}

