/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.io.filters;

import com.ejie.r01f.io.filters.DirectiveFilterReader;
import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLDataIslandsInHTMLReplacer {
    private static final transient String DIRECTIVE_BEGIN = "<!--@@";
    private static final transient String DIRECTIVE_END = "@@-->";
    private Map _newDataIslandXMLs;
    private String _replacedDocumentStr;
    private int _maxDirectiveLength = 8000;

    public XMLDataIslandsInHTMLReplacer() {
    }

    public XMLDataIslandsInHTMLReplacer(int maxDirectiveChars) {
        this._maxDirectiveLength = maxDirectiveChars;
    }

    public XMLDataIslandsInHTMLReplacer(Map idsAndNewXML) {
        this();
        this._newDataIslandXMLs = idsAndNewXML;
    }

    public XMLDataIslandsInHTMLReplacer(Map idsAndNewXML, int maxDirectiveChars) {
        this();
        this._newDataIslandXMLs = idsAndNewXML;
        this._maxDirectiveLength = maxDirectiveChars;
    }

    public void setNewDataIslandsXMLs(Map newDataIslandsXMLs) {
        this._newDataIslandXMLs = newDataIslandsXMLs;
    }

    public String getReplacedDocument() {
        return this._replacedDocumentStr;
    }

    public int replaceXMLDataIslandsInDocument(Reader r) throws IOException {
        if (r == null) {
            return 0;
        }
        return this._doParseDocument(this._newDataIslandXMLs, r);
    }

    public int replaceXMLDataIslandsInDocument(Map newXMLDataIslandsXMLs, Reader r) throws IOException {
        this._newDataIslandXMLs = newXMLDataIslandsXMLs;
        return this.replaceXMLDataIslandsInDocument(r);
    }

    public int replaceXMLDataIslandsInDocument(File f) throws IOException {
        if (f == null) {
            return 0;
        }
        if (!f.exists()) {
            throw new IOException("El fichero " + f.getAbsolutePath() + " NO existe. No se pueden obtener los XMLData Islands");
        }
        FileReader fr = new FileReader(f);
        if (fr == null) {
            return 0;
        }
        return this._doParseDocument(this._newDataIslandXMLs, fr);
    }

    public int replaceXMLDataIslandsInDocument(Map newXMLDataIslandsXMLs, File f) throws IOException {
        this._newDataIslandXMLs = newXMLDataIslandsXMLs;
        return this.replaceXMLDataIslandsInDocument(f);
    }

    public int replaceXMLDataIslandsInDocument(String filePath) throws IOException {
        if (filePath == null) {
            return 0;
        }
        File f = new File(filePath);
        return this.replaceXMLDataIslandsInDocument(this._newDataIslandXMLs, f);
    }

    public int replaceXMLDataIslandsInDocument(Map newXMLDataIslandsXMLs, String filePath) throws IOException {
        this._newDataIslandXMLs = newXMLDataIslandsXMLs;
        return this.replaceXMLDataIslandsInDocument(filePath);
    }

    private int _doParseDocument(Map newXMLDataIslandsXMLs, Reader r) throws IOException {
        int c;
        if (newXMLDataIslandsXMLs == null || newXMLDataIslandsXMLs.size() == 0) {
            return 0;
        }
        if (r == null) {
            throw new IOException("El reader es null: No se pueden encontrar los XMLDataIslands");
        }
        DataIslandDirectiveListener directiveListener = new DataIslandDirectiveListener(newXMLDataIslandsXMLs);
        DirectiveFilterReader directiveFilterReader = new DirectiveFilterReader(r, this._maxDirectiveLength);
        directiveFilterReader.addListener(directiveListener, DIRECTIVE_BEGIN, DIRECTIVE_END);
        StringWriter sw = new StringWriter();
        do {
            c = directiveFilterReader.read();
            sw.write(c);
        } while (c > 0);
        directiveFilterReader.close();
        this._replacedDocumentStr = sw.toString();
        return directiveListener.getReplacedXMLDataIslandsCount();
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                FileInputStream fis = new FileInputStream(new File("d:/temp_adm/r33-copy02.shtml"));
                StringBuffer sb = new StringBuffer();
                int b = 0;
                while ((b = fis.read()) != -1) {
                    sb.append((char)b);
                }
                String doc = sb.toString();
                HashMap<String, String> newDataIslandsValues = new HashMap<String, String>();
                newDataIslandsValues.put("r01gPageDef", "[nuevo XML del dataIsland id1]");
                newDataIslandsValues.put("id2", "[nuevo XML del dataIsland id2]");
                XMLDataIslandsInHTMLReplacer diReplacer = new XMLDataIslandsInHTMLReplacer(newDataIslandsValues, 50000);
                int replacedCount = diReplacer.replaceXMLDataIslandsInDocument(new StringReader(doc));
                String replacedDoc = diReplacer.getReplacedDocument();
                R01FLog.to("r01f.test").info(">>>>" + replacedCount + " dataIslands sustituidos");
                R01FLog.to("r01f.test").info(doc);
                R01FLog.to("r01f.test").info(replacedDoc);
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class DataIslandDirectiveListener
    implements DirectiveListener {
        private static final String DATAISLAND_MATCHER_REGEXP = "\\s*(<xml\\s+id=['\"]([^'\"]+)['\"]\\s*>)(.*)(</xml>)\\s*";
        private int _replacedDataIslandsCount = 0;
        private Map _xmlsToReplace;

        public DataIslandDirectiveListener() {
        }

        public DataIslandDirectiveListener(Map xmlsToReplace) {
            this._xmlsToReplace = xmlsToReplace;
        }

        @Override
        public char[] processDirective(String directiveText, long index) throws IOException {
            if (this._xmlsToReplace == null) {
                return null;
            }
            if (directiveText.length() > XMLDataIslandsInHTMLReplacer.DIRECTIVE_BEGIN.length() + XMLDataIslandsInHTMLReplacer.DIRECTIVE_END.length()) {
                CharSequence currDataIslandXML = directiveText.subSequence(XMLDataIslandsInHTMLReplacer.DIRECTIVE_BEGIN.length(), directiveText.length() - XMLDataIslandsInHTMLReplacer.DIRECTIVE_END.length());
                Pattern p = Pattern.compile(DATAISLAND_MATCHER_REGEXP, 32);
                Matcher m = p.matcher(currDataIslandXML);
                StringBuffer sb = new StringBuffer(XMLDataIslandsInHTMLReplacer.DIRECTIVE_BEGIN);
                if (m.find()) {
                    String id = m.group(2);
                    String replacement = null;
                    if (this._xmlsToReplace.get(id) != null) {
                        replacement = this._xmlsToReplace.get(id).toString();
                        if ((replacement = StringUtils.replaceString(replacement, "$", "\\$")) != null) {
                            m.appendReplacement(sb, "$1" + replacement + "$4");
                            m.appendTail(sb);
                            ++this._replacedDataIslandsCount;
                        } else {
                            sb.append(currDataIslandXML);
                        }
                    } else {
                        sb.append(currDataIslandXML);
                    }
                }
                sb.append(XMLDataIslandsInHTMLReplacer.DIRECTIVE_END);
                return sb.toString().toCharArray();
            }
            return null;
        }

        public int getReplacedXMLDataIslandsCount() {
            return this._replacedDataIslandsCount;
        }
    }
}

