/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.io.filters;

import com.ejie.r01f.io.filters.DirectiveFilterReader;
import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.log.R01FLog;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class XMLDataIslandsInHTMLParser {
    private static final transient String DIRECTIVE_BEGIN = "<!--@@@";
    private static final transient String DIRECTIVE_END = "@@@-->";

    public String[] findXMLDataIslandsInDocument(Reader r) throws IOException {
        if (r == null) {
            return null;
        }
        return this._doParseDocument(r);
    }

    public String[] findXMLDataIslandsInDocument(File f) throws IOException {
        if (f == null) {
            return null;
        }
        if (!f.exists()) {
            throw new IOException("El fichero " + f.getAbsolutePath() + " NO existe. No se pueden obtener los XMLData Islands");
        }
        FileReader fr = new FileReader(f);
        if (fr == null) {
            return null;
        }
        return this._doParseDocument(fr);
    }

    public String[] findXMLDataIslandsInDocument(String filePath) throws IOException {
        if (filePath == null) {
            return null;
        }
        File f = new File(filePath);
        return this.findXMLDataIslandsInDocument(f);
    }

    private String[] _doParseDocument(Reader r) throws IOException {
        if (r == null) {
            throw new IOException("El reader es null: No se pueden encontrar los XMLDataIslands");
        }
        DataIslandDirectiveListener directiveListener = new DataIslandDirectiveListener();
        DirectiveFilterReader directiveFilterReader = new DirectiveFilterReader(r);
        directiveFilterReader.addListener(directiveListener, DIRECTIVE_BEGIN, DIRECTIVE_END);
        int c = 0;
        while ((c = directiveFilterReader.read()) > 0) {
        }
        directiveFilterReader.close();
        return directiveListener.getXMLDataIslands();
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                XMLDataIslandsInHTMLParser diParser = new XMLDataIslandsInHTMLParser();
                String doc = "<html><head/><body><h1>DataIsland Parser</h1><!--@@@<xml id='id1'><element>el</element></xml>@@@--><p>Hola caracola</p><!--@@@<xml id='id1'><element>el55</element></xml>@@@--></body></html>";
                String[] dataIslands = diParser.findXMLDataIslandsInDocument(new StringReader(doc));
                if (dataIslands == null) continue;
                for (int i = 0; i < dataIslands.length; ++i) {
                    R01FLog.to("r01f.test").info(dataIslands[i]);
                }
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class DataIslandDirectiveListener
    implements DirectiveListener {
        private List _xmlDataIslands = null;

        DataIslandDirectiveListener() {
        }

        @Override
        public char[] processDirective(String directiveText, long index) throws IOException {
            if (directiveText.length() > XMLDataIslandsInHTMLParser.DIRECTIVE_BEGIN.length() + XMLDataIslandsInHTMLParser.DIRECTIVE_END.length()) {
                if (this._xmlDataIslands == null) {
                    this._xmlDataIslands = new ArrayList();
                }
                this._xmlDataIslands.add(directiveText.subSequence(XMLDataIslandsInHTMLParser.DIRECTIVE_BEGIN.length(), directiveText.length() - XMLDataIslandsInHTMLParser.DIRECTIVE_END.length()));
            }
            return null;
        }

        public String[] getXMLDataIslands() {
            if (this._xmlDataIslands != null) {
                return this._xmlDataIslands.toArray(new String[this._xmlDataIslands.size()]);
            }
            return null;
        }
    }
}

