/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.io.filters;

import com.ejie.r01f.io.filters.DirectiveFilterReader;
import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.log.R01FLog;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SSIProcessor {
    private static final transient String DIRECTIVE_BEGIN = "<!--#";
    private static final transient String DIRECTIVE_END = "-->";
    private int _maxDirectiveLength = 8000;

    public SSIProcessor() {
    }

    public SSIProcessor(int maxDirectiveChars) {
        this._maxDirectiveLength = maxDirectiveChars;
    }

    public String parseDocument(Reader r) throws IOException {
        int c;
        if (r == null) {
            throw new IOException("El reader es null: No se pueden anlizar las directivas SSI");
        }
        SSIDirectiveListener directiveListener = new SSIDirectiveListener();
        DirectiveFilterReader directiveFilterReader = new DirectiveFilterReader(r, this._maxDirectiveLength);
        directiveFilterReader.addListener(directiveListener, DIRECTIVE_BEGIN, DIRECTIVE_END);
        StringWriter sw = new StringWriter();
        do {
            c = directiveFilterReader.read();
            sw.write(c);
        } while (c > 0);
        directiveFilterReader.close();
        R01FLog.to("r01f.test").info(sw.toString());
        return sw.toString();
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                String doc = "<html><body><!--#include virtual='/as/as.html'--></body></html>";
                HashMap<String, String> newDataIslandsValues = new HashMap<String, String>();
                newDataIslandsValues.put("r01gPageDef", "[nuevo XML del dataIsland id1]");
                newDataIslandsValues.put("id2", "[nuevo XML del dataIsland id2]");
                SSIProcessor diReplacer = new SSIProcessor(50000);
                diReplacer.parseDocument(new StringReader(doc));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class SSIDirective {
        public long index = -1L;
        public String fullText = "";
        public boolean isValid = false;
        public boolean isFile = false;
        public boolean isVirtual = false;
        public String includedURI = null;

        public SSIDirective() {
        }

        public SSIDirective(String directiveText) {
            this.fullText = directiveText;
            this.parsePortalSSIDirective();
        }

        public String toString() {
            return "{" + this.index + "} " + this.fullText + "\r\n" + " \tvalid='" + this.isValid + "'\r\n\tvirtual='" + this.isVirtual + "'\r\n\tfile='" + this.isFile + "'\r\n\tincludedURI='" + this.includedURI + "'";
        }

        public void parsePortalSSIDirective() {
            String patternStr = null;
            Pattern p = null;
            Matcher m = null;
            patternStr = "^<!--#\\s*include\\s+(virtual|file)=(\"|').*(\"|')\\s*-->$";
            p = Pattern.compile(patternStr);
            m = p.matcher(this.fullText);
            this.isValid = m.find();
            if (this.isValid) {
                patternStr = "(\"|').*(\"|')";
                p = Pattern.compile(patternStr);
                m = p.matcher(this.fullText);
                m.find();
                String uri = m.group();
                this.includedURI = uri.substring(1, uri.length() - 1);
                if (this.fullText.indexOf("virtual") > 0) {
                    this.isVirtual = true;
                } else {
                    this.isFile = true;
                }
            }
        }
    }

    class SSIDirectiveListener
    implements DirectiveListener {
        public SSIDirectiveListener() {
        }

        public SSIDirectiveListener(String docRoot) {
            this();
        }

        @Override
        public char[] processDirective(String directiveText, long index) throws IOException {
            SSIDirective directive = new SSIDirective(directiveText);
            if (directive.isValid) {
                return "aaaaa".toCharArray();
            }
            return new char[0];
        }
    }
}

