/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.io.filters;

import com.ejie.r01f.io.filters.BufferEventListener;
import com.ejie.r01f.io.filters.BufferOverflowException;
import com.ejie.r01f.log.R01FLog;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CircularCharBuffer
implements CharSequence {
    private static final int DEFAULT_SIZE = 1024;
    public static final int INFINITE_SIZE = -1;
    protected char[] buffer;
    protected volatile int readPosition = 0;
    protected volatile int writePosition = 0;
    protected volatile int markPosition = 0;
    protected volatile int markMaxSize = 0;
    protected volatile boolean infinite = false;
    protected boolean blockingWrite = true;
    protected Reader reader = new CircularCharBufferReader();
    protected boolean readerClosed = false;
    protected Writer writer = new CircularCharBufferWriter();
    protected boolean writerClosed = false;
    protected BufferEventListener eventListener = null;

    public CircularCharBuffer() {
        this(1024, true);
    }

    public CircularCharBuffer(int newSize) {
        this(newSize, true);
    }

    public CircularCharBuffer(boolean newBlockingWrite) {
        this(1024, newBlockingWrite);
    }

    public CircularCharBuffer(int newSize, boolean newBlockingWrite) {
        if (newSize == -1) {
            this.buffer = new char[1024];
            this.infinite = true;
        } else {
            this.buffer = new char[newSize];
            this.infinite = false;
        }
        this.blockingWrite = newBlockingWrite;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.reader;
    }

    public BufferEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(BufferEventListener theEventListener) {
        this.eventListener = theEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            this.readPosition = 0;
            this.writePosition = 0;
            this.markPosition = 0;
            this.readerClosed = false;
            this.writerClosed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this._available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.getAvailable() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpaceLeft() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this._spaceLeft();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.getSpaceLeft() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.buffer.length;
        }
    }

    public int getPositionFromLineal(int linealPosition) {
        return this._deLinearizeBufferPosition(linealPosition);
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("CircularCharBuffer.charAt(): The index " + index + " of the specified char is either negative");
        }
        int pos = this._deLinearizeBufferPosition(index);
        if (pos < this.readPosition && this.writePosition > this.readPosition) {
            throw new IndexOutOfBoundsException("CircularCharBuffer.charAt(): The index " + index + " of the specified char is out of bounds");
        }
        return this.buffer[pos];
    }

    @Override
    public int length() {
        return this.getAvailable();
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        int length = this.length();
        if (start < 0 || end < 0 || start > end || end > length) {
            throw new IndexOutOfBoundsException("CircularCharBuffer.subSequence(): The start or end values are not valid, either are negative, start > end or end > length()");
        }
        int startInBuff = this._deLinearizeBufferPosition(start);
        int endInBuff = this._deLinearizeBufferPosition(end);
        StringBuffer outCharSeq = new StringBuffer();
        if (endInBuff > startInBuff) {
            outCharSeq.append(this.buffer, startInBuff, end - start);
        } else {
            outCharSeq.append(this.buffer, startInBuff, this.buffer.length - startInBuff);
            outCharSeq.append(this.buffer, 0, end - start - (this.buffer.length - startInBuff));
        }
        return outCharSeq;
    }

    @Override
    public String toString() {
        char[] sortedBuffer = new char[this.buffer.length];
        System.arraycopy(this.buffer, this.readPosition, sortedBuffer, 0, this.buffer.length - this.readPosition);
        if (this.readPosition != 0) {
            System.arraycopy(this.buffer, 0, sortedBuffer, this.buffer.length - this.readPosition, this.readPosition);
        }
        return new String(sortedBuffer);
    }

    public String toString(boolean onlyReadAvaliable) {
        if (!onlyReadAvaliable) {
            return this.toString();
        }
        char[] sortedBuffer = new char[this.writePosition > this.readPosition ? this.writePosition - this.readPosition : this.writePosition + this.buffer.length - this.readPosition];
        if (this.writePosition > this.readPosition) {
            System.arraycopy(this.buffer, this.readPosition, sortedBuffer, 0, this.writePosition - this.readPosition);
        } else {
            System.arraycopy(this.buffer, this.readPosition, sortedBuffer, 0, this.buffer.length - this.readPosition);
            System.arraycopy(this.buffer, 0, sortedBuffer, this.buffer.length - this.readPosition, this.writePosition);
        }
        return new String(sortedBuffer);
    }

    private int _deLinearizeBufferPosition(int position) {
        int pos = this.readPosition + position;
        if (pos >= this.buffer.length) {
            pos = position - (this.buffer.length - this.readPosition);
        }
        return pos;
    }

    private void _resize(int newLength) {
        char[] newBuffer = new char[newLength];
        int marked = this._marked();
        int available = this._available();
        if (this.markPosition <= this.writePosition) {
            int length = this.writePosition - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, newBuffer, 0, length);
        } else {
            int length1 = this.buffer.length - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, newBuffer, 0, length1);
            int length2 = this.writePosition;
            System.arraycopy(this.buffer, 0, newBuffer, length1, length2);
        }
        this.buffer = newBuffer;
        this.markPosition = 0;
        this.readPosition = marked;
        this.writePosition = marked + available;
    }

    private int _spaceLeft() {
        if (this.writePosition < this.markPosition) {
            return this.markPosition - this.writePosition - 1;
        }
        return this.buffer.length - 1 - (this.writePosition - this.markPosition);
    }

    private int _available() {
        if (this.readPosition <= this.writePosition) {
            return this.writePosition - this.readPosition;
        }
        return this.buffer.length - (this.readPosition - this.writePosition);
    }

    private int _marked() {
        if (this.markPosition <= this.readPosition) {
            return this.readPosition - this.markPosition;
        }
        return this.buffer.length - (this.markPosition - this.readPosition);
    }

    private void _ensureMark() {
        if (this._marked() >= this.markMaxSize) {
            this.markPosition = this.readPosition;
            this.markMaxSize = 0;
        }
    }

    public static void main(String[] args) {
        try {
            String srcStr = "<!--:************************************************************:--><!--: Euskadi.net: Eusko Jaurlaritza - Gobierno Vasco            :--><!--: Created by:                                                :--><!--:     EJIE, S.A. Eusko Jaurlaritzaren Informatiko Elkartea   :--><!--:     Avda. Mediterraneo, 3                                  :--><!--:     Vitoria-Gasteiz                                        :--><!--:************************************************************:--><!--:============================================================:--><!--:                     PAGE XML DESCRIPTOR                    :--><!--:============================================================:--><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es\"><head>   <!-- Directiva para la previsualizaci\u00f3n de la plantilla, se borrar\u00e1 de las p\u00e1ginas -->      <!-- Area visual que contiene parametros del head en cada idioma:           title           description         metas         Este VA es OBLIGATORIO!!!! y tiene que estar en la seccion HEAD   -->         <title>Euskadi.net: TestPage</title>        <!-- **** MetaTags **** -->            <META name=\"Publisher\" content=\"Ejie\" />        <!-- **** JavaScript for the PageTags **** -->        <script type='text/javascript'>              var r01gIsAdminPage='false';              var r01gLang='<!--#echo var='LANG'-->';              var r01gPortalCode='r33';              var r01gPageCode='containe';        </script>                                       </head><body>   <h1>(Init) R01HProxyWar Test Page</h1>  <hr />  <!--#include virtual='$APPEXT'-->   <hr />  <h1>(End) R01HProxyWar Test Page</h1></body></html>";
            StringReader srcReader = new StringReader(srcStr);
            StringWriter outWriter = new StringWriter();
            int bufferSize = 45;
            int initOffset = 0;
            CircularCharBuffer circularBuffer = new CircularCharBuffer(bufferSize, false);
            circularBuffer.writePosition = initOffset;
            circularBuffer.readPosition = initOffset;
            circularBuffer.markPosition = initOffset;
            Writer circularBufferWriter = circularBuffer.getWriter();
            circularBuffer.setEventListener(new BufferEventListener(){

                @Override
                public void bufferEmpty() {
                    R01FLog.to("r01f.test").info("\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8Buffer vacio!!!");
                }

                @Override
                public void bufferFull() {
                    R01FLog.to("r01f.test").info("\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8Buffer lleno!!!");
                }
            });
            int charsReaded = -1;
            int readSize = bufferSize - 10;
            char[] buff = new char[readSize];
            int initReadPosition = 0;
            boolean initWritePosition = false;
            while ((charsReaded = srcReader.read(buff, 0, readSize)) > 0) {
                initReadPosition = circularBuffer.readPosition;
                circularBufferWriter.write(buff, 0, charsReaded);
                Pattern p = Pattern.compile("<!--#.*-->");
                int Matchersize = circularBuffer.toString(true).length() < circularBuffer.buffer.length && circularBuffer.toString(true).length() < buff.length ? circularBuffer.toString(true).length() : (circularBuffer.buffer.length < buff.length ? circularBuffer.buffer.length : buff.length);
                Matcher m = p.matcher(circularBuffer.toString(true).substring(0, Matchersize));
                R01FLog.to("r01f.test").info("Buscando patr\u00f3n completo en " + circularBuffer.toString(true).substring(0, Matchersize));
                int end = 0;
                while (m.find(end)) {
                    R01FLog.to("r01f.test").info("####### Localizado patr\u00f3n completo. #######");
                    outWriter.write(circularBuffer.toString(true).substring(end, m.start()));
                    R01FLog.to("r01f.test").info("1 \u00b7 Escribe: " + circularBuffer.toString(true).substring(end, m.start()));
                    outWriter.write(" [" + circularBuffer.subSequence(m.start(), m.end()) + "] ");
                    R01FLog.to("r01f.test").info("2 \u00b7 Escribe:  [" + circularBuffer.subSequence(m.start(), m.end()) + "] ");
                    end = m.end();
                }
                p = Pattern.compile("<");
                m.reset();
                m = p.matcher(circularBuffer.toString(true).substring(0, Matchersize));
                while (m.find(end + 1)) {
                    outWriter.write(circularBuffer.toString(true).substring(end, m.start()));
                    R01FLog.to("r01f.test").info("3 \u00b7 Escribe: " + circularBuffer.toString(true).substring(end, m.start()));
                    end = m.end() - 1;
                }
                if (end == 0) {
                    outWriter.write(circularBuffer.toString(true).substring(end));
                    R01FLog.to("r01f.test").info("4 \u00b7 Escribe: " + circularBuffer.toString(true).substring(end));
                }
                circularBuffer.markPosition = circularBuffer.writePosition;
                circularBuffer.readPosition = circularBuffer.getPositionFromLineal(end);
                if (initReadPosition == circularBuffer.readPosition) {
                    circularBuffer.writePosition = 0;
                    circularBuffer.markPosition = 0;
                    circularBuffer.readPosition = 0;
                    Arrays.fill(circularBuffer.buffer, '\u0000');
                }
                int n = end == 0 ? (circularBuffer.buffer.length > buff.length ? buff.length : circularBuffer.buffer.length) : (readSize = end > buff.length ? buff.length : end);
                if (circularBuffer._spaceLeft() < readSize) {
                    readSize = circularBuffer._spaceLeft();
                    R01FLog.to("r01f.test").info(" ##### C\u00c1LCULO DE CARACTERES DE LECTURA DEL SIGUIENTE CICLO ERR\u00d3NEO ##### ");
                }
                Arrays.fill(buff, '\u0000');
            }
            outWriter.write(circularBuffer.toString(true));
            R01FLog.to("r01f.test").info(outWriter.toString());
            outWriter.close();
            circularBufferWriter.close();
        }
        catch (IOException ioEx) {
            R01FLog.to("r01f.test").info("Exception!!!" + ioEx);
            R01FLog.to("r01f.test").info(ioEx.getMessage());
        }
    }

    protected class CircularCharBufferWriter
    extends Writer {
        protected CircularCharBufferWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (!CircularCharBuffer.this.writerClosed) {
                    this.flush();
                }
                CircularCharBuffer.this.writerClosed = true;
            }
        }

        @Override
        public void flush() throws IOException {
            if (CircularCharBuffer.this.writerClosed) {
                throw new IOException("CircularCharBuffer: Writer has been closed; cannot flush a closed Writer.");
            }
            if (CircularCharBuffer.this.readerClosed) {
                throw new IOException("CircularCharBuffer: Buffer closed by Reader; cannot flush.");
            }
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len > 0) {
                int written;
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.writerClosed) {
                        throw new IOException("CircularCharBuffer: Writer has been closed; cannot write to a closed Writer.");
                    }
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("CircularCharBuffer: Buffer closed by Reader; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularCharBuffer.this._spaceLeft();
                    while (CircularCharBuffer.this.infinite && spaceLeft < len) {
                        CircularCharBuffer.this._resize(CircularCharBuffer.this.buffer.length * 2);
                        spaceLeft = CircularCharBuffer.this._spaceLeft();
                    }
                    if (!CircularCharBuffer.this.blockingWrite && spaceLeft < len) {
                        throw new BufferOverflowException("CircularCharBuffer: CircularCharBuffer is full; cannot write " + len + " characters");
                    }
                    int realLen = Math.min(len, spaceLeft);
                    int firstLen = Math.min(realLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.writePosition);
                    int secondLen = Math.min(realLen - firstLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.markPosition - 1);
                    written = firstLen + secondLen;
                    if (firstLen > 0) {
                        System.arraycopy(cbuf, off, CircularCharBuffer.this.buffer, CircularCharBuffer.this.writePosition, firstLen);
                    }
                    if (secondLen > 0) {
                        System.arraycopy(cbuf, off + firstLen, CircularCharBuffer.this.buffer, 0, secondLen);
                        CircularCharBuffer.this.writePosition = secondLen;
                    } else {
                        CircularCharBuffer.this.writePosition += written;
                    }
                    if (CircularCharBuffer.this.writePosition == CircularCharBuffer.this.buffer.length) {
                        CircularCharBuffer.this.writePosition = 0;
                    }
                    off += written;
                }
                if ((len -= written) <= 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    throw new IOException("CircularCharBuffer: Waiting for available space in buffer interrupted: " + ex.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int c) throws IOException {
            boolean written = false;
            while (!written) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.writerClosed) {
                        throw new IOException("CircularCharBuffer: Writer has been closed; cannot write to a closed Writer.");
                    }
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("CircularCharBuffer: Buffer closed by Reader; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularCharBuffer.this._spaceLeft();
                    while (CircularCharBuffer.this.infinite && spaceLeft < 1) {
                        CircularCharBuffer.this._resize(CircularCharBuffer.this.buffer.length * 2);
                        spaceLeft = CircularCharBuffer.this._spaceLeft();
                    }
                    if (spaceLeft < 1 && CircularCharBuffer.this.eventListener != null) {
                        CircularCharBuffer.this.eventListener.bufferFull();
                        spaceLeft = CircularCharBuffer.this._spaceLeft();
                    }
                    if (!CircularCharBuffer.this.blockingWrite && spaceLeft < 1) {
                        throw new BufferOverflowException("CircularCharBuffer: CircularCharBuffer is full; cannot write 1 character");
                    }
                    if (spaceLeft > 0) {
                        CircularCharBuffer.this.buffer[CircularCharBuffer.this.writePosition] = (char)c;
                        ++CircularCharBuffer.this.writePosition;
                        if (CircularCharBuffer.this.writePosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.writePosition = 0;
                        }
                        written = true;
                    }
                }
                if (written) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    throw new IOException("CircularCharBuffer: Waiting for available space in buffer interrupted: " + ex.getMessage());
                }
            }
        }

        @Override
        public void write(String str) throws IOException {
            this.write(str, 0, str.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(String str, int off, int len) throws IOException {
            while (len > 0) {
                int written;
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    int i;
                    if (CircularCharBuffer.this.writerClosed) {
                        throw new IOException("CircularCharBuffer: Writer has been closed; cannot write to a closed Writer.");
                    }
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("CircularCharBuffer: Buffer closed by Reader; cannot write to a closed buffer.");
                    }
                    int spaceLeft = CircularCharBuffer.this._spaceLeft();
                    while (CircularCharBuffer.this.infinite && spaceLeft < len) {
                        CircularCharBuffer.this._resize(CircularCharBuffer.this.buffer.length * 2);
                        spaceLeft = CircularCharBuffer.this._spaceLeft();
                    }
                    if (spaceLeft < 1 && CircularCharBuffer.this.eventListener != null) {
                        CircularCharBuffer.this.eventListener.bufferFull();
                        spaceLeft = CircularCharBuffer.this._spaceLeft();
                    }
                    if (!CircularCharBuffer.this.blockingWrite && spaceLeft < len) {
                        throw new BufferOverflowException("CircularCharBuffer: CircularCharBuffer is full; cannot write " + len + " characters");
                    }
                    int realLen = Math.min(len, spaceLeft);
                    int firstLen = Math.min(realLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.writePosition);
                    int secondLen = Math.min(realLen - firstLen, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.markPosition - 1);
                    written = firstLen + secondLen;
                    for (i = 0; i < firstLen; ++i) {
                        CircularCharBuffer.this.buffer[CircularCharBuffer.this.writePosition + i] = str.charAt(off + i);
                    }
                    if (secondLen > 0) {
                        for (i = 0; i < secondLen; ++i) {
                            CircularCharBuffer.this.buffer[i] = str.charAt(off + firstLen + i);
                        }
                        CircularCharBuffer.this.writePosition = secondLen;
                    } else {
                        CircularCharBuffer.this.writePosition += written;
                    }
                    if (CircularCharBuffer.this.writePosition == CircularCharBuffer.this.buffer.length) {
                        CircularCharBuffer.this.writePosition = 0;
                    }
                    off += written;
                }
                if ((len -= written) <= 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    throw new IOException("CircularCharBuffer: Waiting for available space in buffer interrupted: " + ex.getMessage());
                }
            }
        }
    }

    protected class CircularCharBufferReader
    extends Reader {
        protected CircularCharBufferReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                CircularCharBuffer.this.readerClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mark(int readAheadLimit) throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (CircularCharBuffer.this.readerClosed) {
                    throw new IOException("CircularCharBuffer: Reader has been closed; cannot mark a closed Reader.");
                }
                if (CircularCharBuffer.this.buffer.length - 1 <= readAheadLimit) {
                    throw new IOException("CircularCharBuffer: Cannot mark stream, readAheadLimit bigger than buffer size.");
                }
                CircularCharBuffer.this.markMaxSize = readAheadLimit;
                CircularCharBuffer.this.markPosition = CircularCharBuffer.this.readPosition;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            while (true) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("CircularCharBuffer: Reader has been closed; cannot read from a closed Reader.");
                    }
                    int available = CircularCharBuffer.this._available();
                    if (available <= 0 && CircularCharBuffer.this.eventListener != null) {
                        CircularCharBuffer.this.eventListener.bufferEmpty();
                        available = CircularCharBuffer.this._available();
                    }
                    if (available > 0) {
                        char result = CircularCharBuffer.this.buffer[CircularCharBuffer.this.readPosition];
                        ++CircularCharBuffer.this.readPosition;
                        if (CircularCharBuffer.this.readPosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.readPosition = 0;
                        }
                        CircularCharBuffer.this._ensureMark();
                        return result;
                    }
                    if (CircularCharBuffer.this.writerClosed) {
                        return -1;
                    }
                }
                try {
                    R01FLog.to("r01f.test").info("...reader waiting for writer to fill with data..");
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    throw new IOException("CircularCharBuffer: Blocking read operation interrupted: " + ex.getMessage());
                }
            }
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            while (true) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("CircularCharBuffer: Reader has been closed; cannot read from a closed Reader.");
                    }
                    int available = CircularCharBuffer.this._available();
                    if (available <= 0 && CircularCharBuffer.this.eventListener != null) {
                        CircularCharBuffer.this.eventListener.bufferEmpty();
                        available = CircularCharBuffer.this._available();
                    }
                    if (available > 0) {
                        int length = Math.min(len, available);
                        int firstLen = Math.min(length, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.readPosition);
                        int secondLen = length - firstLen;
                        System.arraycopy(CircularCharBuffer.this.buffer, CircularCharBuffer.this.readPosition, cbuf, off, firstLen);
                        if (secondLen > 0) {
                            System.arraycopy(CircularCharBuffer.this.buffer, 0, cbuf, off + firstLen, secondLen);
                            CircularCharBuffer.this.readPosition = secondLen;
                        } else {
                            CircularCharBuffer.this.readPosition += length;
                        }
                        if (CircularCharBuffer.this.readPosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.readPosition = 0;
                        }
                        CircularCharBuffer.this._ensureMark();
                        return length;
                    }
                    if (CircularCharBuffer.this.writerClosed) {
                        return -1;
                    }
                }
                try {
                    R01FLog.to("r01f.test").info("...reader waiting for writer to fill with data..");
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    throw new IOException("CircularCharBuffer: Blocking read operation interrupted: " + ex.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ready() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (CircularCharBuffer.this.readerClosed) {
                    throw new IOException("CircularCharBuffer: Reader has been closed, it is not ready.");
                }
                return CircularCharBuffer.this._available() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() throws IOException {
            CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
            synchronized (circularCharBuffer) {
                if (CircularCharBuffer.this.readerClosed) {
                    throw new IOException("CircularCharBuffer: Reader has been closed; cannot reset a closed Reader.");
                }
                CircularCharBuffer.this.readPosition = CircularCharBuffer.this.markPosition;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException, IllegalArgumentException {
            while (true) {
                CircularCharBuffer circularCharBuffer = CircularCharBuffer.this;
                synchronized (circularCharBuffer) {
                    if (CircularCharBuffer.this.readerClosed) {
                        throw new IOException("CircularCharBuffer: Reader has been closed; cannot skip characters on a closed Reader.");
                    }
                    int available = CircularCharBuffer.this._available();
                    if (available > 0) {
                        int firstLen;
                        int length = Math.min((int)n, available);
                        int secondLen = length - (firstLen = Math.min(length, CircularCharBuffer.this.buffer.length - CircularCharBuffer.this.readPosition));
                        CircularCharBuffer.this.readPosition = secondLen > 0 ? secondLen : (CircularCharBuffer.this.readPosition += length);
                        if (CircularCharBuffer.this.readPosition == CircularCharBuffer.this.buffer.length) {
                            CircularCharBuffer.this.readPosition = 0;
                        }
                        CircularCharBuffer.this._ensureMark();
                        return length;
                    }
                    if (CircularCharBuffer.this.writerClosed) {
                        return 0L;
                    }
                }
                try {
                    R01FLog.to("r01f.test").info("...reader waiting for writer to fill with data..");
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    throw new IOException("CircularCharBuffer: Blocking read operation interrupted: " + ex.getMessage());
                }
            }
        }
    }
}

