/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.guids;

import com.ejie.r01f.guids.MaxForKeyReachedException;
import java.io.Serializable;

public class Key
implements Serializable {
    private static final long serialVersionUID = 2379521800350045150L;
    private byte[] _value = null;
    private static byte MAX_VALUE = (byte)-1;
    private static byte MIN_VALUE = 0;

    public Key(int newLength) {
        this._value = new byte[newLength];
        this.setToZero();
    }

    public Key(String inStr) {
        this._value = this._fromStringOfHexToByteArray(inStr);
    }

    public void setToZero() {
        for (int i = 0; i < this._value.length; ++i) {
            this._value[i] = MIN_VALUE;
        }
    }

    public void increment() throws MaxForKeyReachedException {
        this._value = this._increment(this._value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._value.length; ++i) {
            String hex = "0" + Integer.toHexString(this._value[i]);
            String end = hex.substring(hex.length() - 2);
            sb.append(end.toUpperCase());
        }
        return sb.toString();
    }

    private byte[] _increment(byte[] array) throws MaxForKeyReachedException {
        return this._incrementElement(array, 0);
    }

    private byte[] _incrementElement(byte[] array, int index) throws MaxForKeyReachedException {
        if (array[index] == MAX_VALUE) {
            if (index == array.length - 1) {
                throw new MaxForKeyReachedException();
            }
            this._incrementElement(array, index + 1);
            array[index] = MIN_VALUE;
        } else {
            int n = index;
            array[n] = (byte)(array[n] + 1);
        }
        return array;
    }

    private byte[] _fromStringOfHexToByteArray(String str) {
        int size = str.length() / 2;
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            String chunk = str.substring(i * 2, i * 2 + 2);
            b[i] = (byte)Integer.parseInt(chunk, 16);
        }
        return b;
    }
}

