/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.guids;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.util.Map;
import java.util.Properties;

public class GUIDDispenserDef {
    protected String appCode = "r01ft";
    protected String sequenceName = null;
    protected String uniqueID = null;
    protected String dispenserClass = null;
    protected Properties properties = null;

    public GUIDDispenserDef() {
    }

    public GUIDDispenserDef(String newAppCode, String newSequenceName) {
        this();
        this.loadConfig(newAppCode, newSequenceName);
    }

    public GUIDDispenserDef(String newAppCode, String newSequenceName, String newUniqueID, String newGeneratorClass, Properties newProps) {
        this();
        this.appCode = newAppCode;
        this.sequenceName = newSequenceName;
        this.uniqueID = newUniqueID;
        this.dispenserClass = newGeneratorClass;
        this.properties = newProps;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String theAppCode) {
        this.appCode = theAppCode;
    }

    public String composeDebugInfo() {
        StringBuffer sb = new StringBuffer("");
        sb.append("\tappCode: " + (this.appCode == null ? "null" : this.appCode) + "\r\n");
        sb.append("\tsequenceName: " + (this.sequenceName == null ? "null" : this.sequenceName) + "\r\n");
        sb.append("\tuniqueId: " + (this.uniqueID == null ? "null" : this.uniqueID) + "\r\n");
        sb.append("\tdispenserClass: " + (this.dispenserClass == null ? "null" : this.dispenserClass) + "\r\n");
        if (this.properties != null) {
            Map.Entry<Object, Object> me2 = null;
            for (Map.Entry<Object, Object> me2 : this.properties.entrySet()) {
                sb.append("\t\t" + me2.getKey() + ": " + me2.getValue() + "\r\n");
            }
        }
        return sb.toString();
    }

    public void loadConfig(String theAppCode, String theSequenceId) {
        R01FLog.to("r01f.guid").info("Cargando la configuracion del GUID > appCode: " + theAppCode + " sequenceId: " + theSequenceId);
        if (theAppCode == null || theSequenceId == null) {
            throw new IllegalArgumentException("No se puede cargar la configuracion del GUID ya que el codigo de aplicacion o el identificador de secuencia es null");
        }
        this.appCode = theAppCode;
        this.sequenceName = theSequenceId;
        this.uniqueID = XMLProperties.getString(theAppCode, "guidGenerator/sequence[@id='" + theSequenceId + "']/uniqueId");
        if (this.uniqueID == null) {
            R01FLog.to("r01f.guid").warning("No se ha definido la propiedad guidGenerator/sequence[@id='" + theSequenceId + "']/uniqueId en el fichero de properties de la aplicacion " + theAppCode + ". Se toma un valor '0-unknown'");
            this.uniqueID = "0-unknown";
        }
        this.dispenserClass = XMLProperties.getString(theAppCode, "guidGenerator/sequence[@id='" + theSequenceId + "']/dispenserClass");
        if (this.dispenserClass == null) {
            R01FLog.to("r01f.guid").warning("No se ha definido la propiedad guidGenerator/sequence[@id='" + theSequenceId + "']/dispenserClass en el fichero de properties de la aplicacion " + theAppCode + ". Se toma un valor 'com.ejie.r01f.guids.GUIDGenerator'");
            this.dispenserClass = "com.ejie.r01f.guids.GUIDGenerator";
        }
        this.properties = XMLProperties.getProperties(theAppCode, "guidGenerator/sequence[@id='" + theSequenceId + "']/properties");
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                GUIDDispenserDef def = new GUIDDispenserDef("r01ft", "test");
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

