/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.file;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

public abstract class ResourcesLoader {
    private static final int RESOURCELOADER_FILESYSTEM = 0;
    private static final int RESOURCELOADER_CLASSPATH = 1;
    private static int RESOURCELOADER = 0;

    public static InputStream getResourceFileAsStream(String filePathName) throws FileNotFoundException {
        InputStream fileIS = null;
        if (RESOURCELOADER == 0) {
            fileIS = new FileInputStream(filePathName);
        } else if (RESOURCELOADER == 1) {
            fileIS = ResourcesLoader.class.getResourceAsStream(filePathName);
            if (fileIS == null) {
                R01FLog.to("r01f.io").warning("NO se ha podio cargar utilizando classpathloader el fichero " + filePathName + "... se va a intentar acceder directamente al fichero");
                fileIS = new FileInputStream(filePathName);
            }
            if (fileIS == null) {
                throw new FileNotFoundException("El tipo de cargador de los ficheros NO es valido!!!");
            }
        } else {
            throw new FileNotFoundException("El tipo de cargador de los ficheros NO es valido!!!");
        }
        return fileIS;
    }

    public static File getResourceFileAsFile(String filePathName) throws FileNotFoundException {
        File fileIS = null;
        if (RESOURCELOADER == 0) {
            fileIS = new File(filePathName);
        } else if (RESOURCELOADER == 1) {
            URL url = ResourcesLoader.class.getResource(filePathName);
            if (url == null) {
                if (fileIS == null) {
                    R01FLog.to("r01f.io").warning("NO se ha podio cargar utilizando classpathloader el fichero " + filePathName + "... se va a intentar acceder directamente al fichero");
                    fileIS = new File(filePathName);
                }
                if (fileIS == null) {
                    throw new FileNotFoundException("No se puede localizar el fichero [" + filePathName + "] en el classpath!!!");
                }
            } else {
                String urlFile = url.getFile();
                fileIS = new File(urlFile);
            }
        } else {
            throw new FileNotFoundException("El tipo de cargador de los ficheros NO es valido!!!");
        }
        return fileIS;
    }

    static {
        String loader = XMLProperties.get("r01ft", "resourcesLoader/resourceFilesLoader");
        if (loader != null && loader.equals("CLASSPATH")) {
            RESOURCELOADER = 1;
        } else if (loader != null && loader.equals("FILESYSTEM")) {
            RESOURCELOADER = 0;
        } else {
            R01FLog.to("r01f.io").warning("La propiedad resourcesLoader/mapFilesLoader del fichero r01f.properties.xml NO es valida. Se toma el loader de ficheros de recursos FILESYSTEM!!!");
        }
        R01FLog.to("r01f.io").info("\r\n\r\n\r\nADVERTENCIA:\r\n\tLos ficheros de recursos se est\u00e1n cargando " + (RESOURCELOADER == 1 ? "del classPath" : "de forma absoluta del disco") + "\r\n\tSe puede cambiar este comportamiento estableciendo la variable resourcesLoader/mapFilesLoader del fichero r01f.properties.xml\r\n\r\n\r\n");
    }
}

