/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.file;

import com.ejie.r01f.file.DirectoryExtractor;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public abstract class FileUtils {
    private static final boolean DEBUG = R01FLog.getLogLevel("r01f.test").intValue() != Level.OFF.intValue();
    public static final String[] FORMAT_BYTES = new String[]{" B", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendToFile(File file, InputStream fileContentsIS, boolean createFileIfNotExists) throws IOException {
        if (!file.exists() && !createFileIfNotExists) {
            throw new IOException("El fichero " + file.getCanonicalPath() + " NO existe!. Se ha llamado al metodo appendToFile indicando que NO se cree el fichero si este no existe!!!");
        }
        String[] pathSplitted = FileUtils.splitFilePath(file.getCanonicalPath());
        if (pathSplitted.length > 1) {
            String[] dstFolderPath = new String[pathSplitted.length - 1];
            System.arraycopy(pathSplitted, 0, dstFolderPath, 0, pathSplitted.length - 1);
            File dstFolder = new File(FileUtils.composePathFromPathSplitted(dstFolderPath));
            if (!dstFolder.exists()) {
                dstFolder.mkdirs();
            }
        }
        FileOutputStream out = new FileOutputStream(file, true);
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = fileContentsIS.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            fileContentsIS.close();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncate(File file, long length) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file, true);
            out.getChannel().truncate(length);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    public static String[] splitFileNameAndExtension(String fileFullName) {
        if (fileFullName == null) {
            return null;
        }
        if (fileFullName.length() == 0) {
            return new String[]{""};
        }
        int dotPosition = fileFullName.lastIndexOf(46);
        String[] outArray = new String[]{null, null};
        if (dotPosition > 0) {
            outArray[0] = fileFullName.substring(0, dotPosition);
            outArray[1] = fileFullName.substring(dotPosition + 1);
        } else {
            outArray[0] = fileFullName;
        }
        return outArray;
    }

    public static String[] splitFilePath(String fileFullPath) {
        if (fileFullPath == null) {
            return null;
        }
        if (fileFullPath.length() == 0) {
            return new String[]{""};
        }
        StringTokenizer st = new StringTokenizer(fileFullPath, File.separator);
        String[] outPath = new String[st.countTokens()];
        int i = 0;
        do {
            outPath[i++] = st.nextToken();
        } while (st.hasMoreTokens());
        return outPath;
    }

    public static String composePathFromPathSplitted(String[] pathSplitted) {
        if (pathSplitted == null) {
            return null;
        }
        StringBuffer outPath = new StringBuffer("");
        for (int i = 0; i < pathSplitted.length; ++i) {
            outPath.append(pathSplitted[i]);
            outPath.append('/');
        }
        return outPath.toString();
    }

    public static void renameFile(String srcFile, String destFile) throws IOException {
        FileUtils.renameFile(new File(srcFile), new File(destFile));
    }

    public static void renameFile(File srcFile, File destFile) throws IOException {
        if (srcFile.exists()) {
            srcFile.renameTo(destFile);
        }
    }

    public static void copyFile(File srcFile, File dstFile) throws IOException {
        FileUtils.copyFile(srcFile, dstFile, false);
    }

    public static void copyFile(File srcFile, File dstFile, boolean forceDstRoot) throws IOException {
        if (srcFile.isDirectory()) {
            if (!dstFile.exists()) {
                dstFile.mkdirs();
            }
        } else {
            String[] pathSplitted = FileUtils.splitFilePath(dstFile.getCanonicalPath());
            if (pathSplitted.length > 1) {
                File dstFolder;
                String[] dstFolderPath = new String[pathSplitted.length - 1];
                System.arraycopy(pathSplitted, 0, dstFolderPath, 0, pathSplitted.length - 1);
                String strPath = (forceDstRoot ? "/" : "") + FileUtils.composePathFromPathSplitted(dstFolderPath);
                if (forceDstRoot) {
                    strPath = strPath.replaceFirst("//", "/");
                }
                if (!(dstFolder = new File(strPath)).exists()) {
                    dstFolder.mkdirs();
                }
            }
        }
        if (srcFile.isDirectory()) {
            File[] children = srcFile.listFiles();
            for (int i = 0; i < children.length; ++i) {
                String name = children[i].getName();
                File destChild = new File(dstFile.getCanonicalPath() + File.separator + name);
                if (children[i].isDirectory()) {
                    FileUtils.copyFile(children[i], destChild);
                    continue;
                }
                FileUtils.copySingleFile(children[i], destChild);
            }
        } else {
            FileUtils.copySingleFile(srcFile, dstFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySingleFile(File srcFile, File dstFile) throws IOException {
        if (srcFile.isDirectory()) {
            throw new IOException("Esta funcion solo copia ficheros, NO copia directorios!");
        }
        FileInputStream in = new FileInputStream(srcFile);
        FileOutputStream out = new FileOutputStream(dstFile);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(File file, InputStream fileContentsIS) throws IOException {
        String[] pathSplitted = FileUtils.splitFilePath(file.getCanonicalPath());
        if (pathSplitted.length > 1) {
            String[] dstFolderPath = new String[pathSplitted.length - 1];
            System.arraycopy(pathSplitted, 0, dstFolderPath, 0, pathSplitted.length - 1);
            File dstFolder = new File(FileUtils.composePathFromPathSplitted(dstFolderPath));
            if (!dstFolder.exists()) {
                dstFolder.mkdirs();
            }
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = fileContentsIS.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            fileContentsIS.close();
            ((OutputStream)out).close();
        }
    }

    public static void writeToFile(File file, StringBuffer buffer, boolean createFileIfNotExists) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
        FileUtils.appendToFile(file, bis, createFileIfNotExists);
    }

    public static void writeToFile(File file, String str, boolean createFileIfNotExists) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes("UTF-8"));
        FileUtils.appendToFile(file, bis, createFileIfNotExists);
    }

    public static boolean delete(File resource) throws IOException {
        if (resource.isDirectory()) {
            File[] childFiles = resource.listFiles();
            for (int i = 0; i < childFiles.length; ++i) {
                FileUtils.delete(childFiles[i]);
            }
        }
        return resource.delete();
    }

    public static int replaceStrInFileNames(final String pattern, String newPattern, String initDir, boolean recurseSubDirs) {
        DirectoryExtractor dw = new DirectoryExtractor(initDir);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().indexOf(pattern) >= 0;
            }
        };
        Collection files = dw.getFilesAndDirectories(fileFilter);
        if (files != null && !files.isEmpty()) {
            int affectedFiles = 0;
            for (File currFile : files) {
                String filePath = currFile.getPath();
                String fileName = currFile.getName();
                String newFileName = StringUtils.replaceString(fileName, pattern, newPattern);
                String newFilePath = StringUtils.replaceString(filePath, fileName, newFileName);
                if (DEBUG) {
                    R01FLog.getLogger("r01f.util").info(filePath + " renamed to: " + newFilePath);
                }
                if (!currFile.renameTo(new File(newFilePath))) continue;
                ++affectedFiles;
            }
            return affectedFiles;
        }
        return -1;
    }

    public static int replaceStrInFiles(String pattern, String newPattern, String initDir) {
        DirectoryExtractor dw = new DirectoryExtractor(initDir);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().indexOf("") >= 0;
            }
        };
        Collection files = dw.getFilesAndDirectories(fileFilter);
        if (files != null && !files.isEmpty()) {
            int affectedFiles = 0;
            StringBuffer sb = new StringBuffer();
            Iterator it = files.iterator();
            while (it.hasNext()) {
                boolean updated = false;
                File currFile = (File)it.next();
                String filePath = currFile.getPath();
                sb.setLength(0);
                String line = null;
                try {
                    FileInputStream fis = new FileInputStream(currFile);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                    while ((line = reader.readLine()) != null) {
                        line = line.replaceAll(pattern, newPattern);
                        sb.append(line);
                        sb.append("\n");
                        if (line.indexOf(newPattern) == -1) continue;
                        updated = true;
                    }
                    reader.close();
                    BufferedWriter out = new BufferedWriter(new FileWriter(currFile));
                    out.write(sb.toString());
                    out.close();
                }
                catch (FileNotFoundException fe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (!updated) continue;
                ++affectedFiles;
                if (!DEBUG) continue;
                R01FLog.getLogger("r01f.util").info(filePath + " updated: old pattern = " + pattern + ", new pattern = " + newPattern);
            }
            return affectedFiles;
        }
        return -1;
    }

    public static String formatedFileLength(long fileBytes) {
        if (fileBytes <= 0L) {
            return "";
        }
        if (fileBytes < 1024L) {
            return fileBytes + FORMAT_BYTES[0];
        }
        int i = 1;
        double d = fileBytes;
        while (true) {
            double d2;
            d /= 1024.0;
            if (!(d2 > 1023.0)) break;
            ++i;
        }
        d = (double)Math.round(d * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
        if (i < FORMAT_BYTES.length) {
            return d + FORMAT_BYTES[i];
        }
        return String.valueOf(fileBytes);
    }

    public static List readLinesFromFile(String filePath) {
        File fileToRead = new File(filePath);
        return FileUtils.readLinesFromFile(fileToRead);
    }

    public static List readLinesFromFile(File fileToRead) {
        ArrayList lines = null;
        if (!fileToRead.exists()) {
            if (DEBUG) {
                R01FLog.getLogger("r01f.util").warning("El fichero especificado " + fileToRead.getAbsolutePath() + " no existe!!!!");
            }
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileToRead);
        }
        catch (FileNotFoundException fnfEx) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
            fnfEx.printStackTrace(System.out);
            return null;
        }
        StringBuffer buf = new StringBuffer();
        ArrayList<String> words = new ArrayList<String>();
        BufferedInputStream fileIn = null;
        try {
            int c;
            fileIn = new BufferedInputStream(fis);
            do {
                char caracter;
                if ((caracter = (char)(c = ((InputStream)fileIn).read())) == '\n' || caracter == '\r' || c == -1) {
                    if (!StringUtils.isEmptyStringBuffer(buf)) {
                        words.add(buf.toString());
                    }
                    buf.setLength(0);
                    continue;
                }
                if (Character.isWhitespace(caracter) || caracter == '\r' || caracter == '\n') continue;
                buf.append((char)c);
            } while (c != -1);
        }
        catch (IOException ioExc) {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fileIn != null) {
                    ((InputStream)fileIn).close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
            if (DEBUG) {
                R01FLog.getLogger("r01f.util").info("Error al leer el fichero " + fileToRead.getAbsolutePath());
            }
            return null;
        }
        if (!words.isEmpty()) {
            lines = new ArrayList();
            Iterator itWords = words.iterator();
            while (itWords.hasNext()) {
                lines.add(itWords.next());
            }
        }
        if (DEBUG) {
            R01FLog.getLogger("r01f.util").info("Le\u00eddo CORRECTAMENTE el fichero " + fileToRead.getAbsolutePath());
        }
        return lines;
    }

    public static List readLinesFromStream(InputStream fileIn) {
        ArrayList lines = null;
        StringBuffer buf = new StringBuffer();
        ArrayList<String> words = new ArrayList<String>();
        try {
            int c;
            do {
                char caracter;
                if ((caracter = (char)(c = fileIn.read())) == '\n' || caracter == '\r' || c == -1) {
                    if (!StringUtils.isEmptyStringBuffer(buf)) {
                        words.add(buf.toString());
                    }
                    buf.setLength(0);
                    continue;
                }
                if (Character.isWhitespace(caracter) || caracter == '\r' || caracter == '\n') continue;
                buf.append((char)c);
            } while (c != -1);
        }
        catch (IOException ioExc) {
            try {
                fileIn.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
            if (DEBUG) {
                R01FLog.getLogger("r01f.util").info("Error al leer el fichero.");
            }
            return null;
        }
        if (!words.isEmpty()) {
            lines = new ArrayList();
            Iterator itWords = words.iterator();
            while (itWords.hasNext()) {
                lines.add(itWords.next());
            }
        }
        if (DEBUG) {
            R01FLog.getLogger("r01f.util").info("Le\u00eddo CORRECTAMENTE el fichero.");
        }
        return lines;
    }

    public static List<String> readDirFiles(String dirPath, boolean bRecursive, List<String> excludeDirs) {
        ArrayList<String> dirFiles = null;
        File f = new File(dirPath);
        if (f.exists()) {
            dirFiles = new ArrayList<String>();
            File[] files = f.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    if (excludeDirs != null && !excludeDirs.isEmpty() && excludeDirs.contains(files[i].getPath())) continue;
                    if (files[i].isFile()) {
                        dirFiles.add(dirPath + File.separator + files[i].getName());
                        continue;
                    }
                    if (!bRecursive) continue;
                    dirFiles.addAll(FileUtils.readDirFiles(files[i].getPath(), bRecursive, excludeDirs));
                }
            }
        }
        return dirFiles;
    }

    public static void main(String[] argv) {
        try {
            String[] splitedName = FileUtils.splitFileNameAndExtension("a.");
            R01FLog.to("r01f.test").info(splitedName[0] + "-" + splitedName[1]);
            File srcFile = new File("d:/eAdmin/test/dirA/file.txt");
            File dstFile = new File("d:/eAdmin/test/dirB/file.txt");
            FileUtils.copyFile(srcFile, dstFile);
        }
        catch (Throwable t) {
            R01FLog.to("r01f.test").info(t.toString());
            t.printStackTrace(System.out);
        }
        System.exit(0);
    }
}

