/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class DirectoryExtractor {
    private final transient File _startingDirectory;

    public DirectoryExtractor(String startingDirectory) {
        if (startingDirectory == null) {
            throw new NullPointerException();
        }
        if (startingDirectory.length() == 0) {
            throw new IllegalArgumentException("El directorio inicial no puede ser nulo");
        }
        this._startingDirectory = new File(startingDirectory);
        if (!this._startingDirectory.exists()) {
            throw new IllegalArgumentException("El directorio " + startingDirectory + " no existe");
        }
        if (!this._startingDirectory.isDirectory()) {
            throw new IllegalArgumentException(startingDirectory + " no es un directorio");
        }
    }

    public Collection getFiles(FileFilter filter) {
        return this._walk(filter, true, false);
    }

    public Collection getDirectories(FileFilter filter) {
        return this._walk(filter, false, true);
    }

    public Collection getFilesAndDirectories(FileFilter filter) {
        return this._walk(filter, true, true);
    }

    private Collection _walk(FileFilter filter, boolean includeFiles, boolean includeDirectories) {
        ArrayList<File> results = new ArrayList<File>();
        if (includeDirectories && filter.accept(this._startingDirectory)) {
            results.add(this._startingDirectory);
        }
        LinkedList<File> pendingDirectories = new LinkedList<File>();
        pendingDirectories.add(this._startingDirectory);
        while (!pendingDirectories.isEmpty()) {
            File currDir = (File)pendingDirectories.get(0);
            pendingDirectories.remove(0);
            File[] files = currDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File currentFile = files[i];
                if (includeFiles && currentFile.isFile() && filter.accept(currentFile)) {
                    results.add(currentFile);
                    continue;
                }
                if (!currentFile.isDirectory()) continue;
                if (includeDirectories && filter.accept(currentFile)) {
                    results.add(currentFile);
                }
                pendingDirectories.add(currentFile);
            }
        }
        return results;
    }
}

