/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.ejb;

import com.ejie.r01f.ejb.ServiceLocatorException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class ServiceLocator {
    private static final String LOCAL_INTERFACE_PREFIX = "";
    private static final String REMOTE_INTERFACE_PREFIX = "";
    private static final String DEFAULT_JNDI_CONTEXT_URL = "default";
    private transient Map _ejbHomeReferences = new Hashtable();

    ServiceLocator() {
    }

    public static ServiceLocator getInstance() {
        return ServiceLocator.getInstance(null);
    }

    public static ServiceLocator getInstance(Properties props) {
        try {
            ContextMapSingletonHolder.getInitialContext(props);
        }
        catch (NamingException namEx) {
            namEx.printStackTrace(System.out);
            R01FLog.to("r01f.ejb").severe("No se ha podido obtener el contexto inicial del \u00e1rbol JNDI: " + namEx.getMessage());
        }
        return LocatorSingletonHolder.instance;
    }

    public EJBLocalHome getLocalHome(String jndiName) {
        Object home = null;
        if (!this._ejbHomeReferences.isEmpty()) {
            home = this._ejbHomeReferences.get("" + jndiName);
        }
        if (home == null) {
            R01FLog.to("r01f.ejb").info("\t...se intenta buscar el interfaz home local con el nombre: " + jndiName);
            try {
                home = this._jndiFind("" + jndiName, DEFAULT_JNDI_CONTEXT_URL);
            }
            catch (NamingException namEx) {
                R01FLog.to("r01f.ejb").warning("NO se ha encontrado el interfaz home LOCAL del ejb con el nombre jndi: " + jndiName + ": " + namEx.getExplanation());
            }
        }
        if (home != null) {
            this._ejbHomeReferences.put(jndiName, home);
        } else {
            R01FLog.to("r01f.ejb").info("NO se ha encontrado el interfaz home del ejb. Se ha buscado el home local con el nombre JNDI: " + jndiName + " y el home con el nombre JNDI: " + "" + jndiName);
        }
        return (EJBLocalHome)home;
    }

    public EJBLocalHome getLocalHome(String jndiName, Class homeClassDef) {
        EJBLocalHome home = this.getLocalHome(jndiName);
        if (home != null) {
            try {
                home = (EJBLocalHome)PortableRemoteObject.narrow((Object)home, (Class)homeClassDef);
            }
            catch (ClassCastException ccEx) {
                ccEx.printStackTrace(System.out);
                R01FLog.to("r01f.ejb").severe("Error al hacer un narrow a " + homeClassDef.getName() + " del home de tipo " + home.getClass().getName() + "> " + ccEx.getMessage());
            }
        }
        if (home == null) {
            R01FLog.to("r01f.ejb").severe("NO se ha podido obtener el interfaz home local al ejb jndi:" + jndiName + " haciendo narrow a la clase " + homeClassDef.getClass().getName());
        }
        return home;
    }

    public EJBLocalHome getLocalHome(String jndiName, String homeClassName) throws ServiceLocatorException {
        try {
            return this.getLocalHome(jndiName, ReflectionUtils.getObjectClassDef(homeClassName));
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServiceLocatorException("No se encuentra la clase del interfaz home " + homeClassName, cnfEx);
        }
    }

    public boolean checkLocalHomeInterface(String jndiName) {
        if (!this._ejbHomeReferences.isEmpty() && this._ejbHomeReferences.containsKey("" + jndiName)) {
            return true;
        }
        EJBLocalHome home = this.getLocalHome(jndiName);
        return home != null;
    }

    public EJBHome getRemoteHome(String jndiName, String theUrlProvider) {
        Object home = null;
        if (this._ejbHomeReferences != null && !this._ejbHomeReferences.isEmpty()) {
            home = this._ejbHomeReferences.get("" + jndiName);
        }
        if (home == null) {
            R01FLog.to("r01f.ejb").info("\t...el ejb NO esta en local asi que se intenta buscar el interfaz home con el nombre: " + jndiName);
            try {
                home = this._jndiFind("" + jndiName, theUrlProvider);
            }
            catch (NamingException namEx) {
                R01FLog.to("r01f.ejb").warning("NO se ha encontrado el interfaz home del ejb con el nombre jndi: " + jndiName + ": " + namEx.getExplanation());
            }
            if (home != null) {
                this._ejbHomeReferences.put(jndiName, home);
            } else {
                R01FLog.to("r01f.ejb").severe("NO se ha encontrado el interfaz home del ejb. Se ha buscado el home local con el nombre JNDI: " + jndiName + " y el home con el nombre JNDI: " + "" + jndiName);
            }
        } else {
            R01FLog.to("r01f.ejb").info("REF-EJB-HOME >>>>>>>>>>>>> eL EJB home no es nulo ..............OK OK OK");
        }
        return (EJBHome)home;
    }

    public EJBHome getRemoteHome(String jndiName, String theUrlProvider, Class homeClassDef) {
        EJBHome home = this.getRemoteHome(jndiName, theUrlProvider);
        if (home != null && homeClassDef != null) {
            try {
                home = (EJBHome)PortableRemoteObject.narrow((Object)home, (Class)homeClassDef);
            }
            catch (ClassCastException ccEx) {
                ccEx.printStackTrace(System.out);
                R01FLog.to("r01f.ejb").severe("Error al hacer un narrow a " + homeClassDef.getName() + " del home de tipo " + home.getClass().getName() + "> " + ccEx.getMessage());
            }
        }
        if (home == null) {
            R01FLog.to("r01f.ejb").severe("NO se ha podido obtener el interfaz home remoto al ejb jndi:" + jndiName + " haciendo narrow a la clase " + homeClassDef.getClass().getName());
        }
        return home;
    }

    public EJBHome getRemoteHome(String jndiName) {
        return this.getRemoteHome(jndiName, DEFAULT_JNDI_CONTEXT_URL);
    }

    public EJBHome getRemoteHome(String jndiName, Class homeClassDef) {
        return this.getRemoteHome(jndiName, DEFAULT_JNDI_CONTEXT_URL, homeClassDef);
    }

    public EJBHome getRemoteHome(String jndiName, String theUrlProvider, String homeClassName) throws ServiceLocatorException {
        try {
            return this.getRemoteHome(jndiName, theUrlProvider, ReflectionUtils.getObjectClassDef(homeClassName));
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServiceLocatorException("No se encuentra la clase del interfaz home " + homeClassName, cnfEx);
        }
    }

    public EJBObject getService(String id) throws ServiceLocatorException {
        if (id == null) {
            return null;
        }
        try {
            byte[] bytes = id.getBytes();
            ByteArrayInputStream io = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(io);
            Handle handle = (Handle)ois.readObject();
            return handle.getEJBObject();
        }
        catch (IOException ex) {
            throw new ServiceLocatorException(ex);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServiceLocatorException(cnfEx);
        }
    }

    protected String getId(EJBObject ejbObject) throws ServiceLocatorException {
        try {
            Handle handle = ejbObject.getHandle();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(handle);
            oos.flush();
            oos.close();
            return new String(baos.toByteArray());
        }
        catch (RemoteException remEx) {
            throw new ServiceLocatorException(remEx);
        }
        catch (IOException ioEx) {
            throw new ServiceLocatorException(ioEx);
        }
    }

    private Object _jndiFind(String jndiName, String theUrlProvider) throws NamingException {
        return ContextMapSingletonHolder.getContext(theUrlProvider).lookup(jndiName);
    }

    public Object obtainHome(boolean isLocal, String jndiName, Class homeClassDef) throws ServiceLocatorException {
        return this.obtainHome(isLocal, jndiName, homeClassDef, null);
    }

    public Object obtainHome(boolean isLocal, String jndiName, Class homeClassDef, Properties props) throws ServiceLocatorException {
        R01FLog.to("r01f.ejb").info("...obteniendo el interfaz Home (local: " + isLocal + ")");
        Object home = null;
        home = homeClassDef == null ? (isLocal ? ServiceLocator.getInstance(null).getLocalHome(jndiName) : ServiceLocator.getInstance(props).getRemoteHome(jndiName, props.get("url").toString())) : (isLocal ? ServiceLocator.getInstance(null).getLocalHome(jndiName, homeClassDef) : ServiceLocator.getInstance(props).getRemoteHome(jndiName, props.get("url").toString(), homeClassDef));
        if (home == null) {
            R01FLog.to("r01f.ejb").severe("Error al obtener el interfaz home del EJB " + jndiName);
            throw new ServiceLocatorException("No se ha podido obtener el interfaz home del EJB " + jndiName);
        }
        return home;
    }

    private static final class ContextMapSingletonHolder {
        static Map contextMap = new Hashtable();

        private ContextMapSingletonHolder() {
        }

        public static Context getContext(String urlContext) {
            Context c = (Context)contextMap.get(urlContext);
            if (c == null) {
                R01FLog.to("r01f.ejb").severe("El contexto para la url " + urlContext + " NO se encuentra en la cache de contextos. \u00bfse ha llamado previamente a getInitialContext?");
            }
            return c;
        }

        public static Context getInitialContext(Properties props) throws NamingException {
            if (props != null) {
                String factory = props.get("factory").toString();
                String url = props.get("url").toString();
                String user = props.get("user").toString();
                String password = props.get("password").toString();
                if (contextMap.get(url) == null) {
                    Properties h = new Properties();
                    h.put("java.naming.factory.initial", factory);
                    h.put("java.naming.provider.url", url);
                    h.put("java.naming.security.principal", user);
                    h.put("java.naming.security.credentials", password);
                    InitialContext outCtx = new InitialContext(h);
                    contextMap.put(url, outCtx);
                    return outCtx;
                }
                return (Context)contextMap.get(url);
            }
            if (contextMap.get(ServiceLocator.DEFAULT_JNDI_CONTEXT_URL) == null) {
                InitialContext ic = new InitialContext();
                contextMap.put(ServiceLocator.DEFAULT_JNDI_CONTEXT_URL, ic);
                return ic;
            }
            return (Context)contextMap.get(ServiceLocator.DEFAULT_JNDI_CONTEXT_URL);
        }
    }

    private static final class LocatorSingletonHolder {
        static final ServiceLocator instance = new ServiceLocator();

        private LocatorSingletonHolder() {
        }
    }
}

