/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.clone;

import com.ejie.r01f.clone.TestObj;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CloneUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final boolean DEBUG = R01FLog.getLogLevel("r01f.objectUtils").intValue() != Level.OFF.intValue();

    public static Object cloneBySerialization(Object objectToClone) throws CloneNotSupportedException {
        try {
            if (DEBUG) {
                R01FLog.to("r01f.objectUtils").info("Clonando por serializacion un objeto de tipo " + objectToClone.getClass().getName());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(objectToClone);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
            throw new CloneNotSupportedException("No se puede clonar via serializacion: alguno de los objetos de la jerarquia NO es serializable: " + ioEx.toString());
        }
        catch (ClassNotFoundException cnfEx) {
            cnfEx.printStackTrace(System.out);
            throw new CloneNotSupportedException("No se puede clonar via serializaci\u00f3n: no se puede crear el objeto " + cnfEx.toString());
        }
    }

    public static Object cloneByReflection(Object objectToClone) {
        return CloneUtils._doCloneByRefection(objectToClone, new IdentityHashMap(), new HashMap());
    }

    private static Object _doCloneByRefection(Object originalObj, Map objMap, Map metadataMap) {
        Object objClon;
        Constructor<?> noArgConstructor;
        if (DEBUG) {
            R01FLog.to("r01f.objectUtils").info("Clonando el objeto [" + originalObj + "]");
        }
        if (originalObj == null) {
            return null;
        }
        if (objMap.containsKey(originalObj)) {
            return objMap.get(originalObj);
        }
        Class<?> objClass = originalObj.getClass();
        if (ReflectionUtils.isArray(objClass)) {
            int arrayLength;
            if (DEBUG) {
                R01FLog.to("r01f.objectUtils").info("\t...El Objeto es un Array");
            }
            if ((arrayLength = Array.getLength(originalObj)) == 0) {
                objMap.put(originalObj, originalObj);
                return originalObj;
            }
            Class<?> componentType = objClass.getComponentType();
            Object objClon2 = Array.newInstance(componentType, arrayLength);
            if (componentType.isPrimitive() || ReflectionUtils.isFinalInmutable(componentType)) {
                System.arraycopy(originalObj, 0, objClon2, 0, arrayLength);
            } else {
                for (int i = 0; i < arrayLength; ++i) {
                    Object currElem = Array.get(originalObj, i);
                    if (currElem == null) continue;
                    Object slotClone = CloneUtils._doCloneByRefection(currElem, objMap, metadataMap);
                    Array.set(objClon2, i, slotClone);
                }
            }
            objMap.put(originalObj, objClon2);
            return objClon2;
        }
        if (ReflectionUtils.isMap(objClass)) {
            if (DEBUG) {
                R01FLog.to("r01f.objectUtils").info("\t...El Objeto es un Map");
            }
            try {
                Map originalMap = (Map)originalObj;
                Map clonedMap = (Map)ReflectionUtils.getObjectInstance(originalObj.getClass().getName());
                Map.Entry me2 = null;
                for (Map.Entry me2 : originalMap.entrySet()) {
                    clonedMap.put(CloneUtils._doCloneByRefection(me2.getKey(), objMap, metadataMap), CloneUtils._doCloneByRefection(me2.getValue(), objMap, metadataMap));
                }
                objMap.put(originalMap, clonedMap);
                return clonedMap;
            }
            catch (Exception e) {
                throw new RuntimeException("No se puede clonar el mapa!!!: " + e.toString());
            }
        }
        if (ReflectionUtils.isList(objClass)) {
            if (DEBUG) {
                R01FLog.to("r01f.objectUtils").info("\t...El Objeto es una Lista");
            }
            try {
                List originalList = (List)originalObj;
                List clonedList = (List)ReflectionUtils.getObjectInstance(originalObj.getClass().getName());
                Iterator it = originalList.iterator();
                while (it.hasNext()) {
                    clonedList.add(CloneUtils._doCloneByRefection(it.next(), objMap, metadataMap));
                }
                objMap.put(originalList, clonedList);
                return clonedList;
            }
            catch (Exception e) {
                throw new RuntimeException("No se puede clonar el mapa!!!: " + e.toString());
            }
        }
        if (ReflectionUtils.isFinalInmutable(objClass)) {
            objMap.put(originalObj, originalObj);
            return originalObj;
        }
        ClassMetadata metadata = (ClassMetadata)metadataMap.get(objClass);
        if (metadata == null) {
            metadata = new ClassMetadata(objClass);
            metadataMap.put(objClass, metadata);
        }
        if ((noArgConstructor = metadata.noArgConstructor) == null) {
            try {
                metadata.noArgConstructor = noArgConstructor = objClass.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (Exception e) {
                throw new RuntimeException("La clase [" + objClass.getName() + "] NO tiene un constructor vacio!!!: " + e.toString());
            }
        }
        if (!metadata.isNoArgConstructorAccessible && (1 & noArgConstructor.getModifiers()) == 0) {
            try {
                noArgConstructor.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new RuntimeException("Error de seguridad: No se puede modificar la visibilidad del constructor vacio [" + noArgConstructor + "] de la clase [" + objClass.getName() + "]: para hacerlo accesible al clonado por reflection " + e.toString());
            }
            metadata.isNoArgConstructorAccessible = true;
        }
        try {
            objClon = noArgConstructor.newInstance(EMPTY_OBJECT_ARRAY);
            objMap.put(originalObj, objClon);
        }
        catch (Exception e) {
            throw new RuntimeException("No se puede instanciar la clase [" + objClass.getName() + "] utilizando un constructor sin argumentos: " + e.toString());
        }
        for (Class<?> c = objClass; c != Object.class; c = c.getSuperclass()) {
            Field[] declaredFields;
            metadata = (ClassMetadata)metadataMap.get(c);
            if (metadata == null) {
                metadata = new ClassMetadata(c);
                metadataMap.put(c, metadata);
            }
            if ((declaredFields = metadata.declaredFields) == null) {
                declaredFields = c.getDeclaredFields();
                metadata.declaredFields = declaredFields;
            }
            CloneUtils._cloneFields(originalObj, objClon, declaredFields, metadata.areFieldsAccessible, objMap, metadataMap);
            metadata.areFieldsAccessible = true;
        }
        return objClon;
    }

    private static void _cloneFields(Object src, Object dest, Field[] fields, boolean accessible, Map objMap, Map metadataMap) {
        int fieldsLength = fields.length;
        for (int f = 0; f < fieldsLength; ++f) {
            int modifiers;
            Field currField = fields[f];
            if (DEBUG) {
                R01FLog.to("r01f.objectUtils").info("\tdest object [" + dest + "]: field #" + f + ", [" + currField + "]");
            }
            if ((8 & (modifiers = currField.getModifiers())) != 0) continue;
            if ((0x10 & modifiers) != 0) {
                throw new RuntimeException("No se puede estblecer el miembro final [" + currField.getName() + "] de la clase [" + src.getClass().getName() + "]");
            }
            if (!accessible && (1 & modifiers) == 0) {
                try {
                    currField.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Error de seguridad: No se puede hacer accesible el miembro [" + currField.getName() + "] de la clase [" + src.getClass().getName() + "]: " + e.toString());
                }
            }
            try {
                Object value = currField.get(src);
                if (value == null) {
                    currField.set(dest, null);
                    if (!DEBUG) continue;
                    R01FLog.to("r01f.objectUtils").info("\t\testablecer el miembro #" + f + ", [" + currField + "] del objeto [" + dest + "] a NULL");
                    continue;
                }
                Class<?> valueType = value.getClass();
                if (!ReflectionUtils.isFinalInmutable(valueType)) {
                    value = CloneUtils._doCloneByRefection(value, objMap, metadataMap);
                }
                currField.set(dest, value);
                if (!DEBUG) continue;
                R01FLog.to("r01f.objectUtils").info("\t\testablecer el miembro #" + f + ", [" + currField + "] del objeto [" + dest + "] a su valor final: " + value);
                continue;
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace(System.out);
                }
                throw new RuntimeException("No se puede establecer el miembro [" + currField.getName() + "] de la clase [" + src.getClass().getName() + "]: " + e.toString());
            }
        }
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            TestObj originalTestObj = new TestObj();
            for (int i = 0; i < 1000; ++i) {
                boolean testCloneByReflection = true;
                boolean testCloneBySerialization = false;
                TestObj clonedTestObj = null;
                if (testCloneByReflection) {
                    clonedTestObj = (TestObj)CloneUtils.cloneByReflection(originalTestObj);
                } else if (testCloneBySerialization) {
                    clonedTestObj = (TestObj)CloneUtils.cloneBySerialization(originalTestObj);
                }
                R01FLog.to("r01f.test").info("\r\n\r\n");
                HashMap<String, TestObj> testMap = new HashMap<String, TestObj>();
                testMap.put("1", originalTestObj);
                testMap.put("2", clonedTestObj);
                Map clonedMap = null;
                if (testCloneByReflection) {
                    clonedMap = (Map)CloneUtils.cloneByReflection(testMap);
                    continue;
                }
                if (!testCloneBySerialization) continue;
                clonedMap = (Map)CloneUtils.cloneBySerialization(testMap);
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg" + " - " + (t2 - t1) + "msg");
        }
        catch (Throwable th) {
            th.printStackTrace(System.out);
        }
    }

    private static final class ClassMetadata {
        transient Constructor noArgConstructor;
        transient Field[] declaredFields;
        transient boolean isNoArgConstructorAccessible;
        transient boolean areFieldsAccessible;

        public ClassMetadata() {
        }

        public ClassMetadata(Class cls) {
            try {
                this.noArgConstructor = cls.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (Exception e) {
                throw new RuntimeException("La clase [" + cls.getName() + "] NO tiene un constructor vacio!!!: " + e.toString());
            }
            this.declaredFields = cls.getDeclaredFields();
            this.isNoArgConstructorAccessible = false;
            this.areFieldsAccessible = false;
        }
    }
}

