/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.businessdelegate;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLExternalProperties;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

abstract class BaseBusinessDelegateInvocationHandler
implements InvocationHandler {
    static final boolean DEBUG = R01FLog.getLogLevel("r01f.bzd").intValue() != Level.OFF.intValue();
    static final int BZD_UNKNOWN = -1;
    static final int BZD_LOCALCLASS_TYPE = 1;
    static final int BZD_EJB_TYPE = 2;
    static final int BZD_RPCSERVLET_TYPE = 3;
    static final int BZD_OTHER = 4;
    static final int BZD_WEBSERVICE = 5;
    private static Map _CONFIG_CACHE = new HashMap(100);
    private static Map _XMLExtProps_CACHE = null;
    private String _appCode;
    private String _bzdOid;
    private int _retryTimes = 1;

    BaseBusinessDelegateInvocationHandler() {
    }

    BaseBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid) {
        this._appCode = newAppCode;
        this._bzdOid = newBzdOid;
    }

    String getAppCode() {
        return this._appCode;
    }

    String getBzdOid() {
        return this._bzdOid;
    }

    void setRetryTimes(int newRetryTimes) {
        this._retryTimes = newRetryTimes;
    }

    int getRetryTimes() {
        return this._retryTimes;
    }

    abstract Object doInvoke(Method var1, Object[] var2) throws Throwable;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (int trys = 1; trys <= this._retryTimes; ++trys) {
            try {
                if (DEBUG) {
                    R01FLog.to("r01f.bzd").info("try(" + trys + "): Invocando el metodo (" + method + ") en el Objeto " + proxy.getClass().getName());
                }
                return this.doInvoke(method, args);
            }
            catch (NoSuchMethodException nsmEx) {
                trys = this._retryTimes + 1;
                R01FLog.to("r01f.bzd").severe("No se encuentra el metodo (" + method + ") en el objeto " + proxy.getClass().getName() + ". Este objeto DEBE TENER LOS MISMOS METODOS y CON LA MISMA SIGNATURA que el Business Delegate!!!");
                nsmEx.printStackTrace(System.out);
                throw nsmEx;
            }
            catch (IllegalAccessException illAccEx) {
                trys = this._retryTimes;
                illAccEx.printStackTrace(System.out);
                throw new Exception(illAccEx);
            }
            catch (Throwable th) {
                if (trys < this._retryTimes) {
                    R01FLog.to("r01f.bzd").warning("...try(" + trys + "): Error al invocar el metodo '" + method + ") del Objeto " + proxy.getClass().getName() + ".\r\n\tQuedan " + (this._retryTimes - trys) + " reintentos\r\n" + th.getMessage());
                    continue;
                }
                R01FLog.to("r01f.bzd").severe("Se ha alcanzado el limite de " + trys + " reintentos para ejecutar el metodo (" + method + ") en el Objeto " + proxy.getClass().getName());
                if (th instanceof InvocationTargetException) {
                    ((InvocationTargetException)th).getTargetException().printStackTrace(System.out);
                    throw ((InvocationTargetException)th).getTargetException();
                }
                th.printStackTrace(System.out);
                throw th;
            }
        }
        return null;
    }

    protected static int getBusinessDelegateType(String theAppCode, String theBzdOid) {
        String bzdTypeStr = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(theAppCode, theBzdOid, "bzdType", "bzdType");
        int bzdType = -1;
        if (bzdTypeStr == null) {
            R01FLog.to("r01f.bzd").severe("[ERROR](null) >>No esta definido el parametro businessDelegatesConfig/businessDelegate[@oid'" + theBzdOid + "']/bzdType, en el fichero de configuracion de BZD");
        } else {
            bzdType = bzdTypeStr.equalsIgnoreCase("Class") ? 1 : (bzdTypeStr.equalsIgnoreCase("EJB") ? 2 : (bzdTypeStr.equalsIgnoreCase("RPCServlet") ? 3 : (bzdTypeStr.equalsIgnoreCase("Other") ? 4 : -1)));
        }
        return bzdType;
    }

    protected static String getBzdConfigProperty(String appCode, String bzdOid, String propertyName, String propXPath) {
        String propOid = appCode + "." + bzdOid + "." + propertyName;
        String outProperty = (String)_CONFIG_CACHE.get(propOid);
        if (outProperty == null) {
            String propXPathToUse = "businessDelegatesConfig/businessDelegate[@oid='" + bzdOid + "']/" + propXPath;
            String storage = (String)_CONFIG_CACHE.get(appCode + ".storage");
            if (storage == null) {
                storage = XMLProperties.get(appCode, "businessDelegatesConfig[@storage]/@storage");
                _CONFIG_CACHE.put(appCode + ".storage", storage);
            }
            if (storage == null) {
                storage = "properties";
                _CONFIG_CACHE.put(appCode + ".storage", storage);
                R01FLog.to("r01f.bzd").warning("NO se ha establecido el valor del atributo businessDelegatesConfig[@storage] que establece desde donde se cargan las propiedades de bzd (fichero props de la aplicaci\u00f3n / fichero props externo independiente para config de bzd)\r\nSe utiliza el fichero properties de la aplicaci\u00f3n por defecto!!!");
            }
            if ("properties".equals(storage)) {
                outProperty = XMLProperties.get(appCode, propXPathToUse);
            } else {
                String theProp;
                XMLExternalProperties props;
                if (_XMLExtProps_CACHE == null) {
                    _XMLExtProps_CACHE = new HashMap(10);
                }
                if ((props = (XMLExternalProperties)_XMLExtProps_CACHE.get(appCode)) == null) {
                    props = new XMLExternalProperties(storage);
                    _XMLExtProps_CACHE.put(appCode, props);
                }
                if ((theProp = props.get(appCode, propXPathToUse)) != null) {
                    outProperty = new String(theProp);
                }
            }
            if (outProperty != null) {
                _CONFIG_CACHE.put(propOid, outProperty);
            }
        }
        return outProperty;
    }
}

