/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.auxdata;

import com.ejie.r01f.auxdata.AuxDataLoader;
import com.ejie.r01f.auxdata.AuxDataLoaderException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringMap;
import com.ejie.r01f.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class DefaultFileDataLoaderImpl
implements AuxDataLoader {
    @Override
    public Map load(String appCode, String dataSetOid, Properties props) throws AuxDataLoaderException {
        if (props == null) {
            throw new AuxDataLoaderException("Error de configuracion: Faltan las propiedades en la configuracion del loader de datos Auxiliares");
        }
        String filePath = props.getProperty("filePath");
        String dividerChar = props.getProperty("dividerChar");
        if (filePath == null) {
            throw new AuxDataLoaderException("Error de configuracion: Falta la propiedad 'filePath' en la configuracion del loader de datos Auxiliares");
        }
        if (dividerChar == null) {
            dividerChar = ":";
        }
        Properties varValues = new Properties();
        varValues.put("appCode", appCode);
        varValues.put("dataSet", dataSetOid);
        if (props != null) {
            varValues.putAll(props);
        }
        filePath = StringUtils.replaceVariableValues(filePath, '$', (Map)varValues);
        R01FLog.to("r01f.util").info("Fichero desde donde se van a obtener los datos auxiliares: " + filePath);
        try {
            String[][] values = StringUtils.loadColumnsFromFile(filePath, dividerChar.charAt(0));
            return new StringMap(values);
        }
        catch (IOException ioEx) {
            throw new AuxDataLoaderException("Error al acceder al fichero para obtener datos auxiliares de " + dataSetOid + ": " + ioEx.getMessage(), (Exception)ioEx);
        }
    }
}

