/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.auxdata;

import com.ejie.r01f.auxdata.AuxDataLoader;
import com.ejie.r01f.auxdata.AuxDataLoaderException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringMap;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class AuxDataManager {
    private AuxDataManager() {
    }

    public static Map getAuxData(String appCode, String dataSet, Properties params) throws AuxDataLoaderException {
        if (appCode == null || dataSet == null) {
            throw new AuxDataLoaderException("No se pueden obtener los datos auxiliares ya que falta uno de los datos (appCode:" + appCode + " dataSetOid:" + dataSet + ")");
        }
        return AuxDataManager._loadAuxData(appCode, dataSet, params);
    }

    public static Map getAuxData(String appCode, String dataSet, String[][] params) throws AuxDataLoaderException {
        Properties p = new Properties();
        if (params != null) {
            StringMap paramsMap = new StringMap(params);
            p.putAll((Map<?, ?>)paramsMap);
            return AuxDataManager.getAuxData(appCode, dataSet, p);
        }
        return AuxDataManager.getAuxData(appCode, dataSet, p);
    }

    public static Map getAuxData(String appCode, String dataSet, Map params) throws AuxDataLoaderException {
        Properties p = new Properties();
        if (params != null) {
            p.putAll((Map<?, ?>)params);
            return AuxDataManager.getAuxData(appCode, dataSet, p);
        }
        return AuxDataManager.getAuxData(appCode, dataSet, p);
    }

    private static Map _loadAuxData(String appCode, String dataSetOid, Properties params) throws AuxDataLoaderException {
        String auxDataLoaderClassName = XMLProperties.get(appCode, "auxDataLoaders/auxDataLoader[@oid='" + dataSetOid + "']/loaderImplClass");
        Properties props = XMLProperties.getProperties(appCode, "auxDataLoaders/auxDataLoader[@oid='" + dataSetOid + "']/loaderProperties");
        props.putAll((Map<?, ?>)params);
        R01FLog.to("r01f.util").info(AuxDataManager._composeConfigDebugInfo(auxDataLoaderClassName, props));
        if (auxDataLoaderClassName == null) {
            throw new AuxDataLoaderException("Error de configuracion: No se ha encontrado el nombre de la clase cargadora de los datos auxilares para el dataSet: " + dataSetOid + ". Revisa el fichero de configuracion de la aplicacion " + appCode);
        }
        try {
            AuxDataLoader dataLoader = (AuxDataLoader)ReflectionUtils.getObjectInstance(auxDataLoaderClassName);
            return dataLoader.load(appCode, dataSetOid, props);
        }
        catch (ClassCastException ccEx) {
            throw new AuxDataLoaderException("La clase cargadora de datos auxiliares " + auxDataLoaderClassName + " NO implementa el interfaz AuxDataLoader!");
        }
        catch (ReflectionException refEx) {
            throw new AuxDataLoaderException("Error al instanciar la clase cargadora de datos auxiliares", (Exception)refEx);
        }
    }

    private static String _composeConfigDebugInfo(String loaderClassName, Properties props) {
        StringBuffer sb = new StringBuffer(119);
        sb.append("Cargando datos auxiliares utilizando la siguiente configuracion del loader:\r\n\tloaderClassName:");
        sb.append(loaderClassName);
        if (props != null) {
            sb.append("\r\n\tproperties:");
            Map.Entry<Object, Object> me2 = null;
            for (Map.Entry<Object, Object> me2 : props.entrySet()) {
                sb.append("\r\n\t\t");
                sb.append(me2.getKey());
                sb.append(": ");
                sb.append(me2.getValue());
            }
        } else {
            sb.append("\r\n\tproperties: null");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            StringMap mapLangTest = new StringMap(new String[][]{{"lang", "es"}});
            for (int times = 0; times < 1; ++times) {
                Map m = AuxDataManager.getAuxData("r01ft", "testDataSet", mapLangTest);
                Map.Entry me = null;
                Iterator it = m.entrySet().iterator();
                while (it != null && it.hasNext()) {
                    me = it.next();
                    R01FLog.to("r01f.util").info(me.getKey() + ":" + me.getValue());
                }
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.util").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

