/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.presentacion.iu.taglib.base;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.iu.taglib.base.Q70Constants;
import es.ejie.frmk.presentacion.iu.taglib.base.Q70CustomTagException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.displaytag.exception.TablePropertiesLoadException;
import org.displaytag.export.MediaTypeEnum;

public class Q70TableProperties {
    private static final String COMPONENTE = Q70Constants.COMPONENTE_CUSTOM_TAG;
    private static Q70Traza tr = Q70Traza.getSingleton();
    protected List listaI18nKey = null;
    private String languageTableProperties;
    private Properties properties = null;
    private static final String PROPERTY_BOOLEAN_EXPORT_PREFIX = "export";
    private static final String PROPERTY_STRING_EXPORT_LABEL = "label";
    private static final String PROPERTY_BOOLEAN_EXPORT_HEADER = "include_header";
    private static final String PROPERTY_STRING_EXPORTBANNER = "export.banner";
    private static final String PROPERTY_STRING_EXPORTBANNER_SEPARATOR = "export.banner.sepchar";
    private static final String PROPERTY_BOOLEAN_EXPORTDECORATED = "export.decorated";
    private static final String PROPERTY_STRING_EXPORTAMOUNT = "export.amount";
    private static final String PROPERTY_STRING_EXPORT_FILENAME = "export.filename";
    private static final String PROPERTY_BOOLEAN_SHOWHEADER = "basic.show.header";
    private static final String PROPERTY_STRING_EMPTYLIST_MESSAGE = "basic.msg.empty_list";
    private static final String PROPERTY_STRING_BANNER_PLACEMENT = "paging.banner.placement";
    private static final String PROPERTY_STRING_PAGING_INVALIDPAGE = "error.msg.invalid_page";
    private static final String PROPERTY_STRING_PAGING_ITEM_NAME = "paging.banner.item_name";
    private static final String PROPERTY_STRING_PAGING_ITEMS_NAME = "paging.banner.items_name";
    private static final String PROPERTY_STRING_PAGING_NOITEMS = "paging.banner.no_items_found";
    private static final String PROPERTY_STRING_PAGING_FOUND_ONEITEM = "paging.banner.one_item_found";
    private static final String PROPERTY_STRING_PAGING_FOUND_ALLITEMS = "paging.banner.all_items_found";
    private static final String PROPERTY_STRING_PAGING_FOUND_SOMEITEMS = "paging.banner.some_items_found";
    private static final String PROPERTY_INT_PAGING_GROUPSIZE = "paging.banner.group_size";
    private static final String PROPERTY_STRING_PAGING_BANNER_ONEPAGE = "paging.banner.onepage";
    private static final String PROPERTY_STRING_PAGING_BANNER_FIRST = "paging.banner.first";
    private static final String PROPERTY_STRING_PAGING_BANNER_LAST = "paging.banner.last";
    private static final String PROPERTY_STRING_PAGING_BANNER_FULL = "paging.banner.full";
    private static final String PROPERTY_STRING_PAGING_PAGE_LINK = "paging.banner.page.link";
    private static final String PROPERTY_STRING_PAGING_PAGE_SELECTED = "paging.banner.page.selected";
    private static final String PROPERTY_STRING_PAGING_PAGE_SPARATOR = "paging.banner.page.separator";
    private static final String PROPERTY_STRING_SAVE_EXCEL_FILENAME = "save.excel.filename";
    private static final String PROPERTY_STRING_SAVE_EXCEL_BANNER = "save.excel.banner";
    private static Properties userProperties = new Properties();

    public static Properties getUserProperties() {
        return userProperties;
    }

    public static void setUserProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == null || properties.get(string) == null) continue;
            userProperties.setProperty(string, (String)properties.get(string));
        }
    }

    public String getPagingInvalidPage() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_INVALIDPAGE);
    }

    public String getPagingItemName() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEM_NAME);
    }

    public String getPagingItemsName() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEMS_NAME);
    }

    public String getPagingFoundNoItems() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_NOITEMS);
    }

    public String getPagingFoundOneItem() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ONEITEM);
    }

    public String getPagingFoundAllItems() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ALLITEMS);
    }

    public String getPagingFoundSomeItems() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_SOMEITEMS);
    }

    public int getPagingGroupSize(int n) throws Q70CustomTagException {
        return this.getIntProperty(PROPERTY_INT_PAGING_GROUPSIZE, n);
    }

    public String getPagingBannerOnePage() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_ONEPAGE);
    }

    public String getPagingBannerFirst() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FIRST);
    }

    public String getPagingBannerLast() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_LAST);
    }

    public String getPagingBannerFull() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FULL);
    }

    public String getPagingPageLink() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_LINK);
    }

    public String getPagingPageSelected() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SELECTED);
    }

    public String getPagingPageSeparator() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SPARATOR);
    }

    public boolean getAddExport(MediaTypeEnum mediaTypeEnum) throws Q70CustomTagException {
        return this.getBooleanProperty("export." + mediaTypeEnum.getName());
    }

    public boolean getExportHeader(MediaTypeEnum mediaTypeEnum) throws Q70CustomTagException {
        return this.getBooleanProperty("export." + mediaTypeEnum + "." + PROPERTY_BOOLEAN_EXPORT_HEADER);
    }

    public String getExportLabel(MediaTypeEnum mediaTypeEnum) throws Q70CustomTagException {
        return this.getProperty("export." + mediaTypeEnum + "." + PROPERTY_STRING_EXPORT_LABEL);
    }

    public boolean getExportDecorated() throws Q70CustomTagException {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_EXPORTDECORATED);
    }

    public String getExportFileName() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_EXPORT_FILENAME);
    }

    public String getExportBanner() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER);
    }

    public String getExportBannerSeparator() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER_SEPARATOR);
    }

    public boolean getShowHeader() throws Q70CustomTagException {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_SHOWHEADER);
    }

    public String getEmptyListMessage() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_EMPTYLIST_MESSAGE);
    }

    public boolean getExportFullList() throws Q70CustomTagException {
        return "list".equals(this.getProperty(PROPERTY_STRING_EXPORTAMOUNT));
    }

    public boolean getAddPagingBannerTop() throws Q70CustomTagException {
        String string = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return "top".equals(string) || "both".equals(string);
    }

    public boolean getAddPagingBannerBottom() throws Q70CustomTagException {
        String string = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return "bottom".equals(string) || "both".equals(string);
    }

    public String getSaveExcelFilename() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_SAVE_EXCEL_FILENAME);
    }

    public String getSaveExcelBanner() throws Q70CustomTagException {
        return this.getProperty(PROPERTY_STRING_SAVE_EXCEL_BANNER);
    }

    public String getNoColumnMessage() {
        return "Please provide column tags";
    }

    public Q70TableProperties(List list, Locale locale, HttpServletRequest httpServletRequest) throws TablePropertiesLoadException {
        this.listaI18nKey = list;
        this.languageTableProperties = locale.getLanguage();
        String string = Q70ListenerUtils.getLanguage((HttpServletRequest)httpServletRequest);
        if (null != string) {
            this.languageTableProperties = string;
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Las propiedades de la tabla vienen dadas segun los parametros: \r\n-i18nKey: " + this.listaI18nKey + "\r\n" + "-language: " + this.languageTableProperties);
        }
        this.properties = new Properties();
        Enumeration<Object> enumeration = userProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null) continue;
            this.properties.setProperty(string2, (String)userProperties.get(string2));
        }
    }

    private String getProperty(String string) throws Q70CustomTagException {
        if (this.properties.containsKey(string)) {
            return this.properties.getProperty(string);
        }
        try {
            return Q70GestorMensajesi18n.getSingleton().getMessage(this.listaI18nKey, string, this.languageTableProperties, null);
        }
        catch (Q70GestorMensajesException q70GestorMensajesException) {
            throw new Q70CustomTagException(this.getClass().toString(), "getProperty", "Error al recuperar una propiedad de la tabla, mediante el Gestor de Mensajes i18nKey", q70GestorMensajesException);
        }
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    private boolean getBooleanProperty(String string) throws Q70CustomTagException {
        return Boolean.TRUE.toString().equals(this.getProperty(string));
    }

    private int getIntProperty(String string, int n) throws Q70CustomTagException {
        int n2;
        block2: {
            n2 = n;
            try {
                n2 = Integer.parseInt(this.getProperty(string));
            }
            catch (NumberFormatException numberFormatException) {
                if (!tr.isTraceActive()) break block2;
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Valor incorrecto asignado a la propiedad \"pPropertyName\": value=\"" + this.getProperty(string) + "\". Se usara el valor por defecto \"pDefault\"");
            }
        }
        return n2;
    }
}

