/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.control.apilamiento;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.control.apilamiento.Q70ApilamientoException;
import es.ejie.frmk.control.apilamiento.Q70ConfiguradorApilamiento;
import es.ejie.frmk.control.apilamiento.Q70EstructuraDialogo;
import es.ejie.frmk.control.apilamiento.Q70GestorDeApilamientoServidor;
import es.ejie.frmk.control.apilamiento.Q70Hash;
import es.ejie.frmk.control.arranque.Q70Arrancable;
import es.ejie.frmk.control.excepciones.Q70FrameworkException;
import es.ejie.frmk.control.excepciones.Q70GestorDeExcepciones;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.infraestructura.traza.Q70TrazaInterface;
import es.ejie.frmk.infraestructura.utilidades.general.Q70ObjectInputStream;
import es.ejie.frmk.infraestructura.utilidades.mapeador.Q70GestorMapeador;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.base.Q70PasosOPMapping;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import es.ejie.frmk.presentacion.sesiondatos.Q70SesionDatos;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.upload.MultipartRequestWrapper;

public class Q70GestorDeApilamiento
implements Q70Arrancable {
    private static final String SUBOPERACION_REMOTA = "subOperacionRemota";
    private static final String SUBOPERACION_LOCAL = "subOperacionLocal";
    private static final String REENVIO_REMOTO = "reenvioRemoto";
    private static final String REENVIO_LOCAL = "reenvioLocal";
    private static final String PREFIJO_REENVIO = "reenvio";
    private static final String PREFIJO_SUBOP = "subOperacion";
    private static final String HASH_CADUCADO = "hashCaducado";
    private static final String COMPONENTE = "GESTOR_APILAMIENTO";
    private static Q70Traza tr = Q70Traza.getSingleton();
    private static Q70GestorDeApilamiento instance = null;
    public static final String PILA_DIALOGO_KEY = "es.ejie.frmk.control.apilamiento.pila";

    private Q70GestorDeApilamiento() {
    }

    public static Q70GestorDeApilamiento getSingleton() {
        if (instance == null) {
            instance = new Q70GestorDeApilamiento();
        }
        return instance;
    }

    private String getDataSource() {
        return Q70GestorDeApilamientoServidor.getSingleton().getDataSource();
    }

    protected void setDataSource(String string) {
        Q70GestorDeApilamientoServidor.getSingleton().setDataSource(string);
    }

    private String getTable() {
        return Q70GestorDeApilamientoServidor.getSingleton().getTable();
    }

    protected void setTable(String string) {
        Q70GestorDeApilamientoServidor.getSingleton().setTable(string);
    }

    public void afterCreate(String string) throws Q70FrameworkException {
        try {
            Q70GestorDeApilamientoServidor.getSingleton().setXmlConfiguracion(string);
            Q70ConfiguradorApilamiento q70ConfiguradorApilamiento = new Q70ConfiguradorApilamiento(string);
            q70ConfiguradorApilamiento.lanzarConfigurador();
        }
        catch (Q70FrameworkException q70FrameworkException) {
            Q70TrazaInterface q70TrazaInterface = Q70Factoria.getTraza();
            if (q70TrazaInterface.isTraceActive()) {
                q70TrazaInterface.trace(COMPONENTE, Q70TraceLevel.ERROR, "Se ha producido un error en el m\u00e9todo afterCreate de la clase Q70GestorDeApilamiento");
            }
            throw new Q70FrameworkException(COMPONENTE, this.getClass().toString(), "afterCreate", "Se ha producido un error en el m\u00e9todo afterCreate.", (Throwable)q70FrameworkException);
        }
    }

    public void beforeDestroy() {
    }

    public void reConfigure() throws Q70FrameworkException {
        try {
            Q70GestorDeApilamientoServidor.getSingleton().setDataSource(null);
            this.afterCreate(Q70GestorDeApilamientoServidor.getSingleton().getXmlConfiguracion());
        }
        catch (Q70FrameworkException q70FrameworkException) {
            Q70TrazaInterface q70TrazaInterface = Q70Factoria.getTraza();
            if (q70TrazaInterface.isTraceActive()) {
                q70TrazaInterface.trace(COMPONENTE, Q70TraceLevel.ERROR, "Se ha producido un error en el m\u00e9todo reConfigure de la clase Q70GestorDeApilamiento");
            }
            throw new Q70FrameworkException(COMPONENTE, this.getClass().toString(), "reConfigure", "Se ha producido un error en el m\u00e9todo reConfigure.", (Throwable)q70FrameworkException);
        }
    }

    protected Q70EstructuraDialogo popDialog(HttpSession httpSession) {
        Stack stack = (Stack)httpSession.getAttribute(PILA_DIALOGO_KEY);
        if (null == stack || 0 == stack.size()) {
            return null;
        }
        return (Q70EstructuraDialogo)stack.pop();
    }

    protected Q70EstructuraDialogo peekDialog(HttpSession httpSession) {
        Stack stack = (Stack)httpSession.getAttribute(PILA_DIALOGO_KEY);
        if (null == stack || 0 == stack.size()) {
            return null;
        }
        return (Q70EstructuraDialogo)stack.peek();
    }

    protected Q70EstructuraDialogo pushDialog(HttpSession httpSession, Q70EstructuraDialogo q70EstructuraDialogo) {
        if (null != q70EstructuraDialogo) {
            Stack<Q70EstructuraDialogo> stack = (Stack<Q70EstructuraDialogo>)httpSession.getAttribute(PILA_DIALOGO_KEY);
            if (null == stack) {
                stack = new Stack<Q70EstructuraDialogo>();
            }
            stack.push(q70EstructuraDialogo);
            httpSession.setAttribute(PILA_DIALOGO_KEY, stack);
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Apilando dialogo de operaci\u00f3n. " + q70EstructuraDialogo.toString());
            }
        }
        return q70EstructuraDialogo;
    }

    protected void reset(HttpSession httpSession) {
        Stack stack = (Stack)httpSession.getAttribute(PILA_DIALOGO_KEY);
        if (null != stack) {
            stack.clear();
            stack = null;
            httpSession.setAttribute(PILA_DIALOGO_KEY, (Object)stack);
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, "La pila del gestor de apilamiento ha sido reiniciada.");
            }
        }
    }

    public boolean isReturnToSuperOp(HttpServletRequest httpServletRequest, String string) throws Q70FrameworkException {
        boolean bl = false;
        try {
            Q70EstructuraDialogo q70EstructuraDialogo;
            if (null != string && string.equalsIgnoreCase("end") && null != (q70EstructuraDialogo = this.peekDialog(httpServletRequest.getSession()))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new Q70ApilamientoException(this.getClass().toString(), "isReturnToSuperOp", "Error al comprobar si era un retorno de una suboperaci\u00f3n.", exception);
        }
        return bl;
    }

    protected boolean processSubOpEnd(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Q70PasosOPMapping q70PasosOPMapping, ActionServlet actionServlet) throws Q70FrameworkException {
        Q70EstructuraDialogo q70EstructuraDialogo = null;
        try {
            if (null != q70PasosOPMapping.getSubOp() && q70PasosOPMapping.getSubOp().equalsIgnoreCase("end")) {
                Object object;
                Object object2;
                if (httpServletRequest instanceof MultipartRequestWrapper) {
                    httpServletRequest = ((MultipartRequestWrapper)httpServletRequest).getRequest();
                }
                try {
                    object2 = httpServletRequest.getSession();
                    object = (Q70ContextoEJIE)object2.getAttribute("contexto");
                    q70EstructuraDialogo = this.popDialog((HttpSession)object2);
                    if (null != q70EstructuraDialogo) {
                        Q70ContextoEJIE q70ContextoEJIE = q70EstructuraDialogo.getContexto();
                        if (null == q70EstructuraDialogo.getHash()) {
                            ArrayList<Q70ContextoEJIE> arrayList = new ArrayList<Q70ContextoEJIE>(1);
                            arrayList.add(Q70SesionDatos.getSingleton().getContexto(object, "APLICACION"));
                            List list = Q70SesionDatos.getSingleton().getListaContextos(object);
                            object = Q70SesionDatos.getSingleton().addListaContextos(object, arrayList);
                            Q70GestorMapeador q70GestorMapeador = Q70GestorMapeador.getSingleton();
                            q70GestorMapeador.mapObjects("todas", object, (Object)q70ContextoEJIE);
                            object = Q70SesionDatos.getSingleton().addListaContextos(object, list);
                            object2.setAttribute("contexto", (Object)q70ContextoEJIE);
                            if (tr.isTraceActive()) {
                                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Contexto de superOperacion " + q70ContextoEJIE.getIdContexto() + " antes de retorno de la subOperaci\u00f3n " + object.getIdContexto());
                            }
                        } else {
                            q70EstructuraDialogo.setContexto(object);
                        }
                    }
                }
                catch (Exception exception) {
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\u00f3n mapeando el contexto de la suboperaci\u00f3n al contexto de la operaci\u00f3n.");
                    }
                    throw new Q70ApilamientoException(this.getClass().toString(), "processSubOpEnd", "Excepci\u00f3n mapeando el contexto de la suboperaci\u00f3n al contexto de la operaci\u00f3n.", exception);
                }
                if (null == q70EstructuraDialogo) {
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Operaci\u00f3n no invocada como suboperaci\u00f3n");
                    }
                    return true;
                }
                object2 = q70EstructuraDialogo.getRetPath();
                if (null == object2) {
                    return true;
                }
                if (null != q70EstructuraDialogo.getHash()) {
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Operaci\u00f3n invocada como suboperaci\u00f3n remota [Retorno: " + (String)object2 + "]");
                    }
                    this.updateEstructuraDialogoEnBD(q70EstructuraDialogo);
                    httpServletRequest.getSession().invalidate();
                    object = ((String)object2).indexOf("?") == -1 ? (String)object2 + "?" : (String)object2 + "&";
                    object = (String)object + this.getNombreParametroUrlRemota(q70EstructuraDialogo) + q70EstructuraDialogo.getHash();
                    httpServletResponse.sendRedirect((String)object);
                    return false;
                }
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Operaci\u00f3n invocada como suboperaci\u00f3n [Retorno: " + (String)object2 + "]");
                }
                if ((object = actionServlet.getServletContext().getRequestDispatcher((String)object2)) == null) {
                    httpServletResponse.sendError(500, actionServlet.getInternal().getMessage("requestDispatcher", object2));
                    return true;
                }
                object.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            throw new Q70ApilamientoException(this.getClass().toString(), "processSubOpEnd", "Excepci\u00f3n de IO", iOException);
        }
        catch (ServletException servletException) {
            throw new Q70ApilamientoException(this.getClass().toString(), "processSubOpEnd", "Excepci\u00f3n de Servlet", servletException);
        }
        catch (Exception exception) {
            throw new Q70ApilamientoException(this.getClass().toString(), "processSubOpEnd", "Excepci\u00f3n al procesar el retorno de la subOperaci\u00f3n a la superOperaci\u00f3n (op. invocante)", exception);
        }
    }

    protected void processSuperOpInit(HttpSession httpSession, Q70PasosOPMapping q70PasosOPMapping, Q70ContextoEJIE q70ContextoEJIE) throws Q70FrameworkException {
        String string = this.dameTipoOperacion(q70PasosOPMapping, null);
        if (null != q70PasosOPMapping.getMapa() && !q70PasosOPMapping.getMapa().trim().equals("")) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Procesando mapeo para el contexto. Mapeo: " + q70PasosOPMapping.getMapa());
            }
            try {
                Q70GestorMapeador.getSingleton().mapObjects(q70PasosOPMapping.getMapa(), (Object)q70ContextoEJIE, (Object)q70ContextoEJIE);
                httpSession.setAttribute("contexto", (Object)q70ContextoEJIE);
            }
            catch (Exception exception) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "ERROR Procesando mapeo para el contexto. Mapeo: " + q70PasosOPMapping.getMapa());
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "processSuperOpInit", "ERROR Procesando mapeo para el contexto. Mapeo: " + q70PasosOPMapping.getMapa(), exception);
            }
        }
        String string2 = null;
        Q70EstructuraDialogo q70EstructuraDialogo = new Q70EstructuraDialogo();
        try {
            String string3;
            if (string.startsWith(PREFIJO_SUBOP)) {
                string3 = q70PasosOPMapping.getSubOpRetPath();
                if (string.equals(SUBOPERACION_REMOTA)) {
                    string3 = Q70ListenerUtils.getRemoteURI((String)string3, (HttpSession)httpSession);
                }
                q70EstructuraDialogo.setRetPath(string3);
            }
            q70EstructuraDialogo.setContexto(q70ContextoEJIE);
            if (null != q70PasosOPMapping.getCallOpRemota() && (q70PasosOPMapping.getCallOpRemota().trim().equalsIgnoreCase("init") || q70PasosOPMapping.getCallOpRemota().trim().equalsIgnoreCase(PREFIJO_REENVIO))) {
                if (tr.isTraceActive()) {
                    string2 = REENVIO_REMOTO.equals(string) ? "Realizando un reenv\u00edo remoto con paso de par\u00e1metros." : "Llamando a suboperaci\u00f3n remota.";
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, string2);
                }
                string3 = Q70Hash.generateHash();
                q70EstructuraDialogo.setHash(string3);
                q70EstructuraDialogo.setPosteriorVersionUno(this.isPosteriorVersionUno(q70PasosOPMapping));
                this.insertEstructuraDialogoEnBD(q70EstructuraDialogo);
            } else if (tr.isTraceActive() && REENVIO_LOCAL.equals(string)) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Realizando un reenv\u00edo local con paso de par\u00e1metros.");
            }
            this.pushDialog(httpSession, q70EstructuraDialogo);
        }
        catch (Exception exception) {
            if (tr.isTraceActive()) {
                string2 = REENVIO_REMOTO.equals(string) ? "Excepci\u00f3n en el tratamiento de la estructura de dialogo al realizar el reenv\u00edo remoto." : (REENVIO_LOCAL.equals(string) ? "Excepci\u00f3n apilando la estructura de dialogo para un reenv\u00edo local." : "Excepci\u00f3n apilando la estructura de dialogo para una suboperaci\u00f3n.");
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, string2);
            }
            throw new Q70ApilamientoException(this.getClass().toString(), "processSuperOpInit", string2, exception);
        }
    }

    public void processSuperOpReset(HttpSession httpSession) throws Q70FrameworkException {
        Stack stack = (Stack)httpSession.getAttribute(PILA_DIALOGO_KEY);
        if (null != stack) {
            int n = stack.size();
            for (int i = 0; i < n; ++i) {
                String string;
                Q70EstructuraDialogo q70EstructuraDialogo = this.popDialog(httpSession);
                if (null == q70EstructuraDialogo || null == (string = q70EstructuraDialogo.getHash()) || "".equals(string)) continue;
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Eliminando estructura de di\u00e1logo de BD.");
                }
                this.deleteEstructuraDialogoEnBD(string);
            }
            this.reset(httpSession);
        }
    }

    protected void processSubOpInit(HttpServletRequest httpServletRequest, Q70ContextoEJIE q70ContextoEJIE, Q70PasosOPMapping q70PasosOPMapping) throws Q70FrameworkException {
        Q70ContextoEJIE q70ContextoEJIE2 = null;
        Collection collection = null;
        Q70EstructuraDialogo q70EstructuraDialogo = null;
        Q70GestorMapeador q70GestorMapeador = null;
        String string = null;
        String string2 = this.dameTipoOperacion(q70PasosOPMapping, this.getHashNoCaducado(httpServletRequest));
        string = REENVIO_LOCAL.equals(string2) ? "Reenv\u00edo local con paso de par\u00e1metros." : (REENVIO_REMOTO.equals(string2) ? "Reenv\u00edo remoto con paso de par\u00e1metros." : "Suboperaci\u00f3n con apilamiento.");
        try {
            if (null != this.getHashNoCaducado(httpServletRequest)) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, string);
                }
                q70EstructuraDialogo = this.selectEstructuraDialogoEnBD(this.getHashDeLaRequest(httpServletRequest), this.isPosteriorVersionUno(httpServletRequest));
                httpServletRequest.setAttribute(HASH_CADUCADO, (Object)this.getHashDeLaRequest(httpServletRequest));
                if (SUBOPERACION_REMOTA.equals(string2)) {
                    this.pushDialog(httpServletRequest.getSession(), q70EstructuraDialogo);
                }
            }
            if (REENVIO_LOCAL.equals(string2)) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, string);
                }
                q70EstructuraDialogo = this.popDialog(httpServletRequest.getSession());
            } else if (REENVIO_REMOTO.equals(string2)) {
                this.deleteEstructuraDialogoEnBD(this.getHashDeLaRequest(httpServletRequest));
            } else {
                q70EstructuraDialogo = this.peekDialog(httpServletRequest.getSession());
            }
            if (null != q70EstructuraDialogo && q70EstructuraDialogo.getHash() != null) {
                collection = q70EstructuraDialogo.getListaAtributos();
                q70GestorMapeador = Q70GestorMapeador.getSingleton();
                q70GestorMapeador.mapObjects("todas_lista", (Object)collection, (Object)q70ContextoEJIE);
            } else if (null != q70EstructuraDialogo) {
                q70ContextoEJIE2 = q70EstructuraDialogo.getContexto();
                List list = Q70SesionDatos.getSingleton().getListaContextos(q70ContextoEJIE2);
                q70ContextoEJIE2 = Q70SesionDatos.getSingleton().addListaContextos(q70ContextoEJIE2, null);
                q70GestorMapeador = Q70GestorMapeador.getSingleton();
                q70GestorMapeador.mapObjects("todas", (Object)q70ContextoEJIE2, (Object)q70ContextoEJIE);
                q70ContextoEJIE2 = Q70SesionDatos.getSingleton().addListaContextos(q70ContextoEJIE2, list);
            } else if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, "SubOperacion invocada como operaci\u00f3n principal.");
            }
        }
        catch (Exception exception) {
            string = string2.startsWith(PREFIJO_REENVIO) ? "l reenv\u00edo" : " la suboperaci\u00f3n";
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\u00f3n mapeando el contexto de la operaci\u00f3n al contexto de" + string);
            }
            throw new Q70ApilamientoException(this.getClass().toString(), "processSubOpInit", "Excepci\u00f3n mapeando el contexto de la operaci\u00f3n al contexto de" + string, exception);
        }
    }

    protected void processSuperOpEnd(HttpServletRequest httpServletRequest, Q70PasosOPMapping q70PasosOPMapping) throws Q70FrameworkException {
        block7: {
            String string;
            Q70EstructuraDialogo q70EstructuraDialogo = null;
            String string2 = this.getStoredHash(httpServletRequest, q70PasosOPMapping);
            if (null != string2 && null != (string = this.getHashDeLaRequest(httpServletRequest)) && string.equals(string2)) {
                try {
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Procesando el retorno de una suboperaci\u00f3n con apilamiento remoto.");
                    }
                    q70EstructuraDialogo = this.popDialog(httpServletRequest.getSession());
                    if (null != (q70EstructuraDialogo = this.selectEstructuraDialogoEnBD(q70EstructuraDialogo.getHash(), q70EstructuraDialogo.isPosteriorVersionUno())).getListaAtributos()) {
                        Collection collection = q70EstructuraDialogo.getListaAtributos();
                        Q70ContextoEJIE q70ContextoEJIE = (Q70ContextoEJIE)httpServletRequest.getSession().getAttribute("contexto");
                        Q70GestorMapeador q70GestorMapeador = Q70GestorMapeador.getSingleton();
                        q70GestorMapeador.mapObjects("todas_lista", (Object)collection, (Object)q70ContextoEJIE);
                        httpServletRequest.getSession().setAttribute("contexto", (Object)q70ContextoEJIE);
                        this.deleteEstructuraDialogoEnBD(string);
                        if (tr.isTraceActive()) {
                            tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Fin del apilamiento.");
                        }
                        break block7;
                    }
                    throw new Exception("El contexto que se ha recuperado de la Base de Datos es nulo.");
                }
                catch (Exception exception) {
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\u00f3n procesando el retorno de una suboperaci\u00f3n remota.");
                    }
                    throw new Q70ApilamientoException(this.getClass().toString(), "processSuperOpEnd", "Excepci\u00f3n procesando el retorno de una suboperaci\u00f3n remota.", exception);
                }
            }
        }
    }

    public String getStoredHash(HttpServletRequest httpServletRequest, Q70PasosOPMapping q70PasosOPMapping) {
        String string = null;
        Q70EstructuraDialogo q70EstructuraDialogo = null;
        q70EstructuraDialogo = null != q70PasosOPMapping && PREFIJO_REENVIO.equals(q70PasosOPMapping.getCallOpRemota()) && "init".equals(q70PasosOPMapping.getOpReenvio()) ? this.popDialog(httpServletRequest.getSession()) : this.peekDialog(httpServletRequest.getSession());
        if (null != q70EstructuraDialogo) {
            string = q70EstructuraDialogo.getHash();
        }
        return string;
    }

    protected void insertEstructuraDialogoEnBD(Q70EstructuraDialogo q70EstructuraDialogo) throws Q70FrameworkException {
        Connection connection = null;
        try {
            if (null == this.getDataSource()) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Falta la propiedad dataSource en el fichero XML de configuraci\u00f3n del gestor de apilamiento.");
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "insertEstructuraDialogoEnBD", "Falta la propiedad dataSource en el fichero XML de configuraci\u00f3n del gestor de apilamiento.", null);
            }
            if (null == this.getTable()) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Falta la propiedad tabla en el fichero XML de configuraci\u00f3n del gestor de apilamiento.");
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "insertEstructuraDialogoEnBD", "Falta la propiedad tabla en el fichero XML de configuraci\u00f3n del gestor de apilamiento.", null);
            }
            connection = Q70ConectorJDBC.getSingleton().getConnection(this.getDataSource());
            connection.setAutoCommit(false);
            if (q70EstructuraDialogo.isPosteriorVersionUno()) {
                this.insertMultiFila(connection, q70EstructuraDialogo);
            } else {
                this.insertFilaUnica(connection, q70EstructuraDialogo);
            }
            connection.setAutoCommit(true);
            connection.close();
        }
        catch (Exception exception) {
            this.doCerrarCorrectamenteBD(null, null, connection);
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error insertando la estructura de dialogo en la Base de Datos para un apilamiento remoto.");
            }
            throw new Q70ApilamientoException(this.getClass().toString(), "insertEstructuraDialogoEnBD", "Error insertando la estructura de dialogo en la Base de Datos para un apilamiento remoto.", exception);
        }
    }

    private void insertMultiFila(Connection connection, Q70EstructuraDialogo q70EstructuraDialogo) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException, Q70ApilamientoException {
        Collection collection = q70EstructuraDialogo.getListaAtributos();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            PreparedStatement preparedStatement = connection.prepareStatement("insert into " + this.getTable() + " (HASH, NBR_ATRIBUTO, RETPATH, TIMESTAMP, CTXOOPAP) values (?,?,?,?,empty_blob())");
            preparedStatement.setString(1, q70EstructuraDialogo.getHash());
            preparedStatement.setString(2, (String)list.get(0));
            preparedStatement.setString(3, null == q70EstructuraDialogo.getRetPath() ? "Reenvio" : q70EstructuraDialogo.getRetPath());
            preparedStatement.setDate(4, new Date(System.currentTimeMillis()));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("select CTXOOPAP from " + this.getTable() + " where HASH=? and NBR_ATRIBUTO=? for update");
            preparedStatement.setString(1, q70EstructuraDialogo.getHash());
            preparedStatement.setString(2, (String)list.get(0));
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Blob blob = resultSet.getBlob("CTXOOPAP");
                Class<?> clazz = blob.getClass();
                Method method = clazz.getMethod("getBinaryOutputStream", new Class[0]);
                OutputStream outputStream = (OutputStream)method.invoke((Object)blob, new Object[0]);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                try {
                    objectOutputStream.writeObject(list.get(1));
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    connection.commit();
                }
                catch (IOException iOException) {
                    this.doCerrarCorrectamenteBD(resultSet, preparedStatement, connection);
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error serializando el campo de contexto '" + list.get(0) + "' que se iba a almacenar en Base de Datos.");
                    }
                    throw new Q70ApilamientoException(this.getClass().toString(), "insertEstructuraDialogoEnBD", "Error serializando el contexto para ser almacenado en Base de Datos.", iOException);
                }
            }
            resultSet.close();
            preparedStatement.close();
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Se han insertado '" + q70EstructuraDialogo.getListaAtributos() + "' atributos del contexto en total en la estructura de dialogo para el apilamiento remoto y correctamente en la Base de Datos.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertFilaUnica(Connection connection, Q70EstructuraDialogo q70EstructuraDialogo) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException, Q70ApilamientoException {
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + this.getTable() + " (HASH, NBR_ATRIBUTO, RETPATH, CTXOOPAP) values (?,?,?,empty_blob())");
        preparedStatement.setString(1, q70EstructuraDialogo.getHash());
        preparedStatement.setString(2, "CONTEXTO ALMACENADO POR VERSION POSTERIOR A 1.x");
        preparedStatement.setString(3, q70EstructuraDialogo.getRetPath());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select CTXOOPAP from " + this.getTable() + " where HASH=? for update");
        preparedStatement.setString(1, q70EstructuraDialogo.getHash());
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            Blob blob = resultSet.getBlob("CTXOOPAP");
            Class<?> clazz = blob.getClass();
            Method method = clazz.getMethod("getBinaryOutputStream", new Class[0]);
            OutputStream outputStream = (OutputStream)method.invoke((Object)blob, new Object[0]);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            ArrayList<Q70ContextoEJIE> arrayList = new ArrayList<Q70ContextoEJIE>(1);
            arrayList.add(Q70SesionDatos.getSingleton().getContexto(q70EstructuraDialogo.getContexto(), "APLICACION"));
            List list = Q70SesionDatos.getSingleton().getListaContextos(q70EstructuraDialogo.getContexto());
            q70EstructuraDialogo.setContexto(Q70SesionDatos.getSingleton().addListaContextos(q70EstructuraDialogo.getContexto(), arrayList));
            try {
                try {
                    objectOutputStream.writeObject(q70EstructuraDialogo.getContexto());
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    connection.commit();
                }
                catch (IOException iOException) {
                    this.doCerrarCorrectamenteBD(resultSet, preparedStatement, connection);
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error serializando el contexto para ser almacenado en Base de Datos.");
                    }
                    throw new Q70ApilamientoException(this.getClass().toString(), "insertEstructuraDialogoEnBD", "Error serializando el contexto para ser almacenado en Base de Datos.", iOException);
                }
                Object var14_12 = null;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                q70EstructuraDialogo.setContexto(Q70SesionDatos.getSingleton().addListaContextos(q70EstructuraDialogo.getContexto(), list));
                throw throwable;
            }
            q70EstructuraDialogo.setContexto(Q70SesionDatos.getSingleton().addListaContextos(q70EstructuraDialogo.getContexto(), list));
        }
        resultSet.close();
        preparedStatement.close();
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, "APILAMIENTO REMOTO PROCEDENTE GEREMUA VERSION 1.x: La estructura de dialogo para el apilamiento remoto se ha almacenado correctamente en la Base de Datos.");
        }
    }

    protected Q70EstructuraDialogo selectEstructuraDialogoEnBD(String string, boolean bl) throws Q70FrameworkException {
        Q70EstructuraDialogo q70EstructuraDialogo = null;
        Connection connection = null;
        try {
            if (null == this.getDataSource()) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Falta la propiedad dataSource en el fichero XML de configuraci\u00f3n del gestor de apilamiento.");
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "selectEstructuraDialogoEnBD", "Falta la propiedad dataSource en el fichero XML de configuraci\u00f3n del gestor de apilamiento.", null);
            }
            if (null == this.getTable()) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Falta la propiedad tabla en el fichero XML de configuraci\u00f3n del gestor de apilamiento.");
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "selectEstructuraDialogoEnBD", "Falta la propiedad tabla en el fichero XML de configuraci\u00f3n del gestor de apilamiento.", null);
            }
            connection = Q70ConectorJDBC.getSingleton().getConnection(this.getDataSource());
            if (bl) {
                q70EstructuraDialogo = this.selectMultiFila(connection, string);
                if (null != q70EstructuraDialogo) {
                    q70EstructuraDialogo.setPosteriorVersionUno(true);
                }
            } else {
                q70EstructuraDialogo = this.selectFilaUnica(connection, string);
                if (null != q70EstructuraDialogo) {
                    q70EstructuraDialogo.setPosteriorVersionUno(false);
                }
            }
            connection.close();
            if (null != q70EstructuraDialogo) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, "La estructura de dialogo para el apilamiento remoto se ha recuperado correctamente de la Base de Datos.");
                }
                return q70EstructuraDialogo;
            }
            throw new Exception("No se ha encontrado una estructura de dialogo con dicho hash.");
        }
        catch (Exception exception) {
            this.doCerrarCorrectamenteBD(null, null, connection);
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error recuperando la estructura de dialogo de la Base de Datos para un apilamiento remoto.");
            }
            throw new Q70ApilamientoException(this.getClass().toString(), "selectEstructuraDialogoEnBD", "Error recuperando la estructura de dialogo de la Base de Datos para un apilamiento remoto.", exception);
        }
    }

    private Q70EstructuraDialogo selectMultiFila(Connection connection, String string) throws SQLException, Q70ApilamientoException {
        Q70EstructuraDialogo q70EstructuraDialogo = null;
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement("select HASH, NBR_ATRIBUTO, RETPATH, CTXOOPAP from " + this.getTable() + " where HASH = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            HashSet hashSet = new HashSet(11);
            q70EstructuraDialogo = new Q70EstructuraDialogo();
            q70EstructuraDialogo.setHash(resultSet.getString(1));
            q70EstructuraDialogo.setRetPath(resultSet.getString(3));
            do {
                InputStream inputStream = null;
                try {
                    inputStream = resultSet.getBinaryStream(4);
                    Q70ObjectInputStream q70ObjectInputStream = new Q70ObjectInputStream(inputStream);
                    Object object = q70ObjectInputStream.readObject();
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(resultSet.getString(2));
                    arrayList.add(object);
                    hashSet.add(arrayList);
                    q70ObjectInputStream.close();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!tr.isTraceActive()) continue;
                    tr.trace(COMPONENTE, Q70TraceLevel.WARN, "Deserializando el contexto de Base de Datos. No existe el bean '" + classNotFoundException.getMessage() + "'");
                }
                catch (Exception exception) {
                    this.doCerrarCorrectamenteBD(resultSet, preparedStatement, connection);
                    if (tr.isTraceActive()) {
                        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error deserializando el contexto al ser recuperado de Base de Datos.");
                    }
                    throw new Q70ApilamientoException(this.getClass().toString(), "selectEstructuraDialogoEnBD", "Error deserializando el contexto al ser recuperado de Base de Datos.", exception);
                }
            } while (resultSet.next());
            q70EstructuraDialogo.setListaAtributos(hashSet);
        }
        preparedStatement.close();
        return q70EstructuraDialogo;
    }

    private Q70EstructuraDialogo selectFilaUnica(Connection connection, String string) throws SQLException, Q70ApilamientoException {
        Q70EstructuraDialogo q70EstructuraDialogo = null;
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement("select HASH, RETPATH, CTXOOPAP from " + this.getTable() + " where HASH = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            q70EstructuraDialogo = new Q70EstructuraDialogo();
            q70EstructuraDialogo.setHash(resultSet.getString(1));
            q70EstructuraDialogo.setRetPath(resultSet.getString(2));
            InputStream inputStream = null;
            try {
                inputStream = resultSet.getBinaryStream(3);
                Q70ObjectInputStream q70ObjectInputStream = new Q70ObjectInputStream(inputStream);
                q70EstructuraDialogo.setContexto((Q70ContextoEJIE)q70ObjectInputStream.readObject());
                q70ObjectInputStream.close();
            }
            catch (Exception exception) {
                this.doCerrarCorrectamenteBD(resultSet, preparedStatement, connection);
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error deserializando el contexto al ser recuperado de Base de Datos.");
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "selectEstructuraDialogoEnBD", "Error deserializando el contexto al ser recuperado de Base de Datos.", exception);
            }
        }
        preparedStatement.close();
        return q70EstructuraDialogo;
    }

    protected void updateEstructuraDialogoEnBD(Q70EstructuraDialogo q70EstructuraDialogo) throws Q70FrameworkException {
        this.deleteEstructuraDialogoEnBD(q70EstructuraDialogo.getHash());
        this.insertEstructuraDialogoEnBD(q70EstructuraDialogo);
    }

    protected void deleteEstructuraDialogoEnBD(String string) throws Q70FrameworkException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            if (null == this.getDataSource()) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Falta la propiedad dataSource en el fichero XML de configuraci\u00f3n del gestor de apilamiento.");
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "deleteEstructuraDialogoEnBD", "Falta la propiedad dataSource en el fichero XML de configuraci\u00f3n del gestor de apilamiento.", null);
            }
            if (null == this.getTable()) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Falta la propiedad tabla en el fichero XML de configuraci\u00f3n del gestor de apilamiento.");
                }
                throw new Q70ApilamientoException(this.getClass().toString(), "deleteEstructuraDialogoEnBD", "Falta la propiedad tabla en el fichero XML de configuraci\u00f3n del gestor de apilamiento.", null);
            }
            connection = Q70ConectorJDBC.getSingleton().getConnection(this.getDataSource());
            preparedStatement = connection.prepareStatement("delete from " + this.getTable() + " where HASH = ?");
            preparedStatement.setString(1, string);
            int n = preparedStatement.executeUpdate();
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, "La estructura de dialogo para el apilamiento remoto se ha eliminado correctamente de la Base de Datos. Se han eliminado " + n + " filas.");
            }
            preparedStatement.close();
            connection.close();
        }
        catch (Exception exception) {
            this.doCerrarCorrectamenteBD(null, preparedStatement, connection);
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error eliminando la estructura de dialogo en la Base de Datos para el apilamiento remoto.");
            }
            throw new Q70ApilamientoException(this.getClass().toString(), "deleteEstructuraDialogoEnBD", "Error eliminando la estructura de dialogo en la Base de Datos para el apilamiento remoto.", exception);
        }
    }

    public boolean processApilamiento(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Q70PasosOPMapping q70PasosOPMapping, Q70ContextoEJIE q70ContextoEJIE, ActionServlet actionServlet) throws Q70FrameworkException {
        if (null == q70ContextoEJIE) {
            return this.processSubOpEnd(httpServletRequest, httpServletResponse, q70PasosOPMapping, actionServlet);
        }
        if (null != q70PasosOPMapping.getSubOp() && q70PasosOPMapping.getSubOp().equalsIgnoreCase("reset")) {
            this.processSuperOpReset(httpServletRequest.getSession());
        }
        if (null != q70PasosOPMapping.getSubOp() && q70PasosOPMapping.getSubOp().equalsIgnoreCase("init") || null != q70PasosOPMapping.getOpReenvio() && q70PasosOPMapping.getOpReenvio().equalsIgnoreCase("end")) {
            this.processSubOpInit(httpServletRequest, q70ContextoEJIE, q70PasosOPMapping);
        } else if (null != q70PasosOPMapping.getSubOpRetPath() && !q70PasosOPMapping.getSubOpRetPath().trim().equals("") || null != q70PasosOPMapping.getOpReenvio() && q70PasosOPMapping.getOpReenvio().trim().equals("init")) {
            this.processSuperOpInit(httpServletRequest.getSession(), q70PasosOPMapping, q70ContextoEJIE);
        } else if (null != q70PasosOPMapping.getCallOpRemota() && q70PasosOPMapping.getCallOpRemota().trim().equalsIgnoreCase("end")) {
            this.processSuperOpEnd(httpServletRequest, q70PasosOPMapping);
        }
        return true;
    }

    private String dameTipoOperacion(Q70PasosOPMapping q70PasosOPMapping, String string) {
        String string2 = null;
        string2 = null == q70PasosOPMapping.getCallOpRemota() && null != q70PasosOPMapping.getOpReenvio() && null == string ? REENVIO_LOCAL : (null == q70PasosOPMapping.getCallOpRemota() && null != q70PasosOPMapping.getOpReenvio() || null != q70PasosOPMapping.getCallOpRemota() && q70PasosOPMapping.getCallOpRemota().trim().equalsIgnoreCase(PREFIJO_REENVIO) ? REENVIO_REMOTO : (null == q70PasosOPMapping.getCallOpRemota() && null == string ? SUBOPERACION_LOCAL : SUBOPERACION_REMOTA));
        return string2;
    }

    private String getHashNoCaducado(HttpServletRequest httpServletRequest) {
        String string = null;
        if (!(this.getHashDeLaRequest(httpServletRequest) == null || httpServletRequest.getAttribute(HASH_CADUCADO) != null && this.getHashDeLaRequest(httpServletRequest).equals(httpServletRequest.getAttribute(HASH_CADUCADO)))) {
            string = this.getHashDeLaRequest(httpServletRequest);
        }
        return string;
    }

    private boolean isPosteriorVersionUno(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getParameter("HASH_GER") != null && !httpServletRequest.getParameter("HASH_GER").equals("")) {
            return true;
        }
        return httpServletRequest.getParameter("HASH") == null || httpServletRequest.getParameter("HASH").equals("");
    }

    private boolean isPosteriorVersionUno(Q70PasosOPMapping q70PasosOPMapping) {
        return "HASH_GER=".equalsIgnoreCase(this.getNombreParametroUrlRemota(q70PasosOPMapping));
    }

    private String getHashDeLaRequest(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("HASH_GER");
        if (string == null || string.equals("")) {
            string = httpServletRequest.getParameter("HASH");
        }
        return string;
    }

    public String getNombreParametroUrlRemota(Q70PasosOPMapping q70PasosOPMapping) {
        return this.getNombreParametroUrlRemota("init".equalsIgnoreCase(q70PasosOPMapping.getOpVersion1()));
    }

    private String getNombreParametroUrlRemota(Q70EstructuraDialogo q70EstructuraDialogo) {
        return this.getNombreParametroUrlRemota(!q70EstructuraDialogo.isPosteriorVersionUno());
    }

    private String getNombreParametroUrlRemota(boolean bl) {
        if (bl) {
            return "HASH=";
        }
        return "HASH_GER=";
    }

    private void doCerrarCorrectamenteBD(ResultSet resultSet, PreparedStatement preparedStatement, Connection connection) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            Q70GestorDeExcepciones.getSingleton().recogerThrowable(sQLException);
        }
    }
}

